/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import java.util.Collection;
import java.util.List;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.random.Distribution;
import org.ojalgo.random.Random1D;
import org.ojalgo.random.process.RandomProcess;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public final class Process1D<P extends ComponentProcess<?>> {
    private final Random1D myGenerator;
    private final P[] myProcesses;

    public static <P extends ComponentProcess<?>> Process1D<P> of(Access2D<?> correlations, List<? extends P> processes) {
        return new Process1D(new Random1D(correlations), Process1D.toArray(processes));
    }

    public static <P extends ComponentProcess<?>> Process1D<P> of(Access2D<?> correlations, P ... processes) {
        return new Process1D(new Random1D(correlations), processes);
    }

    public static <P extends ComponentProcess<?>> Process1D<P> of(List<? extends P> processes) {
        return new Process1D(new Random1D(processes.size()), Process1D.toArray(processes));
    }

    public static <P extends ComponentProcess<?>> Process1D<P> of(P ... processes) {
        return new Process1D(new Random1D(processes.length), processes);
    }

    static <P extends ComponentProcess<?>> P[] toArray(Collection<? extends P> processes) {
        return processes.toArray(new ComponentProcess[processes.size()]);
    }

    Process1D(Random1D generator, P ... processes) {
        this.myGenerator = generator;
        this.myProcesses = processes;
    }

    public double getValue(int index) {
        return this.myProcesses[index].getValue();
    }

    public ArrayR064 getValues() {
        int length = this.myProcesses.length;
        ArrayR064 retVal = ArrayR064.make(length);
        for (int p = 0; p < length; ++p) {
            retVal.set((long)p, this.myProcesses[p].getValue());
        }
        return retVal;
    }

    public void setValue(int index, double newValue) {
        this.myProcesses[index].setValue(newValue);
    }

    public void setValues(Access1D<?> newValues) {
        for (int p = 0; p < this.myProcesses.length; ++p) {
            this.myProcesses[p].setValue(newValues.doubleValue(p));
        }
    }

    public int size() {
        return this.myProcesses.length;
    }

    public Array1D<Double> step(double stepSize) {
        Array1D<Double> retVal = this.myGenerator.nextGaussian();
        for (int p = 0; p < this.myProcesses.length; ++p) {
            double standardGaussianInnovation = retVal.doubleValue(p);
            double nextValue = this.myProcesses[p].step(stepSize, standardGaussianInnovation);
            retVal.set((long)p, nextValue);
        }
        return retVal;
    }

    static interface ComponentProcess<D extends Distribution>
    extends RandomProcess<D> {
        public double getValue();

        public void setValue(double var1);

        public double step(double var1, double var3);
    }
}

