/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.scedasticity;

import java.util.Arrays;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.random.scedasticity.ScedasticityModel;
import org.ojalgo.structure.Access1D;

abstract class AbstractScedasticity
implements ScedasticityModel {
    static final double DEFAULT_VARIANCE = PrimitiveMath.HUNDREDTH * PrimitiveMath.HUNDREDTH;
    static final double ELEVEN_TWELFTHS = PrimitiveMath.ELEVEN / PrimitiveMath.TWELVE;

    static void average(double[] weights, double total) {
        Arrays.fill(weights, total / (double)weights.length);
    }

    static void decreasing(double[] weights, double total) {
        int length = weights.length;
        double weight = total;
        if (length == 1) {
            weights[0] = weight;
        } else if (length != 0) {
            for (int i = 0; i < length; ++i) {
                weights[i] = weight /= PrimitiveMath.TWO;
            }
            weights[length - 1] = weights[length - 2];
        }
    }

    static Access1D<?> parameters(Access1D<?> series, double mean, int q) {
        int nbVars = q;
        int nbEquations = series.size();
        if (q + nbVars > nbEquations) {
            throw new IllegalArgumentException();
        }
        Primitive64Store body = (Primitive64Store)Primitive64Store.FACTORY.make(nbEquations, nbVars);
        Primitive64Store rhs = (Primitive64Store)Primitive64Store.FACTORY.make(nbEquations, 1);
        for (int i = 0; i < nbEquations; ++i) {
            double value = series.doubleValue(i);
            double error = value - mean;
            double squared = error * error;
            rhs.set((long)i, squared);
            body.fillDiagonal((long)(i + 1), 0L, squared);
        }
        QR qr = (QR)QR.PRIMITIVE.make(nbEquations, nbVars);
        qr.compute(body.offsets(q, -1L));
        return qr.getSolution(rhs.offsets(q, -1L));
    }

    AbstractScedasticity() {
    }
}

