/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.tensor;

import org.ojalgo.function.FunctionSet;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.math.MathType;

public final class TensorFactory1D<N extends Comparable<N>, T extends Mutate1D>
implements Factory1D<T> {
    private final Factory1D<T> myFactory;

    public static <N extends Comparable<N>, T extends Mutate1D> TensorFactory1D<N, T> of(Factory1D<T> factory) {
        return new TensorFactory1D<N, T>(factory);
    }

    TensorFactory1D(Factory1D<T> factory) {
        this.myFactory = factory;
    }

    public T copy(Access1D<N> elements) {
        Mutate1D retVal = (Mutate1D)this.myFactory.make(elements);
        for (long i = 0L; i < elements.count(); ++i) {
            retVal.set(i, (Comparable<?>)elements.get(i));
        }
        return (T)retVal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof TensorFactory1D)) {
            return false;
        }
        TensorFactory1D other = (TensorFactory1D)obj;
        return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
    }

    public FunctionSet<N> function() {
        return this.myFactory.function();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
    }

    @Override
    public T make(long count) {
        return (T)((Mutate1D)this.myFactory.make(count));
    }

    public Scalar.Factory<N> scalar() {
        return this.myFactory.scalar();
    }

    public T sum(Access1D<N> ... vectors) {
        long dimensions = 0L;
        for (Access1D<N> vector : vectors) {
            dimensions += vector.count();
        }
        Mutate1D retVal = (Mutate1D)this.myFactory.make(dimensions);
        long offset = 0L;
        for (Access1D<N> vector : vectors) {
            long limit = vector.count();
            int i = 0;
            while ((long)i < limit) {
                retVal.set(offset + (long)i, vector.doubleValue(i));
                ++i;
            }
            offset += limit;
        }
        return (T)retVal;
    }

    public T values(double ... elements) {
        Mutate1D retVal = (Mutate1D)this.myFactory.make(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            retVal.set((long)i, elements[i]);
        }
        return (T)retVal;
    }

    public T values(N ... elements) {
        Mutate1D retVal = (Mutate1D)this.myFactory.make(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            retVal.set((long)i, (Comparable<?>)elements[i]);
        }
        return (T)retVal;
    }

    @Override
    public MathType getMathType() {
        return this.myFactory.getMathType();
    }
}

