/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import javolution.lang.MathLib;
import javolution.lang.ValueType;
import javolution.text.TextBuilder;

public final class CharSet
implements ValueType {
    public static final CharSet EMPTY = new CharSet(new long[0]);
    public static final CharSet WHITESPACES = CharSet.valueOf('\t', '\n', '\u000b', '\f', '\r', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u205f', '\u3000');
    public static final CharSet SPACES = CharSet.valueOf(' ', '\u00a0', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000');
    public static final CharSet ISO_CONTROLS = CharSet.valueOf('\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f');
    private final long[] _mapping;

    private CharSet(long[] mapping) {
        this._mapping = mapping;
    }

    public static CharSet valueOf(char ... chars) {
        char maxChar = '\u0000';
        int i = chars.length;
        while (--i >= 0) {
            if (chars[i] <= maxChar) continue;
            maxChar = chars[i];
        }
        CharSet charSet = new CharSet(new long[(maxChar >> 6) + 1]);
        int i2 = chars.length;
        while (--i2 >= 0) {
            char c = chars[i2];
            int n = c >> 6;
            charSet._mapping[n] = charSet._mapping[n] | 1L << (c & 0x3F);
        }
        return charSet;
    }

    public static CharSet rangeOf(char first, char last) {
        if (first > last) {
            throw new IllegalArgumentException("first should be less or equal to last");
        }
        CharSet charSet = new CharSet(new long[(last >> 6) + 1]);
        for (char c = first; c <= last; c = (char)(c + '\u0001')) {
            int n = c >> 6;
            charSet._mapping[n] = charSet._mapping[n] | 1L << (c & 0x3F);
        }
        return charSet;
    }

    public boolean contains(char c) {
        int i = c >> 6;
        return i < this._mapping.length ? (this._mapping[i] & 1L << (c & 0x3F)) != 0L : false;
    }

    public int indexIn(CharSequence csq) {
        return this.indexIn(csq, 0);
    }

    public int indexIn(CharSequence csq, int fromIndex) {
        int n = csq.length();
        for (int i = fromIndex; i < n; ++i) {
            if (!this.contains(csq.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int indexIn(char[] chars) {
        return this.indexIn(chars, 0);
    }

    public int indexIn(char[] chars, int fromIndex) {
        int n = chars.length;
        for (int i = fromIndex; i < n; ++i) {
            if (!this.contains(chars[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence csq) {
        return this.lastIndexIn(csq, csq.length() - 1);
    }

    public int lastIndexIn(CharSequence csq, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (!this.contains(csq.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexIn(char[] chars) {
        return this.lastIndexIn(chars, chars.length - 1);
    }

    public int lastIndexIn(char[] chars, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (!this.contains(chars[i])) continue;
            return i;
        }
        return -1;
    }

    public CharSet plus(CharSet that) {
        if (that._mapping.length > this._mapping.length) {
            return that.plus(this);
        }
        CharSet result = this.copy();
        int i = that._mapping.length;
        while (--i >= 0) {
            int n = i;
            result._mapping[n] = result._mapping[n] | that._mapping[i];
        }
        return result;
    }

    public CharSet minus(CharSet that) {
        CharSet result = this.copy();
        int i = MathLib.min(this._mapping.length, that._mapping.length);
        while (--i >= 0) {
            int n = i;
            result._mapping[n] = result._mapping[n] & (that._mapping[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return result;
    }

    public String toString() {
        TextBuilder tb = new TextBuilder();
        tb.append('{');
        int length = this._mapping.length << 6;
        for (int i = 0; i < length; ++i) {
            if (!this.contains((char)i)) continue;
            if (tb.length() > 1) {
                tb.append(',');
                tb.append(' ');
            }
            tb.append('\'');
            tb.append((char)i);
            tb.append('\'');
        }
        tb.append('}');
        return tb.toString();
    }

    private CharSet copy() {
        CharSet charSet = new CharSet(new long[this._mapping.length]);
        int i = this._mapping.length;
        while (--i >= 0) {
            charSet._mapping[i] = this._mapping[i];
        }
        return charSet;
    }
}

