/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Iterator;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.function.Function;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

public class MappedCollectionImpl<E, R>
extends CollectionView<R> {
    private static final long serialVersionUID = 1536L;
    protected final Function<? super E, ? extends R> function;

    public MappedCollectionImpl(CollectionService<E> target, Function<? super E, ? extends R> function) {
        super(target);
        this.function = function;
    }

    @Override
    public boolean add(R element) {
        throw new UnsupportedOperationException("New elements cannot be added to mapped views");
    }

    @Override
    public void clear() {
        this.target().clear();
    }

    @Override
    public Equality<? super R> comparator() {
        return Equalities.STANDARD;
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<R> iterator() {
        return new IteratorImpl();
    }

    @Override
    public int size() {
        return this.target().size();
    }

    @Override
    public CollectionService<R>[] split(int n, boolean updateable) {
        CollectionService[] subTargets = (CollectionService[])this.target().split(n, updateable);
        CollectionService[] result = new CollectionService[subTargets.length];
        for (int i = 0; i < subTargets.length; ++i) {
            result[i] = new MappedCollectionImpl<E, R>(subTargets[i], this.function);
        }
        return result;
    }

    private class IteratorImpl
    implements Iterator<R> {
        private final Iterator<E> targetIterator;

        public IteratorImpl() {
            this.targetIterator = MappedCollectionImpl.this.target().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.targetIterator.hasNext();
        }

        @Override
        public R next() {
            return MappedCollectionImpl.this.function.apply(this.targetIterator.next());
        }

        @Override
        public void remove() {
            this.targetIterator.remove();
        }
    }
}

