/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife;

import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.mgf.MGFWriter;
import fr.profi.mzknife.mgf.maxquant.MaxQuantMSMSReader;
import fr.profi.mzknife.util.AbstractProcessing;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MSMSSpectrum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxQuantProcessing
extends AbstractProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(MaxQuantProcessing.class);

    public static void main(String[] args) throws Exception {
        CommandArguments.MaxQuantMGFCommand createMgfCommand = new CommandArguments.MaxQuantMGFCommand();
        MaxQuantProcessing.addCommand(createMgfCommand);
        try {
            String parsedCommand = MaxQuantProcessing.parseCommand(args);
            if (parsedCommand.equals("create_mgf")) {
                if (createMgfCommand.help) {
                    MaxQuantProcessing.usage();
                }
                MaxQuantProcessing.createMgf(createMgfCommand);
            } else {
                LOG.warn("Invalid command specified ");
                MaxQuantProcessing.usage();
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("File not found", (Throwable)fnfe);
        }
        catch (InvalidMGFFormatException imfe) {
            LOG.error("Invalid MGF file format", (Throwable)imfe);
        }
        catch (Exception e) {
            LOG.error("ERROR ", (Throwable)e);
        }
    }

    public static void createMgf(CommandArguments.MaxQuantMGFCommand createMgfCommand) throws IOException, InvalidMGFFormatException {
        File in = new File(createMgfCommand.inputFileName1);
        File in2 = new File(createMgfCommand.inputFileName2);
        File mgfDstFile = MaxQuantProcessing.getDestFile(createMgfCommand.outputFileName, ".mgf", in);
        MaxQuantMSMSReader reader = new MaxQuantMSMSReader();
        PrintWriter mgfWriter = new PrintWriter(new BufferedWriter(new FileWriter(mgfDstFile)));
        List<MSMSSpectrum> msmsSpectra = reader.read(in);
        for (MSMSSpectrum spectrum : msmsSpectra) {
            String spectrumAsStr = MGFWriter.stringifySpectrum(spectrum);
            mgfWriter.print(spectrumAsStr);
            mgfWriter.println();
        }
        List<MSMSSpectrum> msmsSpectra2 = reader.read(in2);
        for (MSMSSpectrum spectrum : msmsSpectra2) {
            String spectrumAsStr = MGFWriter.stringifySpectrum(spectrum);
            mgfWriter.print(spectrumAsStr);
            mgfWriter.println();
        }
        mgfWriter.flush();
        mgfWriter.close();
    }
}

