/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mgf;

import fr.profi.mzknife.mgf.MGFRewriter;
import fr.profi.mzknife.util.RecalibrateUtil;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MGFConstants;
import fr.profi.mzscope.MSMSSpectrum;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGFRecalibrator
extends MGFRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(MGFRecalibrator.class);
    private Double recalLastTime;
    private Double recalFirstTime;
    private Double recalDeltaMass;

    public MGFRecalibrator(File srcFile, File dstFile, Double firstTime, Double lastTime, Double deltaMass) throws InvalidMGFFormatException {
        super(srcFile, dstFile);
        this.recalDeltaMass = deltaMass;
        this.recalFirstTime = firstTime;
        this.recalLastTime = lastTime;
    }

    protected boolean doRecalibration(MSMSSpectrum spectrum) {
        return spectrum.getRetentionTime() >= this.recalFirstTime && spectrum.getRetentionTime() <= this.recalLastTime;
    }

    private double getRecalibratedPrecursorMz(MSMSSpectrum spectrum) {
        double newPrecMz = -1.0;
        newPrecMz = spectrum.getPrecursorMz() + this.recalDeltaMass * spectrum.getPrecursorMz() / 1000000.0;
        return newPrecMz;
    }

    private double[] getRecalibratedMasses(MSMSSpectrum spectrum) {
        double[] masses = RecalibrateUtil.recalibrateMasses(spectrum.getMassValues(), this.recalDeltaMass);
        return masses;
    }

    @Override
    protected MSMSSpectrum getSpectrum2Export(MSMSSpectrum inSpectrum) {
        if (this.doRecalibration(inSpectrum)) {
            LOG.info("Spectrum {} at RT {} will be recalibrated", inSpectrum.getAnnotation(MGFConstants.TITLE), (Object)inSpectrum.getRetentionTime());
            double[] masses = this.getRecalibratedMasses(inSpectrum);
            double[] intensities = inSpectrum.getIntensityValues();
            MSMSSpectrum outSpectrum = new MSMSSpectrum(this.getRecalibratedPrecursorMz(inSpectrum), inSpectrum.getPrecursorIntensity(), inSpectrum.getPrecursorCharge(), inSpectrum.getRetentionTime());
            inSpectrum.getAnnotations().forEachRemaining(a -> outSpectrum.setAnnotation(a, inSpectrum.getAnnotation(a)));
            for (int k = 0; k < masses.length; ++k) {
                outSpectrum.addPeak(masses[k], intensities[k]);
            }
            return outSpectrum;
        }
        return inSpectrum;
    }
}

