/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.util;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.MgfPrecursor;
import fr.profi.mzdb.model.SpectrumHeader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class PrecursorComputerWrapper
implements IPrecursorComputation {
    private static final CharSequence DELIMITER = "\t";
    private final BufferedWriter writer;
    private IPrecursorComputation wrappedPrecComputer;
    private String[] precAnnotations = new String[]{"mz", "charge", "precursors.count.sw"};
    private String[] annotations = new String[]{"source", "mgf.id", "scan.number", "scan.selector", "in.sw", "precursor.intensity.sw", "prediction", "prediction.pattern.score", "rank", "filtered.peaks.count.sw", "precursor.signal.total.sw", "precursor.signal.max.sw", "precursor.rank.sw"};

    public PrecursorComputerWrapper(IPrecursorComputation wrappedPrecComputer, BufferedWriter annotationWriter) {
        this.wrappedPrecComputer = wrappedPrecComputer;
        this.writer = annotationWriter;
    }

    public String getMethodName() {
        return this.wrappedPrecComputer.getMethodName();
    }

    public String getMethodVersion() {
        return this.wrappedPrecComputer.getMethodVersion();
    }

    public MgfPrecursor[] getMgfPrecursors(MzDbReader mzDbReader, SpectrumHeader spectrumHeader) throws SQLiteException {
        MgfPrecursor[] precursors;
        for (MgfPrecursor precursor : precursors = this.wrappedPrecComputer.getMgfPrecursors(mzDbReader, spectrumHeader)) {
            try {
                String annotationsAsString = Arrays.stream(this.annotations).map(k -> precursor.getAnnotationOrElse(k, (Object)"").toString()).collect(Collectors.joining(DELIMITER));
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append(precursor.getPrecMz()).append(DELIMITER);
                strBuilder.append(precursor.getCharge()).append(DELIMITER);
                strBuilder.append(precursors.length).append(DELIMITER).append(annotationsAsString);
                this.writer.write(strBuilder.toString());
                this.writer.newLine();
                this.writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return precursors;
    }

    public String[] getAnnotations() {
        return (String[])ArrayUtils.addAll((Object[])this.precAnnotations, (Object[])this.annotations);
    }

    public CharSequence getDelimiter() {
        return DELIMITER;
    }
}

