/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.extraction;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.feature.extraction.AbstractSupervisedFtExtractor;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.OverlappingFeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.PeakelDetectionConfig;
import fr.profi.mzdb.algo.feature.extraction.PredictedMzFtExtractor$;
import fr.profi.mzdb.algo.signal.detection.CwtPeakel;
import fr.profi.mzdb.algo.signal.detection.waveletImpl.WaveletPeakelFinderNeumann;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.IsotopicPattern;
import fr.profi.mzdb.model.IsotopicPatternLike;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.PeakListTree;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.ms.MsUtils;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0005\n\u0001?!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u00057\u0001\t\u0005\t\u0015!\u0003'\u0011!9\u0004A!b\u0001\n\u0003A\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011}\u0002!Q1A\u0005\u0002\u0001C\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011)\u0019!C\u0001\r\"A!\n\u0001B\u0001B\u0003%q\t\u0003\u0005L\u0001\t\u0015\r\u0011\"\u0001M\u0011!\u0001\u0006A!A!\u0002\u0013i\u0005\"B)\u0001\t\u0003\u0011\u0006\"B-\u0001\t\u0003QvaB6\u0013\u0003\u0003E\t\u0001\u001c\u0004\b#I\t\t\u0011#\u0001n\u0011\u0015\tf\u0002\"\u0001r\u0011\u001d\u0011h\"%A\u0005\u0002M\u0014a\u0003\u0015:fI&\u001cG/\u001a3Nu\u001a#X\t\u001f;sC\u000e$xN\u001d\u0006\u0003'Q\t!\"\u001a=ue\u0006\u001cG/[8o\u0015\t)b#A\u0004gK\u0006$XO]3\u000b\u0005]A\u0012\u0001B1mO>T!!\u0007\u000e\u0002\t5THM\u0019\u0006\u00037q\tQ\u0001\u001d:pM&T\u0011!H\u0001\u0003MJ\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011EI\u0007\u0002%%\u00111E\u0005\u0002\u001e\u0003\n\u001cHO]1diN+\b/\u001a:wSN,GM\u0012;FqR\u0014\u0018m\u0019;pe\u0006\u00112\u000f]3diJ,X\u000eS3bI\u0016\u0014()_%e+\u00051\u0003cA\u0014/a5\t\u0001F\u0003\u0002*U\u00059Q.\u001e;bE2,'BA\u0016-\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\u000b\u0002\b\u0019>tw-T1q!\t\tD'D\u00013\u0015\t\u0019\u0004$A\u0003n_\u0012,G.\u0003\u00026e\tq1\u000b]3diJ,X\u000eS3bI\u0016\u0014\u0018aE:qK\u000e$(/^7IK\u0006$WM\u001d\"z\u0013\u0012\u0004\u0013A\u00048g\u0005f\u001c\u0006/Z2ueVl\u0017\nZ\u000b\u0002sA\u0019qE\f\u001e\u0011\u0005mbT\"\u0001\u0017\n\u0005ub#!\u0002$m_\u0006$\u0018a\u00048g\u0005f\u001c\u0006/Z2ueVl\u0017\n\u001a\u0011\u0002\u0019a$(/Y2u\u0007>tg-[4\u0016\u0003\u0005\u0003\"!\t\"\n\u0005\r\u0013\"A\u0006$fCR,(/Z#yiJ\f7\r^8s\u0007>tg-[4\u0002\u001ba$(/Y2u\u0007>tg-[4!\u0003U\u0001X-Y6fY\u0012+G/Z2uS>t7i\u001c8gS\u001e,\u0012a\u0012\t\u0003C!K!!\u0013\n\u0003+A+\u0017m[3m\t\u0016$Xm\u0019;j_:\u001cuN\u001c4jO\u00061\u0002/Z1lK2$U\r^3di&|gnQ8oM&<\u0007%A\npm\u0016\u0014H.\u00199YiJ\f7\r^\"p]\u001aLw-F\u0001N!\t\tc*\u0003\u0002P%\t\tsJ^3sY\u0006\u0004\b/\u001b8h\r\u0016\fG/\u001e:f\u000bb$(/Y2u_J\u001cuN\u001c4jO\u0006!rN^3sY\u0006\u0004\b\f\u001e:bGR\u001cuN\u001c4jO\u0002\na\u0001P5oSRtDCB*U+Z;\u0006\f\u0005\u0002\"\u0001!)Ae\u0003a\u0001M!)qg\u0003a\u0001s!)qh\u0003a\u0001\u0003\"9Qi\u0003I\u0001\u0002\u00049\u0005\"B&\f\u0001\u0004i\u0015AD3yiJ\f7\r\u001e$fCR,(/\u001a\u000b\u00047\u00064\u0007cA\u001e]=&\u0011Q\f\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Ez\u0016B\u000113\u0005\u001d1U-\u0019;ve\u0016DQA\u0019\u0007A\u0002\r\f!\u0002];uCRLg/\u001a$u!\t\tD-\u0003\u0002fe\ty\u0001+\u001e;bi&4XMR3biV\u0014X\rC\u0003h\u0019\u0001\u0007\u0001.A\u0004qW2$&/Z3\u0011\u0005EJ\u0017B\u000163\u00051\u0001V-Y6MSN$HK]3f\u0003Y\u0001&/\u001a3jGR,G-\u0014>Gi\u0016CHO]1di>\u0014\bCA\u0011\u000f'\tqa\u000e\u0005\u0002<_&\u0011\u0001\u000f\f\u0002\u0007\u0003:L(+\u001a4\u0015\u00031\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u0001;+\u0005\u001d+8&\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018!C;oG\",7m[3e\u0015\tYH&\u0001\u0006b]:|G/\u0019;j_:L!! =\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class PredictedMzFtExtractor
extends AbstractSupervisedFtExtractor {
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<Object> nfBySpectrumId;
    private final FeatureExtractorConfig xtractConfig;
    private final PeakelDetectionConfig peakelDetectionConfig;
    private final OverlappingFeatureExtractorConfig overlapXtractConfig;

    public static PeakelDetectionConfig $lessinit$greater$default$4() {
        return PredictedMzFtExtractor$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    @Override
    public LongMap<Object> nfBySpectrumId() {
        return this.nfBySpectrumId;
    }

    @Override
    public FeatureExtractorConfig xtractConfig() {
        return this.xtractConfig;
    }

    @Override
    public PeakelDetectionConfig peakelDetectionConfig() {
        return this.peakelDetectionConfig;
    }

    @Override
    public OverlappingFeatureExtractorConfig overlapXtractConfig() {
        return this.overlapXtractConfig;
    }

    @Override
    public Option<Feature> extractFeature(PutativeFeature putativeFt, PeakListTree pklTree) {
        TheoreticalIsotopePattern theoIP = putativeFt.theoreticalIP();
        double moz = putativeFt.getMz();
        int charge = putativeFt.getCharge();
        float mzTolPPM = this.xtractConfig().mzTolPPM();
        double mzTolDa = MsUtils.ppmToDa((double)moz, (double)mzTolPPM);
        ArrayBuffer xic = new ArrayBuffer();
        ArrayBuffer xicSpectrumIDs = new ArrayBuffer();
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(pklTree.spectrumIds())).foreach((Function1 & Serializable & scala.Serializable)id -> PredictedMzFtExtractor.$anonfun$extractFeature$1(pklTree, moz, mzTolDa, xic, xicSpectrumIDs, BoxesRunTime.unboxToLong((Object)id)));
        WaveletPeakelFinderNeumann peakelFinder = new WaveletPeakelFinderNeumann((Seq<Peak>)xic);
        CwtPeakel[] cwtPeakels = peakelFinder.findCwtPeakels();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cwtPeakels)).isEmpty()) {
            return Option$.MODULE$.empty();
        }
        CwtPeakel highestPeakel = (CwtPeakel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cwtPeakels)).sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToFloat((float)package$.MODULE$.abs(((Peak)xic.apply(x.apexIndex())).getLcContext().getElutionTime() - putativeFt.getElutionTime())), (Ordering)Ordering.Float$.MODULE$))).head();
        Option[] isotopicPatterns = new Option[highestPeakel.maxIdx() - highestPeakel.minIdx() + 1];
        IntRef c = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(highestPeakel.minIdx()), highestPeakel.maxIdx()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Option<IsotopicPattern> ipOpt;
            Peak peak = (Peak)xic.apply(i);
            long spectrumID = BoxesRunTime.unboxToLong((Object)xicSpectrumIDs.apply(i));
            isotopicPatterns$1[c$1.elem] = ipOpt = pklTree.extractIsotopicPattern((SpectrumHeader)this.spectrumHeaderById().apply(spectrumID), theoIP, mzTolPPM, pklTree.extractIsotopicPattern$default$4(), pklTree.extractIsotopicPattern$default$5());
        });
        IsotopicPattern[] definedIps = (IsotopicPattern[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])isotopicPatterns)).filter((Function1 & Serializable & scala.Serializable)ip -> BoxesRunTime.boxToBoolean((boolean)PredictedMzFtExtractor.$anonfun$extractFeature$4(ip))))).map((Function1 & Serializable & scala.Serializable)x$1 -> (IsotopicPattern)x$1.get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IsotopicPattern.class)));
        Feature f = new Feature(moz, charge, (Seq<IsotopicPatternLike>)Predef$.MODULE$.wrapRefArray((Object[])definedIps), true);
        this.overlappingFeaturesExtractor().extractOverlappingFeatures(f, theoIP, pklTree);
        return new Some((Object)f);
    }

    public static final /* synthetic */ Object $anonfun$extractFeature$1(PeakListTree pklTree$1, double moz$1, double mzTolDa$1, ArrayBuffer xic$1, ArrayBuffer xicSpectrumIDs$1, long id) {
        BoxedUnit boxedUnit;
        Peak p = pklTree$1.getNearestPeak(id, moz$1, mzTolDa$1);
        if (p != null) {
            xic$1.$plus$eq((Object)p);
            boxedUnit = xicSpectrumIDs$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)id));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$extractFeature$4(Option ip) {
        return ip != null && ip.isDefined();
    }

    public PredictedMzFtExtractor(LongMap<SpectrumHeader> spectrumHeaderById, LongMap<Object> nfBySpectrumId, FeatureExtractorConfig xtractConfig, PeakelDetectionConfig peakelDetectionConfig, OverlappingFeatureExtractorConfig overlapXtractConfig) {
        this.spectrumHeaderById = spectrumHeaderById;
        this.nfBySpectrumId = nfBySpectrumId;
        this.xtractConfig = xtractConfig;
        this.peakelDetectionConfig = peakelDetectionConfig;
        this.overlapXtractConfig = overlapXtractConfig;
    }
}

