/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.ms.calibration;

import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.ms.calibration.ClassedPeakScala;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.PeakList;
import fr.profi.mzdb.model.Spectrum;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class CalibrationCurveWriter$ {
    public static CalibrationCurveWriter$ MODULE$;

    static {
        new CalibrationCurveWriter$();
    }

    private Tuple2<TreeMap<Object, Object>, TreeMap<Object, Object>> compute(MzDbReader mzdb, double maxDeltaPpm, double intensityThresh, int skipBeginningSpectra) {
        ObjectRef ms1Iter = ObjectRef.create((Object)mzdb.getSpectrumIterator(1));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), skipBeginningSpectra).foreach((Function1 & Serializable & scala.Serializable)i -> CalibrationCurveWriter$.$anonfun$compute$1(ms1Iter, BoxesRunTime.unboxToInt((Object)i)));
        TreeMap<Long, Double> m445 = new TreeMap<Long, Double>();
        TreeMap<Long, Double> result = new TreeMap<Long, Double>();
        if (!((Iterator)ms1Iter.elem).hasNext()) {
            throw new Throwable("not enough spectra...");
        }
        Spectrum firstSpectrum = (Spectrum)((Iterator)ms1Iter.elem).next();
        while (((Iterator)ms1Iter.elem).hasNext()) {
            Spectrum secondSpectrum = (Spectrum)((Iterator)ms1Iter.elem).next();
            ClassedPeakScala[] mergedSpectrum = (ClassedPeakScala[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstSpectrum.toPeaks())).map((Function1 & Serializable & scala.Serializable)x -> new ClassedPeakScala(x.getMz(), x.getIntensity(), 1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClassedPeakScala.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])secondSpectrum.toPeaks())).map((Function1 & Serializable & scala.Serializable)x -> new ClassedPeakScala(x.getMz(), x.getIntensity(), 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClassedPeakScala.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClassedPeakScala.class)));
            float thresh = BoxesRunTime.unboxToFloat((Object)((SeqLike)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mergedSpectrum)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToFloat((float)x$1.getIntensity()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())))).toSeq().sortWith((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)CalibrationCurveWriter$.$anonfun$compute$5(BoxesRunTime.unboxToFloat((Object)x$2), BoxesRunTime.unboxToFloat((Object)x$3))))).apply((int)(intensityThresh * (double)mergedSpectrum.length)));
            mergedSpectrum = (ClassedPeakScala[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mergedSpectrum)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CalibrationCurveWriter$.$anonfun$compute$6(thresh, x$4)));
            ArrayBuffer deltaMass = new ArrayBuffer();
            for (int i2 = 0; i2 < mergedSpectrum.length - 2; ++i2) {
                if (mergedSpectrum[i2].order() == mergedSpectrum[i2 + 1].order()) continue;
                double mzFirst = 0.0;
                double mzSecond = 0.0;
                ClassedPeakScala pFirst = null;
                ClassedPeakScala pSecond = null;
                int gap = 1;
                if (mergedSpectrum[i2 + 1].order() == 1) {
                    pFirst = mergedSpectrum[i2 + 1];
                    pSecond = mergedSpectrum[i2];
                } else {
                    pSecond = mergedSpectrum[i2 + 1];
                    pFirst = mergedSpectrum[i2];
                }
                if (mergedSpectrum[i2 + 2].order() == mergedSpectrum[i2].order()) {
                    boolean t = package$.MODULE$.abs(mergedSpectrum[i2 + 2].getMz() - mergedSpectrum[i2 + 1].getMz()) < package$.MODULE$.abs(mergedSpectrum[i2].getMz() - mergedSpectrum[i2 + 1].getMz());
                    ClassedPeakScala goodPeak = null;
                    if (t) {
                        goodPeak = mergedSpectrum[i2 + 2];
                        ++gap;
                    } else {
                        goodPeak = mergedSpectrum[i2];
                    }
                    if (goodPeak.order() == 1) {
                        pFirst = goodPeak;
                        pSecond = mergedSpectrum[i2 + 1];
                    } else {
                        pSecond = goodPeak;
                        pFirst = mergedSpectrum[i2 + 1];
                    }
                }
                mzFirst = pFirst.getMz();
                mzSecond = pSecond.getMz();
                double deltaMz = mzSecond - mzFirst;
                double mean = (mzFirst + mzSecond) / 2.0;
                double maxDeltaMz = mean * maxDeltaPpm / 1000000.0;
                if (!(package$.MODULE$.abs(deltaMz) < maxDeltaMz)) continue;
                deltaMass.$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.daToPpm(mean, deltaMz)));
                i2 += gap;
            }
            Peak peak445 = new PeakList(firstSpectrum).getNearestPeak(445.12, 445.12 * maxDeltaPpm / 1000000.0);
            Object object = peak445 != null ? m445.put(BoxesRunTime.boxToLong((long)firstSpectrum.getHeader().getId()), BoxesRunTime.boxToDouble((double)peak445.getMz())) : BoxedUnit.UNIT;
            result.put(BoxesRunTime.boxToLong((long)firstSpectrum.getHeader().getId()), BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)deltaMass.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)deltaMass.length())));
        }
        ObjectRef output = ObjectRef.create(new TreeMap());
        DoubleRef sum = DoubleRef.create((double)0.0);
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(result.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToDouble((double)CalibrationCurveWriter$.$anonfun$compute$7(sum, output, entry)));
        return new Tuple2((Object)((TreeMap)output.elem), m445);
    }

    private double compute$default$3() {
        return 0.9;
    }

    private int compute$default$4() {
        return 0;
    }

    public void writeCalibrationFile(String mzDbFile, double maxDeltaPpm) {
        MzDbReader mzdb = new MzDbReader(mzDbFile, false);
        Tuple2<TreeMap<Object, Object>, TreeMap<Object, Object>> result = this.compute(mzdb, maxDeltaPpm, this.compute$default$3(), this.compute$default$4());
        TreeMap o = (TreeMap)result._1();
        ObjectRef m445 = ObjectRef.create((Object)((TreeMap)result._2()));
        PrintWriter writer = new PrintWriter(new File(new StringBuilder(10).append(mzDbFile).append("_calib.txt").toString()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(o.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            writer.write(new StringBuilder(3).append(BoxesRunTime.unboxToLong(entry.getKey())).append("\t").append(entry.getValue()).append("\t").append(((TreeMap)m445.elem).get(entry.getKey())).append("\n").toString());
            return BoxedUnit.UNIT;
        });
    }

    public double daToPpm(double mz, double d) {
        return d * 1000000.0 / mz;
    }

    public static final /* synthetic */ Spectrum $anonfun$compute$1(ObjectRef ms1Iter$1, int i) {
        if (!((Iterator)ms1Iter$1.elem).hasNext()) {
            throw new Throwable("reach last spectrum while trying to skip beginning spectra");
        }
        return (Spectrum)((Iterator)ms1Iter$1.elem).next();
    }

    public static final /* synthetic */ boolean $anonfun$compute$5(float x$2, float x$3) {
        return x$2 < x$3;
    }

    public static final /* synthetic */ boolean $anonfun$compute$6(float thresh$1, ClassedPeakScala x$4) {
        return x$4.getIntensity() > thresh$1;
    }

    public static final /* synthetic */ double $anonfun$compute$7(DoubleRef sum$1, ObjectRef output$1, Map.Entry entry) {
        sum$1.elem += BoxesRunTime.unboxToDouble(entry.getValue());
        return BoxesRunTime.unboxToDouble((Object)((TreeMap)output$1.elem).put(entry.getKey(), BoxesRunTime.boxToDouble((double)sum$1.elem)));
    }

    private CalibrationCurveWriter$() {
        MODULE$ = this;
    }
}

