/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.math.wavelet;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import fr.profi.mzdb.util.math.wavelet.MexicanHat;
import fr.profi.mzdb.util.math.wavelet.MexicanHat$;
import fr.profi.mzdb.util.math.wavelet.MotherWavelet;
import java.io.Serializable;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

public final class WaveletUtils$ {
    public static WaveletUtils$ MODULE$;
    private final FastFourierTransformer transformer;

    static {
        new WaveletUtils$();
    }

    public FastFourierTransformer transformer() {
        return this.transformer;
    }

    public Integer nextPowerOf2(Integer a) {
        int b;
        block1: {
            for (b = 1; b < Predef$.MODULE$.Integer2int(a); b <<= 1) {
            }
            if (b != 1 && b != 2) break block1;
            b = 4;
        }
        return Predef$.MODULE$.int2Integer(b);
    }

    public boolean checkIfItsPowerOf2(Integer n) {
        if (BoxesRunTime.equalsNumObject((Number)n, (Object)BoxesRunTime.boxToInteger((int)0)) || BoxesRunTime.equalsNumObject((Number)n, (Object)BoxesRunTime.boxToInteger((int)1)) || BoxesRunTime.equalsNumObject((Number)n, (Object)BoxesRunTime.boxToInteger((int)2))) {
            return false;
        }
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)(Predef$.MODULE$.Integer2int(n) & -Predef$.MODULE$.Integer2int(n))), (Object)n);
    }

    public double[] makePowerOf2(double[] ydata) {
        double[] dArray;
        if (!this.checkIfItsPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) {
            int diff = Predef$.MODULE$.Integer2int(this.nextPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) - ydata.length;
            ArrayBuffer ydatabuff = new ArrayBuffer();
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(ydata)).copyToBuffer((Buffer)ydatabuff);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), diff - 1).foreach((Function1 & Serializable & scala.Serializable)i -> ydatabuff.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.0)));
            dArray = (double[])ydatabuff.toArray(ClassTag$.MODULE$.Double());
        } else {
            dArray = ydata;
        }
        return dArray;
    }

    public Complex[] makePowerOf2(Complex[] ydata) {
        Complex[] complexArray;
        if (!this.checkIfItsPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) {
            int diff = Predef$.MODULE$.Integer2int(this.nextPowerOf2(Predef$.MODULE$.int2Integer(ydata.length))) - ydata.length;
            ArrayBuffer ydatabuff = new ArrayBuffer();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ydata)).copyToBuffer((Buffer)ydatabuff);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), diff - 1).foreach((Function1 & Serializable & scala.Serializable)i -> ydatabuff.$plus$eq((Object)new Complex(0.0, 0.0)));
            complexArray = (Complex[])ydatabuff.toArray(ClassTag$.MODULE$.apply(Complex.class));
        } else {
            complexArray = ydata;
        }
        return complexArray;
    }

    public float[] periodicExtend(Buffer<Object> sig, int a) {
        int len = sig.length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), a).foreach((Function1 & Serializable & scala.Serializable)i -> WaveletUtils$.$anonfun$periodicExtend$1(sig, BoxesRunTime.unboxToInt((Object)i)));
        return (float[])sig.toArray(ClassTag$.MODULE$.Float());
    }

    public double[] convolveUsingFft(double[] y, double[] wavelet, boolean useConjugate) {
        int initLength = y.length;
        double[] ypower2 = this.makePowerOf2(y);
        Complex[] yfft = this.transformer().transform(ypower2, TransformType.FORWARD);
        double[] waveletsized = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(wavelet)).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ypower2.length - wavelet.length).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> 0.0, IndexedSeq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Predef$.MODULE$.require(waveletsized.length == ypower2.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("ydata length: ").append(ypower2.length).append(", wavelet size: ").append(waveletsized.length).toString());
        Complex[] waveletfft = (Complex[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.transformer().transform(waveletsized, TransformType.FORWARD))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.conjugate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Complex.class)));
        Complex[] x = (Complex[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])yfft)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])waveletfft), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Complex a = (Complex)tuple2._1();
            Complex b = (Complex)tuple2._2();
            Complex complex = a.multiply(b);
            return complex;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Complex.class)));
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.transformer().transform(x, TransformType.INVERSE))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.getReal()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).take(initLength);
    }

    public boolean convolveUsingFft$default$3() {
        return true;
    }

    public float[] convolveUsingJtransform(float[] y, float[] wavelet, boolean useConjugate) {
        int N = y.length;
        FloatFFT_1D fft2 = new FloatFFT_1D(N);
        float[] yfft = (float[])Array$.MODULE$.fill(N * 2, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f, ClassTag$.MODULE$.Float());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            yfft$1[2 * j] = y[j];
        });
        fft2.complexForward(yfft);
        float[] wavepadded = (float[])Array$.MODULE$.fill(N * 2, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f, ClassTag$.MODULE$.Float());
        int r = package$.MODULE$.min(wavelet.length, N);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            wavepadded$1[2 * i] = wavelet[i];
        });
        fft2.complexForward(wavepadded);
        float[] x = (float[])Array$.MODULE$.fill(2 * N, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f, ClassTag$.MODULE$.Float());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            float value = useConjugate ? -wavepadded[2 * j + 1] : wavepadded[2 * j + 1];
            x$5[2 * j] = yfft[2 * j] * wavepadded[2 * j] - yfft[2 * j + 1] * value;
            x$5[2 * j + 1] = yfft[2 * j] * value + wavepadded[2 * j] * yfft[2 * j + 1];
        });
        fft2.complexInverse(x, true);
        return (float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    float value = BoxesRunTime.unboxToFloat((Object)A1._1());
                    int idx = A1._2$mcI$sp();
                    if (idx % 2 == 0) {
                        object = BoxesRunTime.boxToFloat((float)value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int idx;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (idx = tuple2._2$mcI$sp()) % 2 == 0;
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
    }

    public boolean convolveUsingJtransform$default$3() {
        return true;
    }

    public HashMap<Object, float[]> cwt(float[] ydata, MotherWavelet wavelet, float[] scales) {
        int extendLength = wavelet.nbPoints() / 3;
        float[] ydataExtended = this.periodicExtend((Buffer<Object>)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(ydata)).toBuffer(), extendLength);
        ObjectRef coeffs = ObjectRef.create((Object)new HashMap());
        float[] waveletValues = (float[])wavelet.values();
        float[] psiXval = wavelet.getPsiXval();
        float dxval = psiXval[1];
        float xmax = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(psiXval)).last());
        IntRef prevExiting = IntRef.create((int)scales.length);
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), scales.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)scaleIndex -> {
            float scale = scales[scaleIndex];
            ObjectRef f = ObjectRef.create((Object)((float[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ydataExtended.length).map((Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)i -> 0.0f, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float())));
            int maxStuff = (int)(scale * xmax);
            int[] indexes = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxStuff).by(1).toArray(ClassTag$.MODULE$.Int()))).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> (int)package$.MODULE$.floor((double)((float)x / (scale * dxval))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            int lenWave = indexes.length;
            float[] waveletCoeffs = (float[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indexes)).map((Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)x$3 -> waveletValues[x$3], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            float mean = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(waveletCoeffs)).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)waveletCoeffs.length;
            float[] v = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(waveletCoeffs)).reverse())).map((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)x$4 -> x$4 - mean, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(((float[])f.elem).length, lenWave)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                ((float[])f$1.elem)[i] = v[i];
            });
            if (((float[])f.elem).length > ydataExtended.length) {
                prevExiting$1.elem = scaleIndex;
                throw Breaks$.MODULE$.break();
            }
            float[] convolvingResult = MODULE$.convolveUsingJtransform(ydataExtended, (float[])f.elem, true);
            float[] scaleogram = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(convolvingResult)).map((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)x -> (float)((double)x * (1.0 / package$.MODULE$.sqrt((double)scale))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            int p = ydataExtended.length - (int)package$.MODULE$.floor((double)((float)lenWave / 2.0f));
            ((HashMap)coeffs$1.elem).update((Object)BoxesRunTime.boxToFloat((float)scale), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scaleogram)).slice(p, ydataExtended.length))).$plus$plus((GenTraversableOnce)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scaleogram)).slice(0, p))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())))).slice(extendLength, ydata.length + extendLength));
        }));
        if (prevExiting.elem == scales.length) {
            return (HashMap)coeffs.elem;
        }
        return (HashMap)((HashMap)coeffs.elem).slice(0, prevExiting.elem);
    }

    public MotherWavelet cwt$default$2() {
        return new MexicanHat(MexicanHat$.MODULE$.apply$default$1(), MexicanHat$.MODULE$.apply$default$2(), MexicanHat$.MODULE$.apply$default$3());
    }

    public void denoiseCoeffs(double[][] coeffs, float percent) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coeffs)).foreach((Function1 & Serializable & scala.Serializable)coeff -> {
            WaveletUtils$.$anonfun$denoiseCoeffs$1(percent, coeff);
            return BoxedUnit.UNIT;
        });
    }

    public float denoiseCoeffs$default$2() {
        return 0.25f;
    }

    public static final /* synthetic */ Buffer $anonfun$periodicExtend$1(Buffer sig$1, int i) {
        float temp1 = BoxesRunTime.unboxToFloat((Object)sig$1.apply(2 * i));
        float temp2 = BoxesRunTime.unboxToFloat((Object)sig$1.last());
        sig$1.$plus$eq$colon((Object)BoxesRunTime.boxToFloat((float)temp2));
        return sig$1.$plus$eq((Object)BoxesRunTime.boxToFloat((float)temp1));
    }

    public static final /* synthetic */ void $anonfun$denoiseCoeffs$1(float percent$1, double[] coeff) {
        double[] value = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coeff)).sortBy((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x, (Ordering)Ordering.Double$.MODULE$);
        DoubleRef thresh = DoubleRef.create((double)value[(int)(percent$1 * (float)coeff.length)]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), coeff.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (!(coeff[i] < thresh$1.elem)) break block0;
                coeff$1[i] = 0.0;
            }
        });
    }

    private WaveletUtils$() {
        MODULE$ = this;
        this.transformer = new FastFourierTransformer(DftNormalization.STANDARD);
    }
}

