/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.IObjectBuffer;
import com.ximpleware.arrayList;

public class FastObjectBuffer
implements IObjectBuffer {
    private arrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    protected int size;
    private int exp;
    private int r;

    public FastObjectBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new arrayList();
    }

    public FastObjectBuffer(int e) {
        if (e < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << e;
        this.exp = e;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new arrayList();
    }

    public void append(Object[] obj_array) {
        int lastBufferIndex;
        Object[] lastBuffer;
        if (obj_array == null) {
            throw new NullPointerException();
        }
        if (this.bufferArrayList.size == 0) {
            lastBuffer = new Object[this.pageSize];
            this.bufferArrayList.add(lastBuffer);
            lastBufferIndex = 0;
            this.capacity = this.pageSize;
        } else {
            lastBufferIndex = Math.min(this.size >> this.exp, this.bufferArrayList.size - 1);
            lastBuffer = (Object[])this.bufferArrayList.get(lastBufferIndex);
        }
        if (this.size + obj_array.length < this.capacity) {
            if (this.size + obj_array.length < lastBufferIndex + 1 << this.exp) {
                System.arraycopy(obj_array, 0, lastBuffer, this.size & this.r, obj_array.length);
            } else {
                int z;
                int offset = this.pageSize - (this.size & this.r);
                System.arraycopy(obj_array, 0, lastBuffer, this.size & this.r, offset);
                int l = obj_array.length - offset;
                int k = l >> this.exp;
                for (z = 1; z <= k; ++z) {
                    System.arraycopy(obj_array, offset, (Object[])this.bufferArrayList.get(lastBufferIndex + z), 0, this.pageSize);
                    offset += this.pageSize;
                }
                System.arraycopy(obj_array, offset, (Object[])this.bufferArrayList.get(lastBufferIndex + z), 0, l & this.r);
            }
            this.size += obj_array.length;
            return;
        }
        int n = (obj_array.length + this.size >> this.exp) + ((obj_array.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(obj_array, 0, lastBuffer, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n; ++i) {
            Object[] newBuffer = new Object[this.pageSize];
            if (i < n - 1) {
                System.arraycopy(obj_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, this.pageSize);
            } else {
                System.arraycopy(obj_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, obj_array.length + this.size - this.capacity - this.pageSize * i);
            }
            this.bufferArrayList.add(newBuffer);
        }
        this.size += obj_array.length;
        this.capacity += n * this.pageSize;
    }

    public final void append(Object obj) {
        if (this.size < this.capacity) {
            ((Object[])this.bufferArrayList.oa[this.size >> this.exp])[this.size & this.r] = obj;
            ++this.size;
        } else {
            Object[] newBuffer = new Object[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(newBuffer);
            newBuffer[0] = obj;
        }
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public Object[] getObjectArray(int startingOffset, int len) {
        if (this.size <= 0 || startingOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (startingOffset + len > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object[] result = new Object[len];
        int first_index = startingOffset >> this.exp;
        int last_index = startingOffset + len >> this.exp;
        if ((startingOffset + len & this.r) == 0) {
            --last_index;
        }
        if (first_index == last_index) {
            System.arraycopy((Object[])this.bufferArrayList.get(first_index), startingOffset & this.r, result, 0, len);
        } else {
            int obj_array_offset = 0;
            for (int i = first_index; i <= last_index; ++i) {
                Object[] currentChunk = (Object[])this.bufferArrayList.get(i);
                if (i == first_index) {
                    System.arraycopy(currentChunk, startingOffset & this.r, result, 0, this.pageSize - (startingOffset & this.r));
                    obj_array_offset += this.pageSize - (startingOffset & this.r);
                    continue;
                }
                if (i == last_index) {
                    System.arraycopy(currentChunk, 0, result, obj_array_offset, len - obj_array_offset);
                    continue;
                }
                System.arraycopy(currentChunk, 0, result, obj_array_offset, this.pageSize);
                obj_array_offset += this.pageSize;
            }
        }
        return result;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final Object objectAt(int index) {
        if (index > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        int pageNum = index >> this.exp;
        int offset = index & this.r;
        return ((Object[])this.bufferArrayList.get(pageNum))[offset];
    }

    public final void modifyEntry(int index, Object newValue) {
        if (index > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        ((Object[])this.bufferArrayList.get((int)(index >> this.exp)))[index & this.r] = newValue;
    }

    public final int size() {
        return this.size;
    }

    public Object[] toObjectArray() {
        if (this.size > 0) {
            int s = this.size;
            Object[] resultArray = new Object[this.size];
            int array_offset = 0;
            int i = 0;
            while (s > 0) {
                System.arraycopy((Object[])this.bufferArrayList.get(i), 0, resultArray, array_offset, s < this.pageSize ? s : this.pageSize);
                s -= this.pageSize;
                array_offset += this.pageSize;
                ++i;
            }
            return resultArray;
        }
        return null;
    }

    public final void clear() {
        this.size = 0;
    }
}

