/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class NumExpr
extends Expr {
    public double dval;

    public NumExpr(double d) {
        this.dval = d;
    }

    public final String toString() {
        if (this.dval == (double)((long)this.dval)) {
            return "" + (long)this.dval;
        }
        return "" + this.dval;
    }

    public final double eval() {
        return this.dval;
    }

    public final boolean isNodeSet() {
        return false;
    }

    public final boolean isNumerical() {
        return true;
    }

    public final boolean evalBoolean(VTDNav vn) {
        return this.dval != 0.0 && !Double.isNaN(this.dval);
    }

    public final double evalNumber(VTDNav vn) {
        return this.dval;
    }

    public final int evalNodeSet(VTDNav vn) throws XPathEvalException {
        throw new XPathEvalException("NumExpr can't eval to a node set!");
    }

    public final String evalString(VTDNav vn) {
        if (this.dval == (double)((int)this.dval)) {
            return "" + (int)this.dval;
        }
        return "" + this.dval;
    }

    public final void reset(VTDNav vn) {
    }

    public final boolean isString() {
        return false;
    }

    public final boolean isBoolean() {
        return false;
    }

    public final boolean requireContextSize() {
        return false;
    }

    public final void setContextSize(int size) {
    }

    public final void setPosition(int pos) {
    }

    public final int adjust(int n) {
        return 0;
    }

    public final boolean isFinal() {
        return true;
    }
}

