/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui;

import fr.profi.mgfboost.ui.command.AbstractCommand;
import fr.profi.mgfboost.ui.command.ICommand;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.model.MS2Collection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

class ConfigurationDialog
extends JDialog {
    private final ICommand command;
    private boolean isValidated = false;

    public ConfigurationDialog(ICommand command, List<MS2Collection> selectedFiles) {
        this.command = command;
        AbstractCommandPanel configurationPanel = command.getConfigurationPanel(selectedFiles);
        this.setModal(true);
        this.setTitle(command.getCommandName() + " parameters");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(configurationPanel, "Center");
        this.getContentPane().add((Component)this.getOkCancelButtons(), "South");
        this.pack();
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    private JPanel getOkCancelButtons() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(1));
        JButton loadParametersBtn = new JButton();
        loadParametersBtn.setText("Load");
        loadParametersBtn.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            int res = chooser.showOpenDialog(this);
            if (res == 0) {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                try {
                    String jsonString = FileUtils.readFileToString((File)new File(fileName), (String)"UTF-8");
                    this.command.fromJSON(jsonString);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        buttonsPanel.add(loadParametersBtn);
        JButton saveParametersBtn = new JButton();
        saveParametersBtn.setText("Save");
        saveParametersBtn.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            int res = chooser.showSaveDialog(this);
            if (res == 0) {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                if (this.command.buildCommand()) {
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                        writer.write(this.command.toJSON());
                        writer.close();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                } else {
                    this.command.showErrorMessage();
                }
            }
        });
        buttonsPanel.add(saveParametersBtn);
        buttonsPanel.add(new JPanel());
        JButton okBtn = new JButton();
        okBtn.setText("Ok");
        okBtn.addActionListener(e -> {
            if ((e.getModifiers() & 2) == 2) {
                this.command.buildCommand();
                System.out.println("Command args : " + ToStringBuilder.reflectionToString(((AbstractCommand)this.command).getCommand(), ToStringStyle.MULTI_LINE_STYLE));
            } else if (this.command.buildCommand()) {
                this.isValidated = true;
                this.setVisible(false);
            } else {
                this.command.showErrorMessage();
            }
        });
        this.getRootPane().setDefaultButton(okBtn);
        buttonsPanel.add(okBtn);
        JButton cancelBtn = new JButton();
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(e -> this.setVisible(false));
        buttonsPanel.add(cancelBtn);
        return buttonsPanel;
    }
}

