/*
 * Decompiled with CFR 0.152.
 */
package MZIDparser;

import MZIDparser.JModification;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import java.util.ArrayList;

public class JPSM {
    private String SpectrumID;
    private int SpectrumIndex;
    private String pepSeq;
    private ArrayList<JModification> modificationList = new ArrayList();
    private int rank;
    private int charge;
    private double calculatedMassToCharge;
    private double experimentalMassToCharge;
    private double evalue;
    private ArrayList<String> proteins = new ArrayList();
    private boolean isDecoy = false;
    private double rt = -1.0;
    private double massErrorMZ;
    private double IsotopeError = 0.0;
    public static boolean addFlankAA = false;
    private String preAA = "";
    private String postAA = "";
    private ArrayList<JPSM> jPsmRank = new ArrayList();
    private double rawHyperScore;
    private double rawMVH;
    private double rawMzFidelity;
    private int numOfMatchIonsForMyrimatch;
    private int numOfUnmatchIonsForMyrimatch;
    private double rawXCorr;
    public int searchEngineClass;
    private ArrayList<Double> featureValueList = new ArrayList();
    public static ArrayList<String> featureNameList = new ArrayList();
    private double lnEvalue;
    private double lnSpecEValue;
    private double rawScore;
    private double deNovoScore;
    private double qvalue;

    public void setLnEvalue(double e) {
        this.lnEvalue = e;
    }

    public double getLnEvalue() {
        return this.lnEvalue;
    }

    public void setLnSpecEValue(double e) {
        this.lnSpecEValue = e;
    }

    public double getlnSpecEValue() {
        return this.lnSpecEValue;
    }

    public ArrayList<ModificationMatch> getModificationMatch_will_remove() {
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        if (this.modificationList.size() >= 1) {
            for (int i = 0; i < this.modificationList.size(); ++i) {
                JModification jModification = this.modificationList.get(i);
                String ptmName = "CMSPTM:" + jModification.getResidue() + ":" + jModification.getModMassDelta();
                if (!ptmFactory.containsPTM(ptmName)) {
                    ArrayList<String> residuesArray = new ArrayList<String>();
                    residuesArray.add(jModification.getResidue());
                    PTM ptm = new PTM(1, ptmName, Double.valueOf(jModification.getModMassDelta()), residuesArray);
                    ptmFactory.addUserPTM(ptm);
                }
                ModificationMatch mm = new ModificationMatch(ptmName, true, jModification.getModLocation());
                modificationMatches.add(mm);
            }
        }
        return modificationMatches;
    }

    public ArrayList<ModificationMatch> getModificationMatch() {
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        if (this.modificationList.size() >= 1) {
            for (int i = 0; i < this.modificationList.size(); ++i) {
                JModification jModification = this.modificationList.get(i);
                double modMassDelta = Double.valueOf(String.format("%.4f", jModification.getModMassDelta()));
                String ptmName = "CMSPTM:" + jModification.getResidue() + ":" + modMassDelta;
                if (!ptmFactory.containsPTM(ptmName)) {
                    ArrayList<String> residuesArray = new ArrayList<String>();
                    residuesArray.add(jModification.getResidue());
                    PTM ptm = null;
                    ptm = jModification.getResidue().equalsIgnoreCase("N-term") ? new PTM(5, ptmName, Double.valueOf(modMassDelta), new ArrayList()) : (jModification.getResidue().equalsIgnoreCase("C-term") ? new PTM(7, ptmName, Double.valueOf(modMassDelta), new ArrayList()) : new PTM(0, ptmName, Double.valueOf(modMassDelta), residuesArray));
                    ptmFactory.addUserPTM(ptm);
                }
                ModificationMatch mm = new ModificationMatch(ptmName, true, jModification.getModLocation());
                modificationMatches.add(mm);
            }
        }
        return modificationMatches;
    }

    public double getMass() throws InterruptedException {
        Peptide peptideTmp = new Peptide(this.getPepSeq(), this.getModificationMatch());
        return peptideTmp.getMass();
    }

    public String getSpectrumID() {
        return this.SpectrumID;
    }

    public void setSpectrumID(String spectrumID) {
        this.SpectrumID = spectrumID;
    }

    public int getSpectrumIndex() {
        return this.SpectrumIndex;
    }

    public void setSpectrumIndex(int spectrumIndex) {
        this.SpectrumIndex = spectrumIndex;
    }

    public String getPepSeq() {
        return this.pepSeq;
    }

    public void setPepSeq(String pepSeq) {
        this.pepSeq = pepSeq;
    }

    public ArrayList<JModification> getModificationList() {
        return this.modificationList;
    }

    public void addModificationList(JModification modification) {
        this.modificationList.add(modification);
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public double getCalculatedMassToCharge() {
        return this.calculatedMassToCharge;
    }

    public void setCalculatedMassToCharge(double calculatedMassToCharge) {
        this.calculatedMassToCharge = calculatedMassToCharge;
    }

    public double getExperimentalMassToCharge() {
        return this.experimentalMassToCharge;
    }

    public void setExperimentalMassToCharge(double experimentalMassToCharge) {
        this.experimentalMassToCharge = experimentalMassToCharge;
    }

    public double getEvalue() {
        return this.evalue;
    }

    public void setEvalue(double evalue) {
        this.evalue = evalue;
    }

    public ArrayList<String> getProteins() {
        return this.proteins;
    }

    public void addProteins(String acc) {
        this.proteins.add(acc);
    }

    public double getRawHyperScore() {
        return this.rawHyperScore;
    }

    public void setRawHyperScore(double hyperScore) {
        this.rawHyperScore = hyperScore;
    }

    public double getRawMVH() {
        return this.rawMVH;
    }

    public void setRawMVH(double rawMVH) {
        this.rawMVH = rawMVH;
    }

    public double getRawMzFidelity() {
        return this.rawMzFidelity;
    }

    public void setRawMzFidelity(double rawMzFidelity) {
        this.rawMzFidelity = rawMzFidelity;
    }

    public int getNumOfMatchIonsForMyrimatch() {
        return this.numOfMatchIonsForMyrimatch;
    }

    public void setNumOfMatchIonsForMyrimatch(int numOfMatchIonsForMyrimatch) {
        this.numOfMatchIonsForMyrimatch = numOfMatchIonsForMyrimatch;
    }

    public int getNumOfUnmatchIonsForMyrimatch() {
        return this.numOfUnmatchIonsForMyrimatch;
    }

    public void setNumOfUnmatchIonsForMyrimatch(int numOfUnmatchIonsForMyrimatch) {
        this.numOfUnmatchIonsForMyrimatch = numOfUnmatchIonsForMyrimatch;
    }

    public ArrayList<Double> getFeatureValueList() {
        return this.featureValueList;
    }

    public void addFeatureValueList(double va) {
        this.featureValueList.add(va);
    }

    public ArrayList<String> getFeatureNameList() {
        return featureNameList;
    }

    public static void addFeatureNameList(String name) {
        if (!featureNameList.contains(name)) {
            featureNameList.add(name);
        }
    }

    public boolean isDecoy() {
        return this.isDecoy;
    }

    public void setDecoy(boolean isDecoy) {
        this.isDecoy = isDecoy;
    }

    public int getLabel() {
        if (this.isDecoy) {
            return -1;
        }
        return 1;
    }

    public double getRawXCorr() {
        return this.rawXCorr;
    }

    public void setRawXCorr(double rawXCorr) {
        this.rawXCorr = rawXCorr;
    }

    public void addPSMRank(JPSM jpsm) {
        this.jPsmRank.add(jpsm);
    }

    public ArrayList<JPSM> getPSMRank() {
        return this.jPsmRank;
    }

    public double getRawScore() {
        return this.rawScore;
    }

    public void setRawScore(double rawScore) {
        this.rawScore = rawScore;
    }

    public double getDeNovoScore() {
        return this.deNovoScore;
    }

    public void setDeNovoScore(double deNovoScore) {
        this.deNovoScore = deNovoScore;
    }

    public JPSM getNextRank() {
        if (this.jPsmRank.size() >= 1) {
            for (int i = 0; i < this.jPsmRank.size(); ++i) {
                if (i == this.jPsmRank.size() - 1) {
                    return this.jPsmRank.get(i);
                }
                if (this.jPsmRank.get(i).getPepSeq().equalsIgnoreCase(this.getPepSeq())) continue;
                return this.jPsmRank.get(i);
            }
        } else {
            return null;
        }
        return null;
    }

    public double getDeltaLnEvalue() {
        if (this.getNextRank() != null) {
            double delta = this.getLnEvalue() - this.getNextRank().getLnEvalue();
            return delta;
        }
        return 0.0;
    }

    public double getDeltaLnSpecEValue() {
        if (this.getNextRank() != null) {
            double delta = this.getlnSpecEValue() - this.getNextRank().getlnSpecEValue();
            return delta;
        }
        return 0.0;
    }

    public double getDeltaRawScore() {
        if (this.getNextRank() != null) {
            double delta = this.getRawScore() - this.getNextRank().getRawScore();
            return delta;
        }
        return 0.0;
    }

    public double getDeltaDeNovoScore() {
        if (this.getNextRank() != null) {
            double delta = this.getDeNovoScore() - this.getNextRank().getDeNovoScore();
            return delta;
        }
        return 0.0;
    }

    public String getOutFeatureLine() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.SpectrumIndex + ":" + this.rank + "\t");
        stringBuilder.append(this.getLabel() + "\t");
        stringBuilder.append(this.SpectrumIndex + "\t");
        if (this.rt != -1.0) {
            stringBuilder.append(this.rt + "\t");
        }
        stringBuilder.append(this.getMassErrorMZ() + "\t");
        for (int i = 0; i < this.getFeatureValueList().size(); ++i) {
            stringBuilder.append(this.getFeatureValueList().get(i) + "\t");
        }
        if (addFlankAA) {
            stringBuilder.append("X." + this.pepSeq + ".X\t");
        } else {
            stringBuilder.append(this.pepSeq + "\t");
        }
        for (int j = 0; j < this.getProteins().size(); ++j) {
            if (j == this.getProteins().size() - 1) {
                stringBuilder.append(this.getProteins().get(j));
                continue;
            }
            stringBuilder.append(this.getProteins().get(j) + "\t");
        }
        return stringBuilder.toString();
    }

    public String getOutFeatureLine4ScorerTest() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.SpectrumIndex + ":" + this.rank + "\t");
        stringBuilder.append(this.getLabel() + "\t");
        stringBuilder.append(this.SpectrumIndex + "\t");
        if (this.rt != -1.0) {
            stringBuilder.append(this.rt + "\t");
        }
        stringBuilder.append(this.getMassErrorMZ() + "\t");
        for (int i = 0; i < this.getFeatureValueList().size(); ++i) {
            stringBuilder.append(this.getFeatureValueList().get(i) + "\t");
        }
        if (addFlankAA) {
            stringBuilder.append("X." + this.pepSeq + ".X\t");
        } else {
            stringBuilder.append(this.pepSeq + "\t");
        }
        for (int j = 0; j < this.getProteins().size(); ++j) {
            if (j == this.getProteins().size() - 1) {
                stringBuilder.append(this.getProteins().get(j));
                continue;
            }
            stringBuilder.append(this.getProteins().get(j) + ";");
        }
        return stringBuilder.toString();
    }

    public String getOutFeatureLine(String hIndex, String hRank, long scannum) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hIndex + ":" + hRank + "\t");
        stringBuilder.append(this.getLabel() + "\t");
        stringBuilder.append(scannum + "\t");
        if (this.rt != -1.0) {
            stringBuilder.append(this.rt + "\t");
        }
        stringBuilder.append(this.getMassErrorMZ() + "\t");
        for (int i = 0; i < this.getFeatureValueList().size(); ++i) {
            stringBuilder.append(this.getFeatureValueList().get(i) + "\t");
        }
        if (addFlankAA) {
            stringBuilder.append("X." + this.pepSeq + ".X\t");
        } else {
            stringBuilder.append(this.pepSeq + "\t");
        }
        for (int j = 0; j < this.getProteins().size(); ++j) {
            if (j == this.getProteins().size() - 1) {
                stringBuilder.append(this.getProteins().get(j));
                continue;
            }
            stringBuilder.append(this.getProteins().get(j) + "\t");
        }
        return stringBuilder.toString();
    }

    public String getPreAA() {
        return this.preAA;
    }

    public void setPreAA(String preAA) {
        this.preAA = preAA;
    }

    public String getPostAA() {
        return this.postAA;
    }

    public void setPostAA(String postAA) {
        this.postAA = postAA;
    }

    public double getRt() {
        return this.rt;
    }

    public void setRt(double rt) {
        this.rt = rt;
    }

    public double getIsotopeError() {
        return this.IsotopeError;
    }

    public void setIsotopeError(double isotopeError) {
        this.IsotopeError = isotopeError;
    }

    public double getMassErrorMZ() {
        return this.massErrorMZ;
    }

    public void setMassErrorMZ(double massErrorMZ) {
        this.massErrorMZ = massErrorMZ;
    }

    public double getQvalue() {
        return this.qvalue;
    }

    public void setQvalue(double qvalue) {
        this.qvalue = qvalue;
    }
}

