/*
 * Decompiled with CFR 0.152.
 */
package Preprocessing;

import Preprocessing.PMass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class DeltaMassDB {
    public String labelMethod;
    public static boolean consider2aa = true;
    public ArrayList<PMass> massDB = new ArrayList();
    public HashMap<Integer, Integer> mass2index = new HashMap();
    public HashMap<Integer, Integer> mass2indexUp = new HashMap();
    public HashMap<Double, String> deltaMass2nameMap = new HashMap();
    public Comparator<PMass> comparator = new Comparator<PMass>(){

        @Override
        public int compare(PMass s1, PMass s2) {
            if (s2.deltaMZ > s1.deltaMZ) {
                return -1;
            }
            if (s2.deltaMZ == s1.deltaMZ) {
                return 0;
            }
            return 1;
        }
    };

    public DeltaMassDB() {
    }

    public DeltaMassDB(String labelMethod) {
        this.labelMethod = labelMethod;
    }

    public int IntegerMass(double mass) {
        return (int)(Math.ceil(mass) + 2.0);
    }

    public int IntegerMassUp(double mass) {
        return (int)(Math.floor(mass) - 2.0);
    }

    public int IntegerMassForSearch(double mass) {
        return (int)Math.floor(mass);
    }

    public void init() {
        int i;
        boolean lossHN;
        this.deltaMass2nameMap.put(71.037114, "A");
        this.deltaMass2nameMap.put(156.101111, "R");
        this.deltaMass2nameMap.put(114.042927, "N");
        this.deltaMass2nameMap.put(115.026943, "N");
        this.deltaMass2nameMap.put(115.026943, "D");
        this.deltaMass2nameMap.put(116.010959, "D");
        this.deltaMass2nameMap.put(103.009185, "C");
        this.deltaMass2nameMap.put(160.030649, "C");
        this.deltaMass2nameMap.put(129.042593, "E");
        this.deltaMass2nameMap.put(128.058578, "Q");
        this.deltaMass2nameMap.put(57.021464, "G");
        this.deltaMass2nameMap.put(137.058912, "H");
        this.deltaMass2nameMap.put(113.084064, "L");
        this.deltaMass2nameMap.put(128.094963, "K");
        this.deltaMass2nameMap.put(131.040485, "M");
        this.deltaMass2nameMap.put(147.035405, "M");
        this.deltaMass2nameMap.put(147.068414, "F");
        this.deltaMass2nameMap.put(97.052764, "P");
        this.deltaMass2nameMap.put(87.032028, "S");
        this.deltaMass2nameMap.put(101.047679, "T");
        this.deltaMass2nameMap.put(186.079313, "W");
        this.deltaMass2nameMap.put(163.063329, "Y");
        this.deltaMass2nameMap.put(99.068414, "V");
        this.deltaMass2nameMap.put(17.0265, "NH3");
        this.deltaMass2nameMap.put(18.0106, "H2O");
        if (this.labelMethod != null) {
            if (this.labelMethod.equals("iTRAQ4plex")) {
                this.deltaMass2nameMap.put(272.197063, "K");
            }
            if (this.labelMethod.equals("iTRAQ8plex")) {
                this.deltaMass2nameMap.put(432.300363, "K");
            }
            if (this.labelMethod.equals("TMT6plex") || this.labelMethod.equals("TMT10plex")) {
                this.deltaMass2nameMap.put(357.257895, "k");
            }
        }
        if (consider2aa) {
            ArrayList<Double> aaMass = new ArrayList<Double>();
            for (Double mass : this.deltaMass2nameMap.keySet()) {
                aaMass.add(mass);
            }
            for (int i2 = 0; i2 < aaMass.size(); ++i2) {
                double mass1 = (Double)aaMass.get(i2);
                for (int j = i2; j < aaMass.size(); ++j) {
                    double mass2 = (Double)aaMass.get(j);
                    double aa2mass = mass1 + mass2;
                    String aa2 = this.deltaMass2nameMap.get(mass1) + this.deltaMass2nameMap.get(mass2);
                    if (this.deltaMass2nameMap.containsKey(aa2mass)) continue;
                    this.deltaMass2nameMap.put(aa2mass, aa2);
                }
            }
        }
        if (lossHN = true) {
            // empty if block
        }
        for (Double mass : this.deltaMass2nameMap.keySet()) {
            PMass pMass = new PMass(mass);
            pMass.name = this.deltaMass2nameMap.get(mass);
            this.massDB.add(pMass);
        }
        Collections.sort(this.massDB, this.comparator);
        int maxMass = (int)Math.ceil(this.massDB.get((int)(this.massDB.size() - 1)).deltaMZ + 1.0);
        for (int i3 = 0; i3 < this.massDB.size(); ++i3) {
            int minMass = this.IntegerMass(this.massDB.get((int)i3).deltaMZ);
            if (this.mass2index.containsKey(minMass)) continue;
            this.mass2index.put(minMass, i3);
        }
        int lastIndex = 0;
        for (i = 1; i <= maxMass; ++i) {
            if (!this.mass2index.containsKey(i)) {
                this.mass2index.put(i, lastIndex);
                continue;
            }
            lastIndex = this.mass2index.get(i);
        }
        for (i = this.massDB.size() - 1; i >= 0; --i) {
            int minMass = this.IntegerMassUp(this.massDB.get((int)i).deltaMZ);
            if (this.mass2indexUp.containsKey(minMass)) continue;
            this.mass2indexUp.put(minMass, i);
        }
        lastIndex = this.massDB.size() - 1;
        for (i = maxMass; i >= 1; --i) {
            if (!this.mass2indexUp.containsKey(i)) {
                this.mass2indexUp.put(i, lastIndex);
                continue;
            }
            lastIndex = this.mass2indexUp.get(i);
        }
    }

    public ArrayList<PMass> searchDB(double mass, double delta, int unit) {
        ArrayList<PMass> result = new ArrayList<PMass>();
        int index = this.IntegerMassForSearch(mass);
        if (!this.mass2index.containsKey(index)) {
            return result;
        }
        int ind = this.mass2index.get(index);
        if (!this.mass2indexUp.containsKey(index)) {
            return result;
        }
        int indMax = this.mass2indexUp.get(index);
        for (int i = ind; i <= indMax; ++i) {
            if (indMax > this.massDB.size() - 1) continue;
            PMass pMass = this.massDB.get(i);
            double mdel = mass - pMass.deltaMZ;
            if (unit == 1) {
                mdel = mdel / pMass.deltaMZ * 1000000.0;
            }
            if (!(Math.abs(mdel) <= delta)) continue;
            pMass.mzTol = mdel;
            result.add(pMass);
        }
        return result;
    }
}

