/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.BetaSymmetricalDist;
import umontreal.iro.lecuyer.probdist.CauchyDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;

public class StudentDist
extends ContinuousDistribution {
    protected int n;
    private double factor;
    private static final int NLIM1 = 100000;

    private static double cdfGaver(int n, double x) {
        double v = Math.log1p(x * x / (double)n) / ((double)n - 1.5);
        double z = (double)(-(n - 1)) * Math.sqrt(v);
        double u = NormalDist.cdf01(z);
        if (x >= 0.0) {
            return 1.0 - u;
        }
        return u;
    }

    private static double invGaver(int n, double u) {
        double z = NormalDist.inverseF01(u);
        double q = z / ((double)n - 1.0);
        double v = q * q * ((double)n - 1.5);
        double t = Math.sqrt((double)n * Math.expm1(v));
        if (u >= 0.5) {
            return t;
        }
        return -t;
    }

    public StudentDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        return this.factor * Math.pow(1.0 / (1.0 + x * x / (double)this.n), (double)(this.n + 1) / 2.0);
    }

    public double cdf(double x) {
        return StudentDist.cdf(this.n, x);
    }

    public double barF(double x) {
        return StudentDist.barF(this.n, x);
    }

    public double inverseF(double u) {
        return StudentDist.inverseF(this.n, u);
    }

    public double getMean() {
        return StudentDist.getMean(this.n);
    }

    public double getVariance() {
        return StudentDist.getVariance(this.n);
    }

    public double getStandardDeviation() {
        return StudentDist.getStandardDeviation(this.n);
    }

    public static double density(int n, double x) {
        double factor = Num.gammaRatioHalf((double)n / 2.0) / Math.sqrt((double)n * Math.PI);
        return factor * Math.pow(1.0 / (1.0 + x * x / (double)n), (double)(n + 1) / 2.0);
    }

    public static double cdf(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            return CauchyDist.cdf(0.0, 1.0, x);
        }
        if (x > 1.0E10) {
            return 1.0;
        }
        if (n > 100000) {
            return StudentDist.cdfGaver(n, x);
        }
        double r = Math.abs(x);
        if (r < 1.0E15) {
            r = Math.sqrt((double)n + x * x);
        }
        double z = x >= 0.0 ? 0.5 * (1.0 + x / r) : 0.5 * (double)n / (r * (r - x));
        if (n == 2) {
            return z;
        }
        return BetaSymmetricalDist.cdf(0.5 * (double)n, 15, z);
    }

    @Deprecated
    public static double cdf2(int n, int d, double x) {
        if (d <= 0) {
            throw new IllegalArgumentException("student2:   d <= 0");
        }
        return StudentDist.cdf(n, x);
    }

    public static double barF(int n, double x) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        if (n == 1) {
            return CauchyDist.barF(0.0, 1.0, x);
        }
        if (n == 2) {
            double z = Math.abs(x);
            if (z < 1.0E10) {
                z = Math.sqrt(2.0 + x * x);
            }
            if (x <= 0.0) {
                if (x < -1.0E10) {
                    return 1.0;
                }
                return 0.5 * (1.0 - x / z);
            }
            return 1.0 / (z * (z + x));
        }
        return StudentDist.cdf(n, -x);
    }

    public static double inverseF(int n, double u) {
        if (n < 1) {
            throw new IllegalArgumentException("Student:   n < 1");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("Student:   u not in [0, 1]");
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (1 == n) {
            return CauchyDist.inverseF(0.0, 1.0, u);
        }
        if (2 == n) {
            return (2.0 * u - 1.0) / Math.sqrt(2.0 * u * (1.0 - u));
        }
        if (n > 100000) {
            return StudentDist.invGaver(n, u);
        }
        double z = BetaSymmetricalDist.inverseF(0.5 * (double)n, u);
        return (z - 0.5) * Math.sqrt((double)n / (z * (1.0 - z)));
    }

    public static double[] getMLE(double[] x, int m) {
        double fn0;
        double sum = 0.0;
        double[] parameters = new double[1];
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double var = 0.0;
        for (int i = 0; i < m; ++i) {
            var += x[i] * x[i];
        }
        Function f = new Function(x, m);
        double n0 = Math.round(2.0 * (var /= (double)m) / (var - 1.0));
        double min = fn0 = f.evaluate(n0);
        double fn1 = f.evaluate(n0 + 1.0);
        double fn_1 = f.evaluate(n0 - 1.0);
        parameters[0] = n0;
        if (fn_1 > fn0) {
            double n = n0 - 1.0;
            while (true) {
                double d;
                double y = f.evaluate(n);
                if (d > min && n >= 1.0) {
                    min = y;
                    parameters[0] = n;
                    n -= 1.0;
                    continue;
                }
                break;
            }
        } else if (fn1 > fn0) {
            double n = n0 + 1.0;
            while (true) {
                double d;
                double y = f.evaluate(n);
                if (!(d > min)) break;
                min = y;
                parameters[0] = n;
                n += 1.0;
            }
        }
        return parameters;
    }

    public static StudentDist getInstanceFromMLE(double[] x, int m) {
        double[] parameters = StudentDist.getMLE(x, m);
        return new StudentDist((int)parameters[0]);
    }

    public static double getMean(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("n <= 1");
        }
        return 0.0;
    }

    public static double getVariance(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("n <= 2");
        }
        return (double)n / ((double)n - 2.0);
    }

    public static double getStandardDeviation(int n) {
        return Math.sqrt(StudentDist.getVariance(n));
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.factor = Num.gammaRatioHalf((double)n / 2.0) / Math.sqrt((double)n * Math.PI);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double[] xi;

        public Function(double[] x, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(x, 0, this.xi, 0, n);
        }

        public double evaluate(double x) {
            if (x <= 0.0) {
                return 1.0E200;
            }
            double sum = 0.0;
            for (int i = 0; i < this.n; ++i) {
                sum += Math.log(StudentDist.density((int)Math.round(x), this.xi[i]));
            }
            return sum;
        }
    }
}

