/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params;

import fr.profi.mzdb.db.model.params.AbstractXMLParamTree;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;

public abstract class Component
extends AbstractXMLParamTree {
    protected int order;

    public Component() {
    }

    public Component(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public abstract ComponentType getType();

    @XmlAttribute
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt32(this.order);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        this.order = reader.readInt32();
    }

    public static enum ComponentType {
        DETECTOR(0),
        ANALYZER(1),
        SOURCE(2);

        private final int type;
        private static HashMap<Integer, ComponentType> map;

        private ComponentType(int type) {
            this.type = type;
        }

        public int getTypeValue() {
            return this.type;
        }

        public static ComponentType getEnum(int value) throws IOException {
            return map.get(value);
        }

        static {
            map = new HashMap();
            for (ComponentType aType : ComponentType.values()) {
                map.put(aType.type, aType);
            }
        }
    }
}

