/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer;

import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.io.writer.BoundingBoxToWrite;
import fr.profi.mzdb.io.writer.SpectrumSliceIndex;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.IsolationWindow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public class BoundingBoxCache {
    private BBSizes bbSizes;
    private int bbId = 0;
    private HashMap<MsLevelAndIsolationWindowKey, TreeMap<Integer, BoundingBoxToWrite>> level2BoundingBoxMap = new HashMap();
    private HashMap<MsLevelAndIsolationWindowKey, Float> firstTimeMap = new HashMap();
    private static final MsLevelAndIsolationWindowKey msLevelAndIsolationWindowKey = new MsLevelAndIsolationWindowKey();

    public BoundingBoxCache(BBSizes bbs) {
        this.bbSizes = bbs;
    }

    public Boolean isTimeForNewBBRow(Integer msLevel, IsolationWindow isolationWindow, Float curSpecTime) {
        Float bbRowFirstSpecTime = this._findBBFirstTime(msLevel, isolationWindow);
        if (bbRowFirstSpecTime == null) {
            return true;
        }
        float maxRtWidth = msLevel == 1 ? this.bbSizes.BB_RT_WIDTH_MS1 : this.bbSizes.BB_RT_WIDTH_MSn;
        return curSpecTime.floatValue() - bbRowFirstSpecTime.floatValue() > maxRtWidth;
    }

    private Float _findBBFirstTime(Integer msLevel, IsolationWindow isolationWindow) {
        BoundingBoxCache.msLevelAndIsolationWindowKey.msLevel = msLevel;
        BoundingBoxCache.msLevelAndIsolationWindowKey.isolationWindow = isolationWindow;
        Float firstTime = this.firstTimeMap.get(msLevelAndIsolationWindowKey);
        return firstTime;
    }

    protected void forEachCachedBB(Integer msLevel, IsolationWindow isolationWindow, Function<BoundingBoxToWrite, Void> fn) {
        BoundingBoxCache.msLevelAndIsolationWindowKey.msLevel = msLevel;
        BoundingBoxCache.msLevelAndIsolationWindowKey.isolationWindow = isolationWindow;
        TreeMap<Integer, BoundingBoxToWrite> map = this.level2BoundingBoxMap.get(msLevelAndIsolationWindowKey);
        if (map != null) {
            for (BoundingBoxToWrite boundingBoxToWrite : map.values()) {
                fn.apply(boundingBoxToWrite);
            }
        }
    }

    protected BoundingBoxToWrite hasOneCachedBBWithOneSpectrum(Integer msLevel, IsolationWindow isolationWindow) {
        BoundingBoxToWrite bb;
        List<Long> spectrumIds;
        BoundingBoxCache.msLevelAndIsolationWindowKey.msLevel = msLevel;
        BoundingBoxCache.msLevelAndIsolationWindowKey.isolationWindow = isolationWindow;
        TreeMap<Integer, BoundingBoxToWrite> map = this.level2BoundingBoxMap.get(msLevelAndIsolationWindowKey);
        if (map == null) {
            return null;
        }
        if (map.size() == 1 && (spectrumIds = (bb = map.values().iterator().next()).getSpectrumIds()).size() == 1) {
            return bb;
        }
        return null;
    }

    public void removeBBRow(Integer msLevel, IsolationWindow isolationWindow) {
        BoundingBoxCache.msLevelAndIsolationWindowKey.msLevel = msLevel;
        BoundingBoxCache.msLevelAndIsolationWindowKey.isolationWindow = isolationWindow;
        this.level2BoundingBoxMap.remove(msLevelAndIsolationWindowKey);
        this.firstTimeMap.remove(msLevelAndIsolationWindowKey);
    }

    public Set<MsLevelAndIsolationWindowKey> getBBRowsKeys() {
        return new HashSet<MsLevelAndIsolationWindowKey>(this.level2BoundingBoxMap.keySet());
    }

    public BoundingBoxToWrite getCachedBoundingBox(Integer msLevel, Integer runSliceId, IsolationWindow isolationWindow) {
        BoundingBoxCache.msLevelAndIsolationWindowKey.msLevel = msLevel;
        BoundingBoxCache.msLevelAndIsolationWindowKey.isolationWindow = isolationWindow;
        TreeMap<Integer, BoundingBoxToWrite> map = this.level2BoundingBoxMap.get(msLevelAndIsolationWindowKey);
        if (map == null) {
            return null;
        }
        BoundingBoxToWrite boundingBoxToWrite = map.get(runSliceId);
        return boundingBoxToWrite;
    }

    public BoundingBoxToWrite createBoundingBox(Float spectrumTime, Integer runSliceId, Integer msLevel, DataEncoding de, IsolationWindow isolationWindow, Integer slicesCountHint) {
        BoundingBoxCache.msLevelAndIsolationWindowKey.msLevel = msLevel;
        BoundingBoxCache.msLevelAndIsolationWindowKey.isolationWindow = isolationWindow;
        TreeMap<Integer, BoundingBoxToWrite> map = this.level2BoundingBoxMap.get(msLevelAndIsolationWindowKey);
        if (map == null) {
            map = new TreeMap();
            MsLevelAndIsolationWindowKey key = new MsLevelAndIsolationWindowKey();
            key.msLevel = msLevel;
            key.isolationWindow = isolationWindow;
            this.level2BoundingBoxMap.put(key, map);
            this.firstTimeMap.put(key, spectrumTime);
        } else {
            Float firstTime = this.firstTimeMap.get(msLevelAndIsolationWindowKey);
            if (firstTime.floatValue() > spectrumTime.floatValue()) {
                MsLevelAndIsolationWindowKey key = new MsLevelAndIsolationWindowKey();
                key.msLevel = msLevel;
                key.isolationWindow = isolationWindow;
                this.firstTimeMap.put(key, spectrumTime);
            }
        }
        ++this.bbId;
        BoundingBoxToWrite newOrCachedBB = new BoundingBoxToWrite();
        newOrCachedBB.setSpectrumIds(new ArrayList<Long>(slicesCountHint));
        newOrCachedBB.setSpectrumSlices(new ArrayList<SpectrumSliceIndex>(slicesCountHint));
        newOrCachedBB.setId(this.bbId);
        newOrCachedBB.setFirstTime(spectrumTime);
        newOrCachedBB.setLastTime(spectrumTime);
        newOrCachedBB.setRunSliceId(runSliceId);
        newOrCachedBB.setMsLevel(msLevel);
        newOrCachedBB.setDataEncoding(de);
        newOrCachedBB.setIsolationWindow(isolationWindow);
        map.put(runSliceId, newOrCachedBB);
        return newOrCachedBB;
    }

    public void dump() {
    }

    public static class MsLevelAndIsolationWindowKey {
        public int msLevel;
        public IsolationWindow isolationWindow = null;

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof MsLevelAndIsolationWindowKey) {
                MsLevelAndIsolationWindowKey s = (MsLevelAndIsolationWindowKey)obj;
                if (s.msLevel != this.msLevel) {
                    return false;
                }
                return Objects.equals(this.isolationWindow, s.isolationWindow);
            }
            return false;
        }

        public int hashCode() {
            if (this.isolationWindow == null) {
                return this.msLevel * 31;
            }
            return this.msLevel * 31 + this.isolationWindow.hashCode();
        }
    }
}

