/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.sqlite;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordOperation;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import fr.profi.mzdb.util.sqlite.SQLiteRecordIterator;
import fr.profi.mzdb.util.sqlite.SQLiteResultDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SQLiteQuery {
    private String queryString = null;
    private SQLiteStatement stmt = null;
    private SQLiteResultDescriptor resultDesc = null;

    public SQLiteQuery(SQLiteConnection connection, String sqlQuery, boolean cacheStmt) throws SQLiteException {
        this.queryString = sqlQuery;
        this.stmt = connection.prepare(sqlQuery, cacheStmt);
        HashMap<String, Integer> colIdxByColName = new HashMap<String, Integer>();
        int nbCols = this.stmt.columnCount();
        for (int colIdx = 0; colIdx < nbCols; ++colIdx) {
            String colName = this.stmt.getColumnName(colIdx);
            colIdxByColName.put(colName, colIdx);
        }
        this.resultDesc = new SQLiteResultDescriptor(colIdxByColName);
    }

    public SQLiteQuery(SQLiteConnection connection, String sqlQuery) throws SQLiteException {
        this(connection, sqlQuery, true);
    }

    public int getColumnIndex(String colName) throws SQLiteException {
        if (!this.resultDesc.colIdxByColName.containsKey(colName)) {
            throw new SQLiteException(-1, "undefined column '" + colName + "' in query: " + this.queryString);
        }
        return this.resultDesc.colIdxByColName.get(colName);
    }

    public String[] getColumnNames() {
        return this.resultDesc.getColumnNames();
    }

    public SQLiteStatement getStatement() {
        return this.stmt;
    }

    public void dispose() {
        if (!this.isStatementDisposed()) {
            this.stmt.dispose();
            this.stmt = null;
        }
    }

    public boolean isStatementDisposed() {
        return this.stmt == null || this.stmt.isDisposed();
    }

    public SQLiteQuery bind(int index, double value) throws SQLiteException {
        this.stmt.bind(index, value);
        return this;
    }

    public SQLiteQuery bind(int index, int value) throws SQLiteException {
        this.stmt.bind(index, value);
        return this;
    }

    public SQLiteQuery bind(int index, long value) throws SQLiteException {
        this.stmt.bind(index, value);
        return this;
    }

    public SQLiteQuery bind(int index, String value) throws SQLiteException {
        this.stmt.bind(index, value);
        return this;
    }

    public SQLiteQuery bind(int index, byte[] value) throws SQLiteException {
        this.stmt.bind(index, value);
        return this;
    }

    public SQLiteQuery bind(int index, byte[] value, int offset, int length) throws SQLiteException {
        this.stmt.bind(index, value, offset, length);
        return this;
    }

    public SQLiteQuery bindZeroBlob(int index, int length) throws SQLiteException {
        this.stmt.bindZeroBlob(index, length);
        return this;
    }

    public SQLiteQuery bindNull(int index) throws SQLiteException {
        this.stmt.bindNull(index);
        return this;
    }

    public OutputStream bindStream(int index) throws SQLiteException {
        return this.stmt.bindStream(index, 0);
    }

    public OutputStream bindStream(int index, int bufferSize) throws SQLiteException {
        return this.stmt.bindStream(index, bufferSize);
    }

    public SQLiteRecordIterator getRecordIterator() throws SQLiteException {
        return new SQLiteRecordIterator(this);
    }

    public void forEachRecord(ISQLiteRecordOperation op) throws SQLiteException {
        if (!this.isStatementDisposed()) {
            int idx = 0;
            while (this.stmt.step()) {
                op.execute(new SQLiteRecord(this), idx);
                ++idx;
            }
            this.dispose();
        }
    }

    public <T> T[] extractRecords(ISQLiteRecordExtraction<T> extractor, T[] records) throws SQLiteException {
        if (!this.isStatementDisposed()) {
            int recordsCount = records.length;
            for (int idx = 0; this.stmt.step() && idx < recordsCount; ++idx) {
                records[idx] = extractor.extract(new SQLiteRecord(this));
            }
            this.dispose();
        }
        return records;
    }

    public <T> List<T> extractRecordList(ISQLiteRecordExtraction<T> extractor) throws SQLiteException {
        ArrayList<T> records = new ArrayList<T>();
        if (!this.isStatementDisposed()) {
            while (this.stmt.step()) {
                records.add(extractor.extract(new SQLiteRecord(this)));
            }
            this.dispose();
        }
        return records;
    }

    public <T> T extractRecord(ISQLiteRecordExtraction<T> extractor) throws SQLiteException {
        this.stmt.step();
        T obj = extractor.extract(new SQLiteRecord(this));
        this.dispose();
        return obj;
    }

    public String[] extractStrings(int bufferLength) throws SQLiteException {
        if (!this.isStatementDisposed()) {
            String[] buffer = new String[bufferLength];
            int idx = 0;
            while (this.stmt.step()) {
                buffer[idx] = this.stmt.columnString(0);
                ++idx;
            }
            this.dispose();
            return Arrays.copyOfRange(buffer, 0, idx - 1);
        }
        return new String[0];
    }

    public int[] extractInts(int bufferLength) throws SQLiteException {
        int[] buffer = new int[bufferLength];
        int loadedInts = this.stmt.loadInts(0, buffer, 0, bufferLength);
        this.dispose();
        return Arrays.copyOfRange(buffer, 0, loadedInts - 1);
    }

    public long[] extractLongs(int bufferLength) throws SQLiteException {
        long[] buffer = new long[bufferLength];
        int loadedLongs = this.stmt.loadLongs(0, buffer, 0, bufferLength);
        this.dispose();
        return Arrays.copyOfRange(buffer, 0, loadedLongs - 1);
    }

    public float[] extractFloats(int bufferLength) throws SQLiteException {
        if (!this.isStatementDisposed()) {
            float[] buffer = new float[bufferLength];
            int idx = 0;
            while (this.stmt.step()) {
                buffer[idx] = (float)this.stmt.columnDouble(0);
                ++idx;
            }
            this.dispose();
            return Arrays.copyOfRange(buffer, 0, idx - 1);
        }
        return new float[0];
    }

    public double[] extractDoubles(int bufferLength) throws SQLiteException {
        double[] buffer = null;
        if (!this.isStatementDisposed()) {
            buffer = new double[bufferLength];
            int idx = 0;
            while (this.stmt.step()) {
                buffer[idx] = this.stmt.columnDouble(0);
                ++idx;
            }
            this.dispose();
            return Arrays.copyOfRange(buffer, 0, idx - 1);
        }
        return new double[0];
    }

    public String extractSingleString() throws SQLiteException {
        boolean dataToRead = this.stmt.step();
        String result = null;
        if (dataToRead) {
            result = this.stmt.columnString(0);
        }
        this.dispose();
        return result;
    }

    public int extractSingleInt() throws SQLiteException {
        this.stmt.step();
        int result = this.stmt.columnInt(0);
        this.dispose();
        return result;
    }

    public long extractSingleLong() throws SQLiteException {
        this.stmt.step();
        long result = this.stmt.columnLong(0);
        this.dispose();
        return result;
    }

    public double extractSingleDouble() throws SQLiteException {
        this.stmt.step();
        double result = this.stmt.columnDouble(0);
        this.dispose();
        return result;
    }

    public byte[] extractSingleBlob() throws SQLiteException {
        this.stmt.step();
        if (!this.stmt.hasRow()) {
            return null;
        }
        byte[] result = this.stmt.columnBlob(0);
        this.dispose();
        return result;
    }

    public InputStream extractSingleInputStream() throws SQLiteException {
        this.stmt.step();
        InputStream result = this.stmt.columnStream(0);
        this.dispose();
        return result;
    }
}

