/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.profi.mzdb.model.SpectrumData;

public class Spectrum {
    protected String title;
    protected Integer index;
    protected int msLevel;
    protected ScanType dataType;
    protected float retentionTime;
    protected SpectrumData spectrumData;
    protected Double precursorMz;
    protected Integer precursorCharge;

    public Spectrum(Integer index, float rt, double[] masses, float[] intensities, int msLevel) {
        this(index, rt, masses, intensities, msLevel, msLevel == 2 ? ScanType.CENTROID : ScanType.PROFILE);
    }

    public Spectrum(Integer index, float rt, double[] masses, float[] intensities, int msLevel, ScanType type) {
        this(index, rt, new SpectrumData(masses, intensities), msLevel, type);
    }

    public Spectrum(Integer index, float rt, SpectrumData spectrumData, int msLevel, ScanType type) {
        this.index = index;
        this.retentionTime = rt;
        this.msLevel = msLevel;
        this.dataType = type;
        this.spectrumData = spectrumData;
    }

    public double[] getMasses() {
        return this.spectrumData.getMzList();
    }

    public float[] getIntensities() {
        return this.spectrumData.getIntensityList();
    }

    public Integer getIndex() {
        return this.index;
    }

    public float getRetentionTime() {
        return this.retentionTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public SpectrumData getSpectrumData() {
        return this.spectrumData;
    }

    public boolean hasIonMobilitySeparation() {
        return false;
    }

    public ScanType getDataType() {
        return this.dataType;
    }

    public Double getPrecursorMz() {
        return this.precursorMz;
    }

    public void setPrecursorMz(Double precursorMz) {
        this.precursorMz = precursorMz;
    }

    public Integer getPrecursorCharge() {
        return this.precursorCharge;
    }

    public void setPrecursorCharge(Integer precursorCharge) {
        this.precursorCharge = precursorCharge;
    }

    public static enum ScanType {
        CENTROID,
        PROFILE;

    }
}

