/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.Signal;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.AbstractRawFilePanel;
import fr.proline.mzscope.ui.SignalViewerBuilder;
import fr.proline.mzscope.utils.Display;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleRawFilePanel
extends AbstractRawFilePanel {
    private static final Logger logger = LoggerFactory.getLogger(SingleRawFilePanel.class);
    private IRawFile rawfile;

    public SingleRawFilePanel(IRawFile rawfile, boolean displayDefaultChrom) {
        this.rawfile = rawfile;
        this.updateToolbar();
        if (displayDefaultChrom) {
            this.displayTIC(-1);
        }
    }

    public SingleRawFilePanel(IRawFile rawfile) {
        this(rawfile, true);
    }

    @Override
    public IRawFile getCurrentRawfile() {
        return this.rawfile;
    }

    @Override
    public List<IRawFile> getAllRawfiles() {
        if (this.rawfile == null) {
            return null;
        }
        return Collections.singletonList(this.rawfile);
    }

    protected JToolBar updateToolbar() {
        this.chromatogramToolbar.addSeparator();
        JButton editFeatureBtn = new JButton();
        editFeatureBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SIGNAL));
        editFeatureBtn.setToolTipText("IChromatogram signal processing dialog");
        editFeatureBtn.addActionListener(e -> this.editFeature());
        this.chromatogramToolbar.add(editFeatureBtn);
        return this.chromatogramToolbar;
    }

    private void editFeature() {
        double min = this.chromatogramPanel.getChromatogramPlotPanel().getXAxis().getMinValue();
        double max = this.chromatogramPanel.getChromatogramPlotPanel().getXAxis().getMaxValue();
        ArrayList<Signal> signals = new ArrayList<Signal>();
        Iterable<IChromatogram> chromatograms = this.getAllChromatograms();
        for (IChromatogram chrom : chromatograms) {
            int minIdx = SpectrumUtils.getNearestPeakIndex(chrom.getTime(), min);
            int maxIdx = Math.min(SpectrumUtils.getNearestPeakIndex(chrom.getTime(), max) + 1, chrom.getTime().length);
            Signal signal = new Signal(Arrays.copyOfRange(chrom.getTime(), minIdx, maxIdx), Arrays.copyOfRange(chrom.getIntensities(), minIdx, maxIdx));
            signal.setSignalType(0);
            signals.add(signal);
        }
        JDialog dialog = new JDialog((JFrame)this.getTopLevelAncestor(), "Feature editor", true);
        dialog.setContentPane(SignalViewerBuilder.buildEditor(signals));
        dialog.pack();
        dialog.setVisible(true);
        logger.info("Edit feature within range " + min + ", " + max);
    }

    @Override
    public void displayTIC(final int msLevel) {
        final IRawFile rawFile = this.rawfile;
        if (this.rawFileLoading != null) {
            this.rawFileLoading.setWaitingState(true);
        }
        logger.info("Display single TIC chromatogram");
        SwingWorker<IChromatogram, Void> worker = new SwingWorker<IChromatogram, Void>(){

            @Override
            protected IChromatogram doInBackground() throws Exception {
                return rawFile.getTIC(msLevel);
            }

            @Override
            protected void done() {
                try {
                    SingleRawFilePanel.this.displayChromatogram((IChromatogram)this.get(), new Display(Display.Mode.REPLACE));
                    SingleRawFilePanel.this.setMsMsEventButtonEnabled(false);
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
                finally {
                    if (SingleRawFilePanel.this.rawFileLoading != null) {
                        SingleRawFilePanel.this.rawFileLoading.setWaitingState(false);
                    }
                }
            }
        };
        worker.execute();
    }

    @Override
    public void displayBPI() {
        if (this.rawFileLoading != null) {
            this.rawFileLoading.setWaitingState(true);
        }
        final IRawFile rawFile = this.rawfile;
        logger.info("Display single base peak chromatogram");
        SwingWorker<IChromatogram, Void> worker = new SwingWorker<IChromatogram, Void>(){

            @Override
            protected IChromatogram doInBackground() throws Exception {
                return rawFile.getBPI();
            }

            @Override
            protected void done() {
                try {
                    SingleRawFilePanel.this.displayChromatogram((IChromatogram)this.get(), new Display(Display.Mode.REPLACE));
                    SingleRawFilePanel.this.setMsMsEventButtonEnabled(false);
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
                finally {
                    if (SingleRawFilePanel.this.rawFileLoading != null) {
                        SingleRawFilePanel.this.rawFileLoading.setWaitingState(false);
                    }
                }
            }
        };
        worker.execute();
    }

    @Override
    public Color getPlotColor(String rawFilename) {
        return CyclicColorPalette.getColor((int)1);
    }
}

