/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.type.NumberDefinition;

public interface UnaryFunction<N extends Comparable<N>>
extends BasicFunction,
UnaryOperator<N>,
DoubleUnaryOperator {
    public static <N extends Comparable<N>> boolean isZeroModified(UnaryFunction<N> function) {
        return !PrimitiveScalar.isSmall(PrimitiveMath.ONE, function.invoke(PrimitiveMath.ZERO));
    }

    default public UnaryFunction<N> andThen(final UnaryFunction<N> after) {
        ProgrammingError.throwIfNull(after);
        return new UnaryFunction<N>(){

            @Override
            public double invoke(double arg) {
                return after.invoke(UnaryFunction.this.invoke(arg));
            }

            @Override
            public float invoke(float arg) {
                return after.invoke(UnaryFunction.this.invoke(arg));
            }

            @Override
            public N invoke(N arg) {
                return after.invoke(UnaryFunction.this.invoke(arg));
            }
        };
    }

    @Override
    default public N apply(N arg) {
        return this.invoke(arg);
    }

    @Override
    default public double applyAsDouble(double arg) {
        return this.invoke(arg);
    }

    default public UnaryFunction<N> compose(final UnaryFunction<N> before) {
        ProgrammingError.throwIfNull(before);
        return new UnaryFunction<N>(){

            @Override
            public double invoke(double arg) {
                return UnaryFunction.this.invoke(before.invoke(arg));
            }

            @Override
            public float invoke(float arg) {
                return UnaryFunction.this.invoke(before.invoke(arg));
            }

            @Override
            public N invoke(N arg) {
                return UnaryFunction.this.invoke(before.invoke(arg));
            }
        };
    }

    default public byte invoke(byte arg) {
        return (byte)this.invoke((double)arg);
    }

    public double invoke(double var1);

    default public float invoke(float arg) {
        return (float)this.invoke((double)arg);
    }

    default public int invoke(int arg) {
        return NumberDefinition.toInt(this.invoke((double)arg));
    }

    default public long invoke(long arg) {
        return NumberDefinition.toLong(this.invoke((double)arg));
    }

    public N invoke(N var1);

    default public short invoke(short arg) {
        return (short)this.invoke((double)arg);
    }
}

