/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.Arrays;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.SparseArray;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.task.iterative.ConjugateGradientSolver;
import org.ojalgo.matrix.task.iterative.MutableSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ActiveSetSolver;
import org.ojalgo.optimisation.convex.BasePrimitiveSolver;
import org.ojalgo.optimisation.convex.ConvexData;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Operate2D;
import org.ojalgo.type.ObjectPool;

final class IterativeASS
extends ActiveSetSolver {
    private final PhysicalStore<Double> myColumnInvQAt;
    private final SchurComplementSolver myS = new SchurComplementSolver();

    IterativeASS(ConvexData<Double> convexSolverBuilder, Optimisation.Options optimisationOptions) {
        super(convexSolverBuilder, optimisationOptions);
        this.myColumnInvQAt = (PhysicalStore)MATRIX_FACTORY.make(this.countVariables(), 1);
    }

    @Override
    protected void exclude(int toExclude) {
        super.exclude(toExclude);
        this.myS.remove(this.countEqualityConstraints() + toExclude);
    }

    @Override
    protected void performIteration() {
        Primitive64Store tmpXL;
        if (this.isLogProgress()) {
            this.log();
            this.log("PerformIteration {}", 1 + this.countIterations());
            this.log(this.toActivatorString(), new Object[0]);
        }
        int toInclude = this.getConstraintToInclude();
        this.setConstraintToInclude(-1);
        int[] incl = this.getIncluded();
        int[] excl = this.getExcluded();
        boolean solved = false;
        if (toInclude >= 0) {
            int constrIndex = this.countEqualityConstraints() + toInclude;
            SparseArray<Double> constrBody = this.getMatrixAI(toInclude);
            double constrRHS = this.getMatrixBI(toInclude);
            this.addConstraint(constrIndex, constrBody, constrRHS);
        }
        Primitive64Store iterX = this.getIterationX();
        if (this.countIterationConstraints() <= this.countVariables() && (solved = this.isSolvableQ())) {
            MatrixStore<Double> invQC = this.getInvQC();
            if ((long)this.countIterationConstraints() == 0L) {
                iterX.fillMatching(invQC);
            } else {
                double relativeError = this.myS.resolve(this.getSolutionL());
                if (this.isLogDebug()) {
                    this.log("RHS={}", new Object[]{this.myS.getRHS()});
                    this.log("Relative error {} in solution for L={}", relativeError, Arrays.toString(this.getIterationL(incl).toRawCopy1D()));
                }
                if (solved = this.options.convex().iterative().isZero(relativeError)) {
                    Operate2D rhsX = this.getIterationL(incl).premultiply(this.getIterationA().transpose()).onMatching(this.getIterationC(), (BinaryFunction)PrimitiveMath.SUBTRACT);
                    this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)rhsX), iterX);
                }
            }
        }
        if (!solved && (solved = this.solveFullKKT(tmpXL = (Primitive64Store)MATRIX_FACTORY.make((long)(this.countVariables() + this.countIterationConstraints()), 1L)))) {
            iterX.fillMatching((Access1D<?>)((Object)tmpXL.limits(this.countVariables(), 1L)));
            for (int i = 0; i < this.countEqualityConstraints(); ++i) {
                this.getSolutionL().set((long)i, tmpXL.doubleValue((long)(this.countVariables() + i)));
            }
            int tmpLengthIncluded = incl.length;
            for (int i = 0; i < tmpLengthIncluded; ++i) {
                this.getSolutionL().set((long)(this.countEqualityConstraints() + incl[i]), tmpXL.doubleValue((long)(this.countVariables() + this.countEqualityConstraints() + i)));
            }
        }
        this.handleIterationResults(solved, iterX, incl, excl);
    }

    void addConstraint(int constrIndex, SparseArray<Double> constrBody, double constrRHS) {
        MatrixStore<Double> body = this.getSolutionQ(Access2D.newPrimitiveColumnCollectable(constrBody), this.myColumnInvQAt);
        double rhs = constrBody.dot(this.getInvQC()) - constrRHS;
        this.myS.add(constrIndex, body, rhs);
    }

    @Override
    void resetActivator() {
        super.resetActivator();
        int nbEqus = this.countEqualityConstraints();
        int nbVars = this.countVariables();
        this.myS.clear();
        int[] incl = this.getIncluded();
        if (nbEqus + incl.length > 0) {
            int j;
            MatrixStore<Double> iterA = this.getIterationA();
            MatrixStore<Double> iterB = this.getIterationB();
            MatrixStore<Double> tmpCols = this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)iterA.transpose()));
            MatrixStore tmpRHS = (MatrixStore)this.getInvQC().premultiply(iterA).onMatching((BinaryFunction)PrimitiveMath.SUBTRACT, iterB).collect(MATRIX_FACTORY);
            for (j = 0; j < nbEqus; ++j) {
                this.myS.add(j, tmpCols.sliceColumn(j), tmpRHS.doubleValue(j));
            }
            for (j = 0; j < incl.length; ++j) {
                this.myS.add(nbEqus + incl[j], tmpCols.sliceColumn(nbEqus + j), tmpRHS.doubleValue(nbEqus + j));
            }
        }
    }

    static final class SparseArrayPool
    extends ObjectPool<BasicArray<Double>> {
        private static final SparseArray.SparseFactory<Double> ARRAY_FACTORY = (SparseArray.SparseFactory)SparseArray.factory(ArrayR064.FACTORY).initial(3L);
        private final int myCount;

        SparseArrayPool(int count) {
            this.myCount = count;
        }

        @Override
        protected BasicArray<Double> newObject() {
            return (BasicArray)ARRAY_FACTORY.make(this.myCount);
        }

        @Override
        protected void reset(BasicArray<Double> object) {
            object.reset();
        }
    }

    final class SchurComplementSolver
    extends MutableSolver<ConjugateGradientSolver>
    implements MatrixStore<Double> {
        private final int myCountE;
        private final SparseArrayPool myEquationBodyPool;
        private final int myFullDim;
        private final Equation[] myIterationRows;

        SchurComplementSolver() {
            super(new ConjugateGradientSolver(), IterativeASS.this.countEqualityConstraints() + IterativeASS.this.countInequalityConstraints());
            this.myCountE = IterativeASS.this.countEqualityConstraints();
            this.myFullDim = this.myCountE + IterativeASS.this.countInequalityConstraints();
            this.setAccuracyContext(IterativeASS.this.options.convex().iterative());
            this.setIterationsLimit(this.myFullDim + this.myFullDim);
            this.myEquationBodyPool = new SparseArrayPool(this.myFullDim);
            this.myIterationRows = new Equation[this.myFullDim];
        }

        @Override
        public long countColumns() {
            return IterativeASS.this.countEqualityConstraints() + IterativeASS.this.countIncluded();
        }

        @Override
        public long countRows() {
            return IterativeASS.this.countEqualityConstraints() + IterativeASS.this.countIncluded();
        }

        @Override
        public double doubleValue(long row, long col) {
            int intRow = (int)row;
            int intCol = (int)col;
            if (intCol >= this.myCountE) {
                intCol = this.myCountE + IterativeASS.this.getIncluded(intCol - this.myCountE);
            }
            return this.doubleValue(intRow, intCol);
        }

        @Override
        public Double get(long row, long col) {
            return this.doubleValue(row, col);
        }

        @Override
        public PhysicalStore.Factory<Double, ?> physical() {
            return BasePrimitiveSolver.MATRIX_FACTORY;
        }

        void add(int j, Access1D<Double> column, double rhs) {
            double tmpVal;
            Equation tmpNewRow;
            int[] incl = IterativeASS.this.getIncluded();
            this.myIterationRows[j] = tmpNewRow = Equation.wrap((BasicArray)this.myEquationBodyPool.borrow(), j, rhs);
            this.add(tmpNewRow);
            if (this.myCountE > 0) {
                for (int i = 0; i < this.myCountE; ++i) {
                    tmpVal = IterativeASS.this.getMatrixAE(i).dot(column);
                    if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                    Equation tmpRowE = this.myIterationRows[i];
                    if (tmpRowE != null) {
                        tmpRowE.set((long)j, tmpVal);
                    }
                    tmpNewRow.set((long)i, tmpVal);
                }
            }
            if (incl.length > 0) {
                for (int _i = 0; _i < incl.length; ++_i) {
                    tmpVal = IterativeASS.this.getMatrixAI(incl[_i]).dot(column);
                    if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                    int i = this.myCountE + incl[_i];
                    Equation tmpRowI = this.myIterationRows[i];
                    if (tmpRowI != null) {
                        tmpRowI.set((long)j, tmpVal);
                    }
                    tmpNewRow.set((long)i, tmpVal);
                }
            }
            tmpNewRow.initialise(IterativeASS.this.getSolutionL());
        }

        void remove(int i) {
            Equation rowI = this.myIterationRows[i];
            if (rowI != null) {
                this.remove(rowI);
                this.myEquationBodyPool.giveBack(rowI.getBody());
            }
            this.myIterationRows[i] = null;
            IterativeASS.this.getSolutionL().set((long)i, PrimitiveMath.ZERO);
        }
    }
}

