/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.IntermediateSolver;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.integer.ModelStrategy;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;
import org.ojalgo.type.keyvalue.EntryPair;

public final class NodeSolver
extends IntermediateSolver {
    private static final NumberContext PRECISION = NumberContext.of(12);
    private static final NumberContext COEFFICIENT = PRECISION.withMode(RoundingMode.CEILING);
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final boolean DEBUG = false;
    private static final NumberContext DYNANISM = NumberContext.of(8);
    private static final NumberContext LIMIT = PRECISION.withMode(RoundingMode.FLOOR);
    private static final NumberContext SCALE = NumberContext.of(14);

    NodeSolver(ExpressionsBasedModel model) {
        super(model);
    }

    boolean generateCuts(ModelStrategy strategy) {
        boolean retVal = this.generateCuts(strategy, this.getModel());
        if (retVal) {
            this.reset();
        }
        return retVal;
    }

    boolean generateCuts(ModelStrategy strategy, ExpressionsBasedModel target) {
        UpdatableSolver solver;
        UpdatableSolver.EntityMap entityMap;
        if (!this.isSolved()) {
            return false;
        }
        ExpressionsBasedModel model = this.getModel();
        Optimisation.Result result = this.getResult();
        long nbConstr = model.constraints().count();
        if (this.getSolver() instanceof UpdatableSolver && (entityMap = (solver = (UpdatableSolver)this.getSolver()).getEntityMap()) != null) {
            int i;
            int nbProblVars = entityMap.countModelVariables();
            int nbProblInts = strategy.countIntegerVariables();
            int nbSlackVars = entityMap.countSlackVariables();
            boolean[] integers = new boolean[nbProblVars + nbSlackVars];
            for (i = 0; i < nbProblInts; ++i) {
                int indexInModel = strategy.getIndex(i);
                int indexInSolver = this.getIndexInSolver(indexInModel);
                if (indexInSolver < 0) continue;
                integers[indexInSolver] = true;
            }
            for (i = 0; i < nbSlackVars; ++i) {
                boolean integer;
                EntryPair<ModelEntity<?>, Optimisation.ConstraintType> slack = entityMap.getSlack(i);
                ModelEntity key = (ModelEntity)slack.getKey();
                integers[nbProblVars + i] = integer = key.isInteger();
            }
            Collection<Equation> potentialCuts = solver.generateCutCandidates(strategy.getGMICutConfiguration().fractionality, integers);
            for (Equation equation : potentialCuts) {
                int j;
                String name = "CUT_GMI_" + equation.index + "_" + COUNTER.incrementAndGet();
                Expression cut = target.newExpression(name);
                cut.lower(BigMath.ONE);
                for (j = 0; j < nbProblVars; ++j) {
                    int mj = entityMap.indexOf(j);
                    double aj = equation.doubleValue(j);
                    if (SCALE.isZero(aj)) continue;
                    if (entityMap.isNegated(j)) {
                        cut.add(mj, -aj);
                        continue;
                    }
                    cut.add(mj, aj);
                }
                for (j = 0; j < entityMap.countSlackVariables(); ++j) {
                    BigDecimal shift;
                    BigDecimal limit;
                    BigDecimal factor;
                    double aj = equation.doubleValue(nbProblVars + j);
                    if (SCALE.isZero(aj)) continue;
                    EntryPair<ModelEntity<?>, Optimisation.ConstraintType> pair = entityMap.getSlack(j);
                    ModelEntity modelEntity = (ModelEntity)pair.getKey();
                    Optimisation.ConstraintType type = (Optimisation.ConstraintType)pair.getValue();
                    BigDecimal coefficient = BigDecimal.valueOf(aj);
                    BigDecimal adjusted = modelEntity.adjust(coefficient);
                    if (Optimisation.ConstraintType.LOWER.equals(type)) {
                        factor = adjusted;
                        limit = modelEntity.getLowerLimit();
                        shift = limit.multiply(factor);
                        cut.shift(shift);
                        modelEntity.addTo(cut, factor);
                    }
                    if (!Optimisation.ConstraintType.UPPER.equals(type)) continue;
                    factor = adjusted.negate();
                    limit = modelEntity.getUpperLimit();
                    shift = limit.multiply(factor);
                    cut.shift(shift);
                    modelEntity.addTo(cut, factor);
                }
                BigDecimal cRHS = cut.getLowerLimit();
                BigDecimal violation = strategy.getGMICutConfiguration().violation;
                if (cRHS.abs().compareTo(violation) > 0) {
                    target.removeExpression(name);
                    continue;
                }
                BigDecimal cLargest = BigMath.ONE;
                for (Map.Entry entry : cut.getLinearEntrySet()) {
                    cLargest = cLargest.max(((BigDecimal)entry.getValue()).abs());
                }
                BigDecimal cSmallest = BigMath.VERY_POSITIVE;
                Iterator<Map.Entry<Structure1D.IntIndex, BigDecimal>> iterator = cut.getLinearEntrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Structure1D.IntIndex, BigDecimal> entry = iterator.next();
                    BigDecimal cValue = entry.getValue();
                    if (!PRECISION.isSmall(cLargest, cValue)) {
                        cSmallest = cSmallest.min(cValue.abs());
                        entry.setValue(COEFFICIENT.enforce(cValue));
                        continue;
                    }
                    cRHS = cRHS.subtract(cValue.multiply(result.get(entry.getKey().index)));
                    iterator.remove();
                }
                cRHS = LIMIT.enforce(cRHS);
                cut.lower(cRHS);
                if (DYNANISM.isSmall(cLargest, cSmallest)) {
                    target.removeExpression(name);
                } else if (model.checkSimilarity(cut)) {
                    target.removeExpression(name);
                } else {
                    cut.tighten();
                }
                if (!target.options.logger_detailed || target.options.logger_appender == null) continue;
                target.options.logger_appender.println("{}: {} < {}", name, cut.getLowerLimit(), cut.getLinearEntrySet());
            }
        }
        return nbConstr != model.constraints().count();
    }
}

