/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.Distribution;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.RandomProcess;
import org.ojalgo.type.keyvalue.EntryPair;

abstract class MultipleValuesBasedProcess<D extends Distribution>
extends AbstractProcess<D> {
    private final TreeSet<EntryPair.KeyedPrimitive<Double>> myObservations = new TreeSet();

    MultipleValuesBasedProcess() {
    }

    public boolean addObservation(Double x, double y) {
        return this.myObservations.add(EntryPair.of(x, y));
    }

    @Override
    public RandomProcess.SimulationResults simulate(int numberOfRealisations, int numberOfSteps, double stepSize) {
        ArrayList<EntryPair.KeyedPrimitive<Double>> initialState = new ArrayList<EntryPair.KeyedPrimitive<Double>>(this.myObservations);
        double initialValue = this.getCurrentValue();
        Array2D tmpRealisationValues = (Array2D)Array2D.R064.make(numberOfRealisations, numberOfSteps);
        for (int r = 0; r < numberOfRealisations; ++r) {
            double tmpCurrentValue = initialValue;
            for (int s = 0; s < numberOfSteps; ++s) {
                tmpCurrentValue = this.doStep(stepSize, this.getNormalisedRandomIncrement());
                tmpRealisationValues.set((long)r, (long)s, tmpCurrentValue);
            }
            this.setObservations(initialState);
        }
        return new RandomProcess.SimulationResults(initialValue, tmpRealisationValues);
    }

    @Override
    double getCurrentValue() {
        return this.myObservations.last().doubleValue();
    }

    TreeSet<EntryPair.KeyedPrimitive<Double>> getObservations() {
        return this.myObservations;
    }

    @Override
    void setCurrentValue(double newValue) {
        if (this.myObservations.size() <= 0) {
            this.myObservations.add(EntryPair.of(Double.valueOf(PrimitiveMath.ZERO), newValue));
        } else {
            this.myObservations.add(EntryPair.of((Double)this.myObservations.pollLast().getKey(), newValue));
        }
    }

    final void setObservations(Collection<? extends EntryPair.KeyedPrimitive<Double>> c) {
        this.myObservations.clear();
        this.myObservations.addAll(c);
    }
}

