/*
 * Decompiled with CFR 0.152.
 */
package org.jsuffixarrays;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jsuffixarrays.CharSequenceAdapter;
import org.jsuffixarrays.DensePositiveDecorator;
import org.jsuffixarrays.ExtraTrailingCellsDecorator;
import org.jsuffixarrays.ISuffixArrayBuilder;
import org.jsuffixarrays.QSufSort;
import org.jsuffixarrays.SuffixData;

public final class SuffixArrays {
    static final int MAX_EXTRA_TRAILING_SPACE = 575;

    private SuffixArrays() {
    }

    public static int[] create(CharSequence s) {
        return SuffixArrays.create(s, SuffixArrays.defaultAlgorithm());
    }

    public static int[] create(CharSequence s, ISuffixArrayBuilder builder) {
        return new CharSequenceAdapter(builder).buildSuffixArray(s);
    }

    public static SuffixData createWithLCP(CharSequence s) {
        return SuffixArrays.createWithLCP(s, SuffixArrays.defaultAlgorithm());
    }

    public static SuffixData createWithLCP(CharSequence s, ISuffixArrayBuilder builder) {
        CharSequenceAdapter adapter = new CharSequenceAdapter(builder);
        int[] sa = adapter.buildSuffixArray(s);
        int[] lcp = SuffixArrays.computeLCP(adapter.input, 0, s.length(), sa);
        return new SuffixData(sa, lcp);
    }

    public static SuffixData createWithLCP(int[] input, int start, int length) {
        DensePositiveDecorator builder = new DensePositiveDecorator(new ExtraTrailingCellsDecorator(SuffixArrays.defaultAlgorithm(), 3));
        return SuffixArrays.createWithLCP(input, start, length, builder);
    }

    public static SuffixData createWithLCP(int[] input, int start, int length, ISuffixArrayBuilder builder) {
        int[] sa = builder.buildSuffixArray(input, start, length);
        int[] lcp = SuffixArrays.computeLCP(input, start, length, sa);
        return new SuffixData(sa, lcp);
    }

    public static int[] computeLCP(int[] input, int start, int length, int[] sa) {
        int[] rank = new int[length];
        for (int i = 0; i < length; ++i) {
            rank[sa[i]] = i;
        }
        int h = 0;
        int[] lcp = new int[length];
        for (int i = 0; i < length; ++i) {
            int k = rank[i];
            if (k == 0) {
                lcp[k] = -1;
            } else {
                int j = sa[k - 1];
                while (i + h < length && j + h < length && input[start + i + h] == input[start + j + h]) {
                    ++h;
                }
                lcp[k] = h;
            }
            if (h <= 0) continue;
            --h;
        }
        return lcp;
    }

    private static ISuffixArrayBuilder defaultAlgorithm() {
        return new QSufSort();
    }

    public static List<CharSequence> toString(CharSequence input, int[] suffixes) {
        String full = ((Object)input).toString();
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < input.length(); ++i) {
            result.add(full.subSequence(suffixes[i], full.length()));
        }
        return result;
    }
}

