/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.BitMatrix;
import umontreal.iro.lecuyer.util.BitVector;

public class GenF2w32
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 2.3283064359965952E-10;
    private static final int Z0 = Integer.MIN_VALUE;
    private static final int W = 32;
    private static final int R = 25;
    private static final int T = 7;
    private static final int W1 = 11;
    private static final int W2 = 11;
    private static final int W3 = 10;
    private static final int Wsplit1 = 21;
    private static final int Wsplit2 = 10;
    private static final int MASK1 = -2097152;
    private static final int MASK2 = 2096128;
    private static final int MASK3 = 1023;
    private static int[] BrmT1;
    private static int[] BrmT2;
    private static int[] BrmT3;
    private static int[] Br1;
    private static int[] Br2;
    private static int[] Br3;
    private static final int BrmT = -425292512;
    private static final int Br = 679131202;
    private static final int modQ = -95446209;
    private static final int w = 300;
    private static final int v = 200;
    private static BitMatrix Apw;
    private static BitMatrix Apz;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream;
    private static boolean initialised;
    private int[] state;
    private int state_i;

    private static void initialisation() {
        curr_stream = new int[]{-1779282517, 191386133, -412300569, -1354841543, 1902095651, 614830253, 1776596463, -1085972159, -1766057093, -1480722395, -1042385481, -2007455287, 766015123, -1235748387, -2323825, -2128487823, -1954398517, -2007169547, 1310772551, 1520096729, 1361841155, -360350515, 1287770895, -2003720031, -1497912613};
        try {
            InputStream is = GenF2w32.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/rng/GenF2w32.dat");
            ObjectInputStream ois = new ObjectInputStream(is);
            Apw = (BitMatrix)ois.readObject();
            Apz = (BitMatrix)ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't find GenF2w32.dat");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        initialised = true;
    }

    private static int multiplyZ(int a, int k, int modPoly) {
        for (int i = 0; i < k; ++i) {
            if ((a & 1) != 0) {
                a = a >>> 1 ^ modPoly;
                continue;
            }
            a >>>= 1;
        }
        return a;
    }

    private static int multiply(int a, int b, int modPoly) {
        int res = 0;
        int verif = 1;
        for (int i = 0; i < 32; ++i) {
            if ((b & verif) != 0) {
                res ^= GenF2w32.multiplyZ(a, 31 - i, modPoly);
            }
            verif <<= 1;
        }
        return res;
    }

    private static void initTables() {
        int i;
        BrmT1 = new int[2048];
        Br1 = new int[2048];
        BrmT2 = new int[2048];
        Br2 = new int[2048];
        BrmT3 = new int[1024];
        Br3 = new int[1024];
        for (i = 0; i < Br1.length; ++i) {
            GenF2w32.BrmT1[i] = GenF2w32.multiply(-425292512, i << 21, -95446209);
            GenF2w32.Br1[i] = GenF2w32.multiply(679131202, i << 21, -95446209);
        }
        for (i = 0; i < Br2.length; ++i) {
            GenF2w32.BrmT2[i] = GenF2w32.multiply(-425292512, i << 10, -95446209);
            GenF2w32.Br2[i] = GenF2w32.multiply(679131202, i << 10, -95446209);
        }
        for (i = 0; i < Br3.length; ++i) {
            GenF2w32.BrmT3[i] = GenF2w32.multiply(-425292512, i, -95446209);
            GenF2w32.Br3[i] = GenF2w32.multiply(679131202, i, -95446209);
        }
    }

    private void advanceSeed(int[] seed, BitMatrix bm) {
        BitVector bv = new BitVector(seed, 800);
        bv = bm.multiply(bv);
        for (int i = 0; i < 25; ++i) {
            seed[i] = bv.getInt(i);
        }
    }

    private GenF2w32(int i) {
        this.state = new int[25];
        for (int j = 0; j < 25; ++j) {
            this.state[j] = 0;
        }
        this.state[i / 32] = 1 << i % 32;
        this.state_i = 24;
    }

    public GenF2w32() {
        if (!initialised) {
            GenF2w32.initialisation();
        }
        this.stream = new int[25];
        this.substream = new int[25];
        this.state = new int[25];
        for (int i = 0; i < 25; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.advanceSeed(curr_stream, Apz);
        this.resetStartStream();
    }

    public GenF2w32(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(int[] seed) {
        int i;
        if (!initialised) {
            GenF2w32.initialisation();
        }
        if (seed.length < 25) {
            throw new IllegalArgumentException("Seed must contain 25values.");
        }
        boolean goodSeed = false;
        for (i = 0; i < 25; ++i) {
            if (seed[i] == 0) continue;
            goodSeed = true;
        }
        if (!goodSeed) {
            throw new IllegalArgumentException("At least one part of the seed must be non-zero.");
        }
        for (i = 0; i < 25; ++i) {
            GenF2w32.curr_stream[i] = seed[i];
        }
    }

    public void setSeed(int[] seed) {
        int i;
        if (seed.length != 25) {
            throw new IllegalArgumentException("Seed must contain 25values.");
        }
        boolean goodSeed = false;
        for (i = 0; i < 25; ++i) {
            if (seed[i] == 0) continue;
            goodSeed = true;
        }
        if (!goodSeed) {
            throw new IllegalArgumentException("At least one part of the seed must be non-zero.");
        }
        for (i = 0; i < 25; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        int[] res = new int[25];
        for (int i = 0; i < 25; ++i) {
            res[i] = this.state[(this.state_i + i) % 25];
        }
        return res;
    }

    public GenF2w32 clone() {
        GenF2w32 retour = null;
        retour = (GenF2w32)super.clone();
        retour.state = new int[25];
        retour.substream = new int[25];
        retour.stream = new int[25];
        for (int i = 0; i < 25; ++i) {
            retour.state[i] = this.state[i];
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        return retour;
    }

    public void resetStartStream() {
        for (int i = 0; i < 25; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.state_i = 24;
        for (int i = 0; i < 25; ++i) {
            this.state[i] = this.substream[i];
        }
    }

    public void resetNextSubstream() {
        this.advanceSeed(this.substream, Apw);
        this.resetStartSubstream();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("The state of the ");
        sb.append(this.name == null ? "GenF2w32" : this.name);
        sb.append(" is : {");
        for (int i = 0; i < 24; ++i) {
            sb.append(this.state[(this.state_i + i) % 25] + ", ");
        }
        sb.append(this.state[(this.state_i + 25 - 1) % 25] + "}");
        return sb.toString();
    }

    protected double nextValue() {
        if (this.state_i < 0) {
            this.state_i = 24;
        }
        if (this.state_i + 7 < 25) {
            int n = this.state_i + 7;
            this.state[n] = this.state[n] ^ (BrmT1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ BrmT2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ BrmT3[this.state[this.state_i] & 0x3FF]);
        } else {
            int n = this.state_i + 7 - 25;
            this.state[n] = this.state[n] ^ (BrmT1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ BrmT2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ BrmT3[this.state[this.state_i] & 0x3FF]);
        }
        this.state[this.state_i] = Br1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ Br2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ Br3[this.state[this.state_i] & 0x3FF];
        long result = this.state[this.state_i--];
        return (double)(result <= 0L ? result + 0x100000000L : result) * 2.3283064359965952E-10;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Must provide the output file.");
            System.exit(1);
        }
        System.out.println("Creating the GenF2w32 state transition matrices.");
        BitVector[] bv = new BitVector[800];
        int[] vect = new int[25];
        for (int i = 0; i < 800; ++i) {
            GenF2w32 gen = new GenF2w32(i);
            gen.nextValue();
            for (int j = 0; j < 25; ++j) {
                vect[j] = gen.state[(j + 25 - 1) % 25];
            }
            bv[i] = new BitVector(vect, 800);
        }
        BitMatrix STp0 = new BitMatrix(bv).transpose();
        BitMatrix STpw = STp0.power2e(300);
        BitMatrix STpz = STpw.power2e(200);
        try {
            FileOutputStream fos = new FileOutputStream(args[0]);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(STpw);
            oos.writeObject(STpz);
            oos.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't create " + args[0]);
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        initialised = false;
        GenF2w32.initTables();
    }
}

