/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import umontreal.iro.lecuyer.functions.MathFunction;

public class RootFinder {
    private RootFinder() {
    }

    public static double brentDekker(double a, double b, MathFunction f, double tol) {
        double e;
        double EPS = 5.0E-16;
        int MAXITER = 120;
        if (b < a) {
            double ctemp = a;
            a = b;
            b = ctemp;
        }
        double fa = f.evaluate(a);
        double fb = f.evaluate(b);
        double c = a;
        double fc = fa;
        double d = e = b - a;
        tol += 7.220446049250313E-16;
        if (Math.abs(fc) < Math.abs(fb)) {
            a = b;
            b = c;
            c = a;
            fa = fb;
            fb = fc;
            fc = fa;
        }
        for (int i = 0; i < 120; ++i) {
            double tol1 = tol + 8.881784197001252E-16 * Math.abs(b);
            double xm = 0.5 * (c - b);
            if (Math.abs(fb) == 0.0 || Math.abs(xm) <= tol1) {
                return b;
            }
            if (Math.abs(e) >= tol1 && Math.abs(fa) > Math.abs(fb)) {
                double p;
                double s;
                double q;
                if (a != c) {
                    q = fa / fc;
                    double r = fb / fc;
                    s = fb / fa;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                } else {
                    s = fb / fa;
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                }
                if (p > 0.0) {
                    q = -q;
                }
                if (2.0 * (p = Math.abs(p)) >= 3.0 * xm * q - Math.abs(tol1 * q) || p >= Math.abs(0.5 * e * q)) {
                    e = d = xm;
                } else {
                    e = d;
                    d = p / q;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol1 ? (b += d) : (xm < 0.0 ? (b -= tol1) : (b += tol1));
            fb = f.evaluate(b);
            if (fb * (fc / Math.abs(fc)) > 0.0) {
                c = a;
                fc = fa;
                d = e = b - a;
                continue;
            }
            a = b;
            b = c;
            c = a;
            fa = fb;
            fb = fc;
            fc = fa;
        }
        return b;
    }

    public static double bisection(double a, double b, MathFunction f, double tol) {
        if (b < a) {
            double ctemp = a;
            a = b;
            b = ctemp;
        }
        double xa = a;
        double xb = b;
        double yb = f.evaluate(b);
        double ya = f.evaluate(a);
        double x = 0.0;
        double y = 0.0;
        int MAXITER = 1200;
        boolean DEBUG = false;
        double myMIN_NORMAL = 2.25E-308;
        boolean fini = false;
        int i = 0;
        while (!fini) {
            x = (xa + xb) / 2.0;
            y = f.evaluate(x);
            if (Math.abs(y) <= 2.25E-308 || Math.abs(xb - xa) <= tol * Math.abs(x) || Math.abs(xb - xa) <= 0.0) {
                return x;
            }
            if (y * ya < 0.0) {
                xb = x;
            } else {
                xa = x;
            }
            if (++i <= 1200) continue;
            System.out.println("***** bisection:  SEARCH DOES NOT CONVERGE");
            fini = true;
        }
        return x;
    }
}

