/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command;

import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mgfboost.ui.command.AbstractCommand;
import fr.profi.mgfboost.ui.command.ICommand;
import fr.profi.mgfboost.ui.command.PCleanMgfCommand;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.command.ui.MergeMgfPanel;
import fr.profi.mgfboost.ui.model.MS2Collection;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.MGFProcessing;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeMgfCommand
extends AbstractCommand<CommandArguments.MgfMergerCommand> {
    private static final Logger logger = LoggerFactory.getLogger(PCleanMgfCommand.class);

    public MergeMgfCommand() {
        this.command = new CommandArguments.MgfMergerCommand();
    }

    @Override
    public MS2Collection execute(File ... files) throws Exception {
        ((CommandArguments.MgfMergerCommand)this.command).inputFileName1 = files[0].getAbsolutePath();
        ((CommandArguments.MgfMergerCommand)this.command).inputFileName2 = files[1].getAbsolutePath();
        logger.info("Execute command " + this.getCommandName() + " on " + Arrays.stream(files).map(f -> f.getName()).collect(Collectors.joining()));
        logger.info("Command args : " + ToStringBuilder.reflectionToString(this.command));
        MGFProcessing.mergeMgf((CommandArguments.MgfMergerCommand)((CommandArguments.MgfMergerCommand)this.command));
        return new MS2Collection(new File(((CommandArguments.MgfMergerCommand)this.command).outputFileName), MainPanel.FileType.MGF);
    }

    @Override
    protected AbstractCommandPanel<CommandArguments.MgfMergerCommand> getConfigurationPanel() {
        if (this.configurationPanel == null) {
            this.configurationPanel = new MergeMgfPanel().updatePanelFromCommand((CommandArguments.MgfMergerCommand)this.command);
        }
        return this.configurationPanel;
    }

    @Override
    public ICommand.ExecutionMode getExecutionMode() {
        return ICommand.ExecutionMode.PAIRS_OF_FILES;
    }

    @Override
    public AbstractCommandPanel<CommandArguments.MgfMergerCommand> getConfigurationPanel(List<MS2Collection> selectedCollections) {
        ((CommandArguments.MgfMergerCommand)this.command).inputFileName1 = selectedCollections.get(0).getFile().getAbsolutePath();
        ((CommandArguments.MgfMergerCommand)this.command).inputFileName2 = selectedCollections.get(1).getFile().getAbsolutePath();
        this.configurationPanel = new MergeMgfPanel().updatePanelFromCommand((CommandArguments.MgfMergerCommand)this.command);
        this.configurationPanel.setOutputRootFolder(selectedCollections.get(0).getFile().getParentFile());
        return this.configurationPanel;
    }
}

