/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.bitset;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import javolution.lang.MathLib;
import javolution.util.Index;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.internal.bitset.BitSetIteratorImpl;
import javolution.util.internal.set.SetView;
import javolution.util.service.BitSetService;

public class BitSetServiceImpl
extends SetView<Index>
implements BitSetService,
Serializable {
    private static final long serialVersionUID = 1536L;
    private static final long[] ALL_CLEARED = new long[0];
    private long[] bits;

    public BitSetServiceImpl() {
        super(null);
        this.bits = ALL_CLEARED;
    }

    public BitSetServiceImpl(long[] bits) {
        super(null);
        this.bits = bits;
    }

    @Override
    public boolean add(Index index) {
        return !this.getAndSet(index.intValue(), true);
    }

    @Override
    public void and(BitSetService that) {
        int i;
        long[] thatBits = that.toLongArray();
        int n = MathLib.min(this.bits.length, thatBits.length);
        for (i = 0; i < n; ++i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & thatBits[i];
        }
        for (i = n; i < this.bits.length; ++i) {
            this.bits[i] = 0L;
        }
    }

    @Override
    public void andNot(BitSetService that) {
        long[] thatBits = that.toLongArray();
        int n = MathLib.min(this.bits.length, thatBits.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & (thatBits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            sum += MathLib.bitCount(this.bits[i]);
        }
        return sum;
    }

    @Override
    public void clear() {
        this.bits = ALL_CLEARED;
    }

    @Override
    public void clear(int bitIndex) {
        int longIndex = bitIndex >> 6;
        if (longIndex >= this.bits.length) {
            return;
        }
        int n = longIndex;
        this.bits[n] = this.bits[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int i = fromIndex >>> 6;
        if (i >= this.bits.length) {
            return;
        }
        int j = toIndex >>> 6;
        if (i == j) {
            int n = i;
            this.bits[n] = this.bits[n] & ((1L << fromIndex) - 1L | -1L << toIndex);
            return;
        }
        int n = i;
        this.bits[n] = this.bits[n] & (1L << fromIndex) - 1L;
        if (j < this.bits.length) {
            int n2 = j;
            this.bits[n2] = this.bits[n2] & -1L << toIndex;
        }
        for (int k = i + 1; k < j && k < this.bits.length; ++k) {
            this.bits[k] = 0L;
        }
    }

    @Override
    public Equality<? super Index> comparator() {
        return Equalities.IDENTITY;
    }

    @Override
    public boolean contains(Object index) {
        return this.get(((Index)index).intValue());
    }

    @Override
    public void flip(int bitIndex) {
        int i = bitIndex >> 6;
        this.ensureCapacity(i + 1);
        int n = i;
        this.bits[n] = this.bits[n] ^ 1L << bitIndex;
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int i = fromIndex >>> 6;
        int j = toIndex >>> 6;
        this.ensureCapacity(j + 1);
        if (i == j) {
            int n = i;
            this.bits[n] = this.bits[n] ^ -1L << fromIndex & (1L << toIndex) - 1L;
            return;
        }
        int n = i;
        this.bits[n] = this.bits[n] ^ -1L << fromIndex;
        int n2 = j;
        this.bits[n2] = this.bits[n2] ^ (1L << toIndex) - 1L;
        int k = i + 1;
        while (k < j) {
            int n3 = k++;
            this.bits[n3] = this.bits[n3] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @Override
    public boolean get(int bitIndex) {
        int i = bitIndex >> 6;
        return i >= this.bits.length ? false : (this.bits[i] & 1L << bitIndex) != 0L;
    }

    @Override
    public BitSetServiceImpl get(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        BitSetServiceImpl bitSet = new BitSetServiceImpl();
        int length = MathLib.min(this.bits.length, (toIndex >>> 6) + 1);
        bitSet.bits = new long[length];
        System.arraycopy(this.bits, 0, bitSet.bits, 0, length);
        bitSet.clear(0, fromIndex);
        bitSet.clear(toIndex, length << 6);
        return bitSet;
    }

    @Override
    public boolean getAndSet(int bitIndex, boolean value) {
        boolean previous;
        int i = bitIndex >> 6;
        this.ensureCapacity(i + 1);
        boolean bl = previous = (this.bits[i] & 1L << bitIndex) != 0L;
        if (value) {
            int n = i;
            this.bits[n] = this.bits[n] | 1L << bitIndex;
        } else {
            int n = i;
            this.bits[n] = this.bits[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return previous;
    }

    @Override
    public boolean intersects(BitSetService that) {
        long[] thatBits = that.toLongArray();
        int i = MathLib.min(this.bits.length, thatBits.length);
        while (--i >= 0) {
            if ((this.bits[i] & thatBits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Index> iterator() {
        return new BitSetIteratorImpl(this, 0);
    }

    @Override
    public int length() {
        this.trim();
        if (this.bits.length == 0) {
            return 0;
        }
        return (this.bits.length << 6) - MathLib.numberOfLeadingZeros(this.bits[this.bits.length - 1]);
    }

    @Override
    public int nextClearBit(int fromIndex) {
        long mask = 1L << fromIndex;
        for (int offset = fromIndex >> 6; offset < this.bits.length; ++offset) {
            long h = this.bits[offset];
            do {
                if ((h & mask) == 0L) {
                    return fromIndex;
                }
                ++fromIndex;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
        }
        return fromIndex;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        long mask = 1L << fromIndex;
        for (int offset = fromIndex >> 6; offset < this.bits.length; ++offset) {
            long h = this.bits[offset];
            do {
                if ((h & mask) != 0L) {
                    return fromIndex;
                }
                ++fromIndex;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
        }
        return -1;
    }

    @Override
    public void or(BitSetService that) {
        long[] thatBits = that instanceof BitSetServiceImpl ? ((BitSetServiceImpl)that).bits : that.toLongArray();
        this.ensureCapacity(thatBits.length);
        int i = thatBits.length;
        while (--i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] | thatBits[i];
        }
    }

    @Override
    public int previousClearBit(int fromIndex) {
        long mask = 1L << fromIndex;
        for (int offset = fromIndex >> 6; offset >= 0; --offset) {
            long h = this.bits[offset];
            do {
                if ((h & mask) == 0L) {
                    return fromIndex;
                }
                --fromIndex;
            } while ((mask >>= 1) != 0L);
            mask = Long.MIN_VALUE;
        }
        return -1;
    }

    @Override
    public int previousSetBit(int fromIndex) {
        long mask = 1L << fromIndex;
        for (int offset = fromIndex >> 6; offset >= 0; --offset) {
            long h = this.bits[offset];
            do {
                if ((h & mask) != 0L) {
                    return fromIndex;
                }
                --fromIndex;
            } while ((mask >>= 1) != 0L);
            mask = Long.MIN_VALUE;
        }
        return -1;
    }

    @Override
    public boolean remove(Object index) {
        return this.getAndSet(((Index)index).intValue(), false);
    }

    @Override
    public void set(int bitIndex) {
        int i = bitIndex >> 6;
        this.ensureCapacity(i + 1);
        int n = i;
        this.bits[n] = this.bits[n] | 1L << bitIndex;
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        int i = fromIndex >>> 6;
        int j = toIndex >>> 6;
        this.ensureCapacity(j + 1);
        if (i == j) {
            int n = i;
            this.bits[n] = this.bits[n] | -1L << fromIndex & (1L << toIndex) - 1L;
            return;
        }
        int n = i;
        this.bits[n] = this.bits[n] | -1L << fromIndex;
        int n2 = j;
        this.bits[n2] = this.bits[n2] | (1L << toIndex) - 1L;
        for (int k = i + 1; k < j; ++k) {
            this.bits[k] = -1L;
        }
    }

    @Override
    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public int size() {
        return this.cardinality();
    }

    @Override
    public long[] toLongArray() {
        this.trim();
        return this.bits;
    }

    @Override
    public void xor(BitSetService that) {
        long[] thatBits = that instanceof BitSetServiceImpl ? ((BitSetServiceImpl)that).bits : that.toLongArray();
        this.ensureCapacity(thatBits.length);
        int i = thatBits.length;
        while (--i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ thatBits[i];
        }
    }

    private void ensureCapacity(int capacity) {
        if (this.bits.length < capacity) {
            this.bits = Arrays.copyOf(this.bits, MathLib.max(this.bits.length * 2, capacity));
        }
    }

    private void trim() {
        int n = this.bits.length;
        while (--n >= 0 && this.bits[n] == 0L) {
        }
        if (++n != this.bits.length) {
            this.bits = Arrays.copyOf(this.bits, n);
        }
    }
}

