/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javolution.util.function.Consumer;
import javolution.util.function.Equality;
import javolution.util.function.Function;
import javolution.util.internal.collection.MappedCollectionImpl;
import javolution.util.internal.map.EntryComparatorImpl;
import javolution.util.internal.set.MappedSetImpl;
import javolution.util.internal.set.SetView;
import javolution.util.service.CollectionService;
import javolution.util.service.MapService;
import javolution.util.service.SetService;

public abstract class MapView<K, V>
implements MapService<K, V> {
    private static final long serialVersionUID = 1536L;
    private MapService<K, V> target;

    public MapView(MapService<K, V> target) {
        this.target = target;
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<K, V>> it = this.iterator();
        while (it.hasNext()) {
            it.remove();
        }
    }

    @Override
    public MapView<K, V> clone() {
        try {
            MapView copy = (MapView)super.clone();
            if (this.target != null) {
                copy.target = this.target.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Should not happen since target is cloneable");
        }
    }

    @Override
    public abstract boolean containsKey(Object var1);

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public SetService<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map that = (Map)obj;
        return ((Object)this.entrySet()).equals(that.entrySet());
    }

    @Override
    public abstract V get(Object var1);

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public abstract Iterator<Map.Entry<K, V>> iterator();

    @Override
    public abstract Equality<? super K> keyComparator();

    @Override
    public SetService<K> keySet() {
        return new KeySet();
    }

    @Override
    public void perform(Consumer<MapService<K, V>> action, MapService<K, V> view) {
        if (this.target == null) {
            action.accept(view);
        } else {
            this.target.perform(action, view);
        }
    }

    @Override
    public abstract V put(K var1, V var2);

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            return this.put(key, value);
        }
        return this.get(key);
    }

    @Override
    public abstract V remove(Object var1);

    @Override
    public boolean remove(Object key, Object value) {
        if (this.containsKey(key) && this.get(key).equals(value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        if (this.containsKey(key)) {
            return this.put(key, value);
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.containsKey(key) && this.get(key).equals(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<Map.Entry<K, V>> it = this.iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    public MapService<K, V>[] split(int n, boolean threadsafe) {
        return new MapService[]{this};
    }

    protected MapService<K, V> target() {
        return this.target;
    }

    @Override
    public void update(Consumer<MapService<K, V>> action, MapService<K, V> view) {
        if (this.target == null) {
            action.accept(view);
        } else {
            this.target.update(action, view);
        }
    }

    @Override
    public abstract Equality<? super V> valueComparator();

    @Override
    public CollectionService<V> values() {
        return new Values();
    }

    protected class Values
    extends MappedCollectionImpl<Map.Entry<K, V>, V> {
        private static final long serialVersionUID = 1536L;

        public Values() {
            super(MapView.this.entrySet(), new Function<Map.Entry<K, V>, V>(){

                @Override
                public V apply(Map.Entry<K, V> e) {
                    return e.getValue();
                }
            });
        }

        @Override
        public Equality<? super V> comparator() {
            return MapView.this.valueComparator();
        }
    }

    protected class KeySet
    extends MappedSetImpl<Map.Entry<K, V>, K> {
        private static final long serialVersionUID = 1536L;

        public KeySet() {
            super(MapView.this.entrySet(), new EntryToKey());
        }

        @Override
        public boolean add(K key) {
            if (MapView.this.containsKey(key)) {
                return false;
            }
            MapView.this.put(key, null);
            return true;
        }

        @Override
        public Equality<? super K> comparator() {
            return MapView.this.keyComparator();
        }

        @Override
        public boolean contains(Object obj) {
            return MapView.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            if (!MapView.this.containsKey(obj)) {
                return false;
            }
            MapView.this.remove(obj);
            return true;
        }
    }

    class EntryToKey
    implements Function<Map.Entry<K, V>, K>,
    Serializable {
        private static final long serialVersionUID = 1536L;

        EntryToKey() {
        }

        @Override
        public K apply(Map.Entry<K, V> param) {
            return param.getKey();
        }
    }

    protected class EntrySet
    extends SetView<Map.Entry<K, V>> {
        private static final long serialVersionUID = 1536L;

        public EntrySet() {
            super(null);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            Object oldValue = MapView.this.put(entry.getKey(), entry.getValue());
            return !MapView.this.valueComparator().equal(entry.getValue(), oldValue);
        }

        @Override
        public Equality<? super Map.Entry<K, V>> comparator() {
            return new EntryComparatorImpl(MapView.this.keyComparator(), MapView.this.valueComparator());
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)obj;
                Object value = MapView.this.get(e.getKey());
                return MapView.this.valueComparator().equal(e.getValue(), value);
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return MapView.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return MapView.this.iterator();
        }

        @Override
        public void perform(final Consumer<CollectionService<Map.Entry<K, V>>> action, final CollectionService<Map.Entry<K, V>> view) {
            Consumer mapAction = new Consumer<MapService<K, V>>(){

                @Override
                public void accept(MapService<K, V> param) {
                    action.accept(view);
                }
            };
            MapView.this.perform(mapAction, MapView.this);
        }

        @Override
        public boolean remove(Object obj) {
            if (!this.contains(obj)) {
                return false;
            }
            if (obj instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)obj;
                MapView.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return MapView.this.size();
        }

        @Override
        public void update(final Consumer<CollectionService<Map.Entry<K, V>>> action, final CollectionService<Map.Entry<K, V>> view) {
            Consumer mapAction = new Consumer<MapService<K, V>>(){

                @Override
                public void accept(MapService<K, V> param) {
                    action.accept(view);
                }
            };
            MapView.this.update(mapAction, MapView.this);
        }
    }
}

