/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.api.progress;

import com.typesafe.scalalogging.Logger;
import fr.profi.api.progress.IProgressStepIdentity;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ProgressExecutionProfiling$ {
    public static ProgressExecutionProfiling$ MODULE$;
    private boolean _profileExecution;
    private HashMap<IProgressStepIdentity, ArrayBuffer<Object>> _executionTimesByStepIdentity;

    static {
        new ProgressExecutionProfiling$();
    }

    private boolean _profileExecution() {
        return this._profileExecution;
    }

    private void _profileExecution_$eq(boolean x$1) {
        this._profileExecution = x$1;
    }

    private HashMap<IProgressStepIdentity, ArrayBuffer<Object>> _executionTimesByStepIdentity() {
        return this._executionTimesByStepIdentity;
    }

    private void _executionTimesByStepIdentity_$eq(HashMap<IProgressStepIdentity, ArrayBuffer<Object>> x$1) {
        this._executionTimesByStepIdentity = x$1;
    }

    public synchronized void enable() {
        this._profileExecution_$eq(true);
    }

    public synchronized void disable() {
        this._profileExecution_$eq(false);
    }

    public boolean isEnabled() {
        return this._profileExecution();
    }

    public synchronized ArrayBuffer<Object> addExecutionTime(IProgressStepIdentity stepIdentity, long execTime) {
        return ((ArrayBuffer)this._executionTimesByStepIdentity().getOrElseUpdate((Object)stepIdentity, (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer())).$plus$eq((Object)BoxesRunTime.boxToLong((long)execTime));
    }

    public Map<IProgressStepIdentity, Tuple2<Object, Object>> getExecutionStatistics() {
        return ((TraversableOnce)this._executionTimesByStepIdentity().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProgressExecutionProfiling$.$anonfun$getExecutionStatistics$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            IProgressStepIdentity stepIdentity = (IProgressStepIdentity)tuple2._1();
            ArrayBuffer execTimes = (ArrayBuffer)tuple2._2();
            long execTimeSum = BoxesRunTime.unboxToLong((Object)execTimes.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long execTimeAvg = execTimeSum / (long)execTimes.length();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)stepIdentity), (Object)new Tuple2.mcJJ.sp(execTimeSum, execTimeAvg));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void logExecutionStatistics(Logger logger) {
        Map<IProgressStepIdentity, Tuple2<Object, Object>> execStats = this.getExecutionStatistics();
        List sortedStepIdentities = (List)execStats.keys().toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.stepName(), (Ordering)Ordering.String$.MODULE$);
        sortedStepIdentities.foreach((Function1 & Serializable & scala.Serializable)stepIdentity -> {
            ProgressExecutionProfiling$.$anonfun$logExecutionStatistics$2(execStats, logger, stepIdentity);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getExecutionStatistics$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$logExecutionStatistics$2(Map execStats$1, Logger logger$1, IProgressStepIdentity stepIdentity) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        Tuple2 tuple2 = (Tuple2)execStats$1.apply((Object)stepIdentity);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long totalExcTime = tuple2._1$mcJ$sp();
        long avgExecTime = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(totalExcTime, avgExecTime);
        Tuple2.mcJJ.sp sp3 = sp2;
        long totalExcTime2 = sp3._1$mcJ$sp();
        long avgExecTime2 = sp3._2$mcJ$sp();
        if (logger$1.underlying().isDebugEnabled()) {
            logger$1.underlying().debug("execution statistics of step {} ({}): ", new Object[]{stepIdentity.stepName(), stepIdentity.stepDescription()});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (logger$1.underlying().isDebugEnabled()) {
            logger$1.underlying().debug("- total exec time = {} ms", new Object[]{BoxesRunTime.boxToLong((long)totalExcTime2)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (logger$1.underlying().isDebugEnabled()) {
            logger$1.underlying().debug("- average exec time = {} ms", new Object[]{BoxesRunTime.boxToLong((long)avgExecTime2)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private ProgressExecutionProfiling$() {
        MODULE$ = this;
        this._profileExecution = false;
        this._executionTimesByStepIdentity = new HashMap();
    }
}

