/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.container;

import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockContainerMulti;
import fr.proline.studio.dock.container.DockContainerSplit;
import fr.proline.studio.dock.container.DockContainerTab;
import fr.proline.studio.dock.container.DockMaximizeInterface;
import fr.proline.studio.dock.container.DockReplaceInterface;
import fr.proline.studio.dock.dragdrop.OverArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public class DocContainerMinimizeZone
extends DockContainerMulti
implements DockReplaceInterface {
    private DockMinimizePanel m_minimizePanel = new DockMinimizePanel(this);
    private DockContainerMulti m_dockContainerMulti;
    private int m_previousSplitLocation = -1;

    public DocContainerMinimizeZone() {
        JPanel containerPanel = new JPanel(new BorderLayout());
        containerPanel.add((Component)this.m_minimizePanel, "West");
        this.m_component = containerPanel;
    }

    @Override
    public void getTopPanels(HashSet<AbstractTopPanel> set) {
        this.m_dockContainerMulti.getTopPanels(set);
        this.m_minimizePanel.getTopPanels(set);
    }

    @Override
    public DockContainer search(String windowKey) {
        DockContainer containerSearched = this.m_dockContainerMulti.search(windowKey);
        if (containerSearched != null) {
            return containerSearched;
        }
        return this.m_minimizePanel.search(windowKey);
    }

    @Override
    public DockContainer searchZoneArea(String zoneArea) {
        DockContainer containerSearched = this.m_dockContainerMulti.searchZoneArea(zoneArea);
        if (containerSearched != null) {
            return containerSearched;
        }
        return this.m_minimizePanel.searchZoneArea(zoneArea);
    }

    @Override
    public void findAllDockComponents(ArrayList<DockComponent> components) {
        this.m_dockContainerMulti.findAllDockComponents(components);
        this.m_minimizePanel.findAllDockComponents(components);
    }

    public void set(DockContainerMulti containerMulti) {
        this.m_dockContainerMulti = containerMulti;
        containerMulti.setParent(this);
        ((JPanel)this.m_component).add((Component)containerMulti.getComponent(), "Center");
    }

    @Override
    public void minimize(DockContainer container) {
        this.m_minimizePanel.add(container);
        if (this.m_dockContainerMulti.isEmpty()) {
            this.m_dockContainerMulti.getComponent().setVisible(false);
            if (this.getParent() instanceof DockContainerSplit) {
                this.m_previousSplitLocation = ((JSplitPane)((DockContainerSplit)this.getParent()).getComponent()).getDividerLocation();
                ((JSplitPane)((DockContainerSplit)this.getParent()).getComponent()).resetToPreferredSizes();
            }
        }
    }

    public void putBack(DockContainer container) {
        DockContainerTab tab;
        if (this.m_dockContainerMulti.isEmpty()) {
            this.m_dockContainerMulti.getComponent().setVisible(true);
        }
        if ((tab = this.searchTab(container.getLastParentId())) == null) {
            tab = this.searchTab(-1);
        }
        tab.add((DockComponent)container);
        if (this.getParent() instanceof DockContainerSplit) {
            ((JSplitPane)((DockContainerSplit)this.getParent()).getComponent()).setDividerLocation(this.m_previousSplitLocation);
        }
    }

    @Override
    public void toFront(DockContainer child) {
        this.m_minimizePanel.maximize(child);
    }

    @Override
    public void check() {
    }

    @Override
    public void remove(DockContainer container) {
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public DockContainerTab searchTab(int idContainer) {
        return this.m_dockContainerMulti.searchTab(idContainer);
    }

    @Override
    public OverArea getOverArea(Point pointOnScreen) {
        if (!this.m_dockContainerMulti.getComponent().isVisible()) {
            return null;
        }
        return this.m_dockContainerMulti.getOverArea(pointOnScreen);
    }

    @Override
    public void replace(DockContainerMulti previous, DockContainerMulti next) {
        if (this.m_dockContainerMulti == previous) {
            this.m_component.remove(previous.getComponent());
            ((JPanel)this.m_component).add((Component)next.getComponent(), "Center");
            this.m_dockContainerMulti = next;
            next.setParent(this);
            this.m_component.repaint();
        }
    }

    public class DockMinimizePanel
    extends JPanel {
        private DocContainerMinimizeZone m_containerMinimizeZone;
        private HashMap<DockContainer, MinimizedLabel> m_componentMap = new HashMap();

        public DockMinimizePanel(DocContainerMinimizeZone containerMinimizeZone) {
            this.m_containerMinimizeZone = containerMinimizeZone;
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(Color.white);
            this.setVisible(false);
        }

        public void getTopPanels(HashSet<AbstractTopPanel> set) {
            for (DockContainer c : this.m_componentMap.keySet()) {
                c.getTopPanels(set);
            }
        }

        public DockContainer search(String windowKey) {
            for (DockContainer c : this.m_componentMap.keySet()) {
                DockContainer containerSearched = c.search(windowKey);
                if (containerSearched == null) continue;
                return containerSearched;
            }
            return null;
        }

        public DockContainer searchZoneArea(String zoneArea) {
            for (DockContainer c : this.m_componentMap.keySet()) {
                DockContainer containerSearched = c.search(zoneArea);
                if (containerSearched == null) continue;
                return containerSearched;
            }
            return null;
        }

        public void findAllDockComponents(ArrayList<DockComponent> components) {
            for (DockContainer c : this.m_componentMap.keySet()) {
                c.findAllDockComponents(components);
            }
        }

        public void add(DockContainer component) {
            MinimizedLabel l = new MinimizedLabel(this, component);
            this.add(l);
            this.m_componentMap.put(component, l);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.revalidate();
            this.repaint();
        }

        public void maximize(DockContainer component) {
            JComponent l = this.m_componentMap.remove(component);
            this.remove(l);
            this.m_containerMinimizeZone.putBack(component);
            this.revalidate();
            this.repaint();
        }
    }

    public class MinimizedLabel
    extends JPanel
    implements MouseListener,
    DockMaximizeInterface {
        private static final int PAD = 2;
        private DockMinimizePanel m_parentPanel;
        private DockContainer m_component;
        private Font m_font = UIManager.getDefaults().getFont("Label.font");
        private Dimension m_preferredSize = null;

        public MinimizedLabel(DockMinimizePanel parentPanel, DockContainer component) {
            this.m_parentPanel = parentPanel;
            this.m_component = component;
            ((DockComponent)component).setMaximizeInterface(this);
            this.addMouseListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.m_preferredSize == null) {
                Icon icon = ((DockComponent)this.m_component).getIcon();
                String title = ((DockComponent)this.m_component).getTitle();
                FontMetrics fm = this.m_component.getComponent().getFontMetrics(this.m_font);
                int stringWidth = fm.stringWidth(title);
                int height = 6 + (icon != null ? icon.getIconWidth() : 0) + stringWidth;
                int width = Math.max(20, (icon != null ? icon.getIconHeight() : 0) + 4);
                this.m_preferredSize = new Dimension(width, height);
            }
            return this.m_preferredSize;
        }

        @Override
        public void maximize() {
            ((DockComponent)this.m_component).setMaximizeInterface(null);
            this.m_parentPanel.maximize(this.m_component);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            String title;
            Graphics2D g2d = (Graphics2D)g;
            Font oldFont = g2d.getFont();
            g2d.setFont(this.m_font);
            FontMetrics fm = g2d.getFontMetrics();
            AffineTransform previousTransform = g2d.getTransform();
            g2d.rotate(-1.5707963267948966);
            g2d.translate(-this.getHeight(), 0);
            Icon icon = ((DockComponent)this.m_component).getIcon();
            if (icon != null) {
                icon.paintIcon(this, g2d, 2, (this.getWidth() - icon.getIconHeight()) / 2);
            }
            if ((title = ((DockComponent)this.m_component).getTitle()) != null) {
                int textX = 4 + (icon != null ? icon.getIconWidth() : 0);
                int textY = 2 + fm.getAscent();
                g2d.setColor(Color.black);
                g2d.drawString(title, textX, textY);
            }
            g2d.setFont(oldFont);
            g2d.setTransform(previousTransform);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.maximize();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

