/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.export.CheckboxTabPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class DnDTabbedPane
extends JTabbedPane {
    private static final int LINEWIDTH = 3;
    private static final String NAME = "test";
    private final GhostGlassPane m_glassPane = new GhostGlassPane();
    private final Rectangle2D m_lineRect = new Rectangle2D.Double();
    private static final Color LINE_COLOR = new Color(0, 100, 255);
    private final DnDTabbedPane m_tabbedPane = this;
    protected int m_dragTabIndex = -1;
    private boolean hasGhost = true;

    public DnDTabbedPane(int parameter) {
        super(parameter);
        final DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dragEnter(DragSourceDragEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragExit(DragSourceEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                DnDTabbedPane.this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DnDTabbedPane.this.m_glassPane.setPoint(new Point(-1000, -1000));
                DnDTabbedPane.this.m_glassPane.repaint();
            }

            @Override
            public void dragOver(DragSourceDragEvent e) {
                Point tabPt = e.getLocation();
                SwingUtilities.convertPointFromScreen(tabPt, DnDTabbedPane.this);
                Point glassPt = e.getLocation();
                SwingUtilities.convertPointFromScreen(glassPt, DnDTabbedPane.this.m_glassPane);
                int targetIdx = DnDTabbedPane.this.getTargetTabIndex(glassPt);
                if (DnDTabbedPane.this.getTabAreaBound().contains(tabPt) && targetIdx >= 0 && targetIdx != DnDTabbedPane.this.m_dragTabIndex && targetIdx != DnDTabbedPane.this.m_dragTabIndex + 1) {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                } else {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent e) {
                DnDTabbedPane.this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DnDTabbedPane.this.m_dragTabIndex = -1;
                if (DnDTabbedPane.this.hasGhost()) {
                    DnDTabbedPane.this.m_glassPane.setVisible(false);
                    DnDTabbedPane.this.m_glassPane.setImage(null);
                }
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent e) {
            }
        };
        final Transferable t = new Transferable(){
            private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "test");

            @Override
            public Object getTransferData(DataFlavor flavor) {
                return DnDTabbedPane.this;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] f = new DataFlavor[]{this.FLAVOR};
                return f;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.getHumanPresentableName().equals(DnDTabbedPane.NAME);
            }
        };
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent e) {
                Point tabPt = e.getDragOrigin();
                DnDTabbedPane.this.m_dragTabIndex = DnDTabbedPane.this.indexAtLocation(tabPt.x, tabPt.y);
                if (DnDTabbedPane.this.m_dragTabIndex < 0) {
                    return;
                }
                DnDTabbedPane.this.initGlassPane(e.getComponent(), e.getDragOrigin());
                try {
                    e.startDrag(DragSource.DefaultMoveDrop, t, dsl);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    // empty catch block
                }
            }
        };
        new DropTarget(this.m_glassPane, 3, new CDropTargetListener(), true);
        new DragSource().createDefaultDragGestureRecognizer(this, 3, dgl);
    }

    public void setPaintGhost(boolean flag) {
        this.hasGhost = flag;
    }

    public boolean hasGhost() {
        return this.hasGhost;
    }

    private int getTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.m_glassPane, glassPt, this);
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle r = this.getBoundsAt(i);
            if (!r.contains(tabPt)) continue;
            r.translate(r.width / 2, 0);
            if (r.contains(tabPt)) {
                return i + 1;
            }
            return i;
        }
        Rectangle r = this.getBoundsAt(this.getTabCount() - 1);
        r.translate(r.width, 0);
        return r.contains(tabPt) ? this.getTabCount() : -1;
    }

    private void convertTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        Component cmp = this.getComponentAt(prev);
        CheckboxTabPanel tabComponent = (CheckboxTabPanel)this.getTabComponentAt(prev);
        String str = tabComponent.getText();
        String idSheet = tabComponent.getSheetId();
        boolean isSelected = tabComponent.isSelected();
        if (next == this.getTabCount()) {
            this.remove(prev);
            this.addTab(null, cmp);
            CheckboxTabPanel closableTabPanel = new CheckboxTabPanel(this, str, idSheet);
            closableTabPanel.setSelected(isSelected);
            this.setTabComponentAt(this.getTabCount() - 1, closableTabPanel);
            this.setSelectedIndex(this.getTabCount() - 1);
        } else if (prev > next) {
            this.remove(prev);
            CheckboxTabPanel closableTabPanel = new CheckboxTabPanel(this, str, idSheet);
            closableTabPanel.setSelected(isSelected);
            this.insertTab(null, null, cmp, null, next);
            this.setTabComponentAt(next, closableTabPanel);
            this.setSelectedIndex(next);
        } else {
            this.remove(prev);
            this.insertTab(null, null, cmp, null, next - 1);
            CheckboxTabPanel closableTabPanel = new CheckboxTabPanel(this, str, idSheet);
            closableTabPanel.setSelected(isSelected);
            this.setTabComponentAt(next - 1, closableTabPanel);
            this.setSelectedIndex(next - 1);
        }
    }

    private void initTargetLeftRightLine(int next) {
        if (next < 0 || this.m_dragTabIndex == next || next - this.m_dragTabIndex == 1) {
            this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == this.getTabCount()) {
            Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
            this.m_lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
        } else if (next == 0) {
            Rectangle rect = this.getBoundsAt(0);
            this.m_lineRect.setRect(-1.0, rect.y, 3.0, rect.height);
        } else {
            Rectangle rect = this.getBoundsAt(next - 1);
            this.m_lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
        }
    }

    private void initTargetTopBottomLine(int next) {
        if (next < 0 || this.m_dragTabIndex == next || next - this.m_dragTabIndex == 1) {
            this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == this.getTabCount()) {
            Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
            this.m_lineRect.setRect(rect.x, rect.y + rect.height - 1, rect.width, 3.0);
        } else if (next == 0) {
            Rectangle rect = this.getBoundsAt(0);
            this.m_lineRect.setRect(rect.x, -1.0, rect.width, 3.0);
        } else {
            Rectangle rect = this.getBoundsAt(next - 1);
            this.m_lineRect.setRect(rect.x, rect.y + rect.height - 1, rect.width, 3.0);
        }
    }

    private void initGlassPane(Component c, Point tabPt) {
        this.getRootPane().setGlassPane(this.m_glassPane);
        if (this.hasGhost()) {
            Rectangle rect = this.getBoundsAt(this.m_dragTabIndex);
            BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
            Graphics g = image.getGraphics();
            c.paint(g);
            try {
                image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_glassPane.setImage(image);
        }
        Point glassPt = SwingUtilities.convertPoint(c, tabPt, this.m_glassPane);
        this.m_glassPane.setPoint(glassPt);
        this.m_glassPane.setVisible(true);
    }

    private Rectangle getTabAreaBound() {
        Rectangle lastTab = this.getUI().getTabBounds(this, this.getTabCount() - 1);
        return new Rectangle(0, 0, this.getWidth(), lastTab.y + lastTab.height);
    }

    private class GhostGlassPane
    extends JPanel {
        private final AlphaComposite composite;
        private Point location = new Point(0, 0);
        private BufferedImage draggingGhost = null;

        public GhostGlassPane() {
            this.setOpaque(false);
            this.composite = AlphaComposite.getInstance(3, 0.5f);
        }

        public void setImage(BufferedImage draggingGhost) {
            this.draggingGhost = draggingGhost;
        }

        public void setPoint(Point location) {
            this.location = location;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.draggingGhost == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(this.composite);
            double xx = this.location.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
            double yy = this.location.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
            g2.drawImage((Image)this.draggingGhost, (int)xx, (int)yy, null);
            if (DnDTabbedPane.this.m_dragTabIndex >= 0) {
                Rectangle2D.Double r = new Rectangle2D.Double(DnDTabbedPane.this.m_lineRect.getX() + (double)this.getX() - (double)DnDTabbedPane.this.m_tabbedPane.getX(), DnDTabbedPane.this.m_lineRect.getY() + (double)this.getY() - (double)DnDTabbedPane.this.m_tabbedPane.getY(), DnDTabbedPane.this.m_lineRect.getWidth(), DnDTabbedPane.this.m_lineRect.getHeight());
                g2.setPaint(LINE_COLOR);
                g2.fill(r);
            }
        }
    }

    class CDropTargetListener
    implements DropTargetListener {
        CDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (DnDTabbedPane.this.getTabPlacement() == 1 || DnDTabbedPane.this.getTabPlacement() == 3) {
                DnDTabbedPane.this.initTargetLeftRightLine(DnDTabbedPane.this.getTargetTabIndex(e.getLocation()));
            } else {
                DnDTabbedPane.this.initTargetTopBottomLine(DnDTabbedPane.this.getTargetTabIndex(e.getLocation()));
            }
            DnDTabbedPane.this.repaint();
            if (DnDTabbedPane.this.hasGhost()) {
                DnDTabbedPane.this.m_glassPane.setPoint(e.getLocation());
                DnDTabbedPane.this.m_glassPane.repaint();
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (this.isDropAcceptable(e)) {
                DnDTabbedPane.this.convertTab(DnDTabbedPane.this.m_dragTabIndex, DnDTabbedPane.this.getTargetTabIndex(e.getLocation()));
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
            DnDTabbedPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = e.getCurrentDataFlavors();
            return t.isDataFlavorSupported(f[0]) && DnDTabbedPane.this.m_dragTabIndex >= 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = t.getTransferDataFlavors();
            return t.isDataFlavorSupported(f[0]) && DnDTabbedPane.this.m_dragTabIndex >= 0;
        }
    }
}

