/*
 * Decompiled with CFR 0.152.
 */
package Preprocessing;

import Preprocessing.Config;
import Preprocessing.JPeak;
import Preprocessing.PeakIntensityComparator;
import Preprocessing.PeakMZComparator;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class JSpectrum {
    private static final PeakMZComparator pComparator = new PeakMZComparator();
    private static final PeakIntensityComparator peakIntensityComparator = new PeakIntensityComparator();
    private String spectrumTitle;
    private String scanNumber;
    private double rt;
    private int charge;
    private double parentMassToCharge;
    private double intensity;
    private double parentMass;
    private ArrayList<JPeak> peaks = new ArrayList();
    private ArrayList<JPeak> rawPeaks = new ArrayList();
    private ArrayList<JPeak> reporterPeaks = new ArrayList();
    public static HashMap<Double, String> ImmoniumIons = new HashMap();
    private double totalIonCurrent;

    public static void setImmoniumIons() {
        ImmoniumIons.put(30.03, "G");
        ImmoniumIons.put(44.05, "A");
        ImmoniumIons.put(60.04, "S");
        ImmoniumIons.put(70.07, "P/R");
        ImmoniumIons.put(72.08, "V");
        ImmoniumIons.put(74.06, "T");
        ImmoniumIons.put(86.1, "I/L");
        ImmoniumIons.put(87.06, "N");
        ImmoniumIons.put(70.03, "N/D");
        ImmoniumIons.put(88.04, "D");
        ImmoniumIons.put(129.1, "Q");
        ImmoniumIons.put(101.07, "Q");
        ImmoniumIons.put(84.04, "Q/E");
        ImmoniumIons.put(56.05, "Q/K");
        ImmoniumIons.put(129.11, "K/R");
        ImmoniumIons.put(101.11, "K");
        ImmoniumIons.put(84.08, "K");
        ImmoniumIons.put(102.05, "E");
        ImmoniumIons.put(104.06, "M");
        ImmoniumIons.put(120.08, "F");
        ImmoniumIons.put(110.07, "H");
        ImmoniumIons.put(115.09, "R");
        ImmoniumIons.put(112.09, "R");
        ImmoniumIons.put(87.09, "R");
        ImmoniumIons.put(60.06, "R");
        ImmoniumIons.put(133.04, "C");
        ImmoniumIons.put(136.08, "Y");
        ImmoniumIons.put(159.09, "W");
        ImmoniumIons.put(132.08, "W");
        ImmoniumIons.put(130.07, "W");
    }

    public String getSpectrumTitle() {
        return this.spectrumTitle;
    }

    public void setSpectrumTitle(String spectrumTitle) {
        this.spectrumTitle = spectrumTitle;
    }

    public String getScanNumber() {
        return this.scanNumber;
    }

    public void setScanNumber(String scanNumber) {
        this.scanNumber = scanNumber;
    }

    public double getRt() {
        return this.rt;
    }

    public void setRt(double rt) {
        this.rt = rt;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public double getParentMassToCharge() {
        return this.parentMassToCharge;
    }

    public void setParentMassToCharge(double parentMassToCharge) {
        this.parentMassToCharge = parentMassToCharge;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setIntensity(double intensity) {
        this.intensity = intensity;
    }

    public void addPeak(JPeak peak) {
        this.peaks.add(peak);
    }

    public void setPeaks(ArrayList<JPeak> peaks) {
        this.peaks = peaks;
    }

    public double getParentMass() {
        return this.parentMass;
    }

    public void setParentMass(double parentMass) {
        this.parentMass = parentMass;
    }

    public ArrayList<JPeak> getPeaks() {
        if (this.peaks.size() == 0) {
            this.resetPeaks();
        }
        return this.peaks;
    }

    public void removePeak(int index) {
        this.peaks.remove(index);
    }

    public void addRawPeak(JPeak peak) {
        this.rawPeaks.add(peak);
    }

    public ArrayList<JPeak> getRawPeaks() {
        return this.rawPeaks;
    }

    public void removeRawPeak(int index) {
        this.rawPeaks.remove(index);
    }

    public void resetPeaks() {
        this.peaks = new ArrayList();
        for (JPeak jPeak : this.rawPeaks) {
            JPeak tmpJPeak = jPeak.clone();
            this.peaks.add(tmpJPeak);
        }
    }

    public void sortPeaksByMZ() {
        Collections.sort(this.peaks, pComparator);
    }

    public void sortPeaksByIntensity() {
        Collections.sort(this.peaks, peakIntensityComparator);
    }

    public void printPeaks() {
        this.sortPeaksByMZ();
        int i = 1;
        for (JPeak peak : this.peaks) {
            System.out.println(i + "\t" + peak.getMz() + "\t" + peak.getIntensity());
        }
    }

    public double getTotalIntensity() {
        double sumInt = 0.0;
        for (JPeak jPeak : this.peaks) {
            sumInt += jPeak.getIntensity();
        }
        return sumInt;
    }

    public JPeak getMaxIntensityFragmentIonPeak() {
        this.sortPeaksByIntensity();
        return this.peaks.get(this.peaks.size() - 1);
    }

    public JPeak getMaxMzFragmentIonPeak() {
        this.sortPeaksByMZ();
        return this.peaks.get(this.peaks.size() - 1);
    }

    public JPeak getMinMzFragmentPeak() {
        this.sortPeaksByMZ();
        return this.peaks.get(0);
    }

    public void normalization() {
        double maxInt = this.getMaxIntensityFragmentIonPeak().getIntensity();
        for (JPeak jPeak : this.peaks) {
            jPeak.setIntensity(jPeak.getIntensity() / maxInt);
        }
    }

    public void formatMZdeciPoint() {
        for (int i = 0; i < this.peaks.size(); ++i) {
            this.peaks.get(i).setMz(Double.valueOf(String.format("%.4f", this.peaks.get(i).getMz())));
        }
    }

    public int removeImmoniumIons() {
        Iterator<JPeak> pListIterator = this.getPeaks().iterator();
        int rpn = 0;
        block0: while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (jPeak.getMz() >= 170.0) continue;
            for (Double mion : ImmoniumIons.keySet()) {
                if (!(Math.abs(jPeak.getMz() - mion) <= Config.ms2tol)) continue;
                ++rpn;
                pListIterator.remove();
                continue block0;
            }
        }
        return rpn;
    }

    public int removeLowIntensityPeak(double intensityLimit) {
        int rpn = 0;
        double maxInt = this.getMaxIntensityFragmentIonPeak().getIntensity();
        double limitInt = 1.0 * intensityLimit * maxInt;
        Iterator<JPeak> pListIterator = this.getPeaks().iterator();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (!(jPeak.getIntensity() < limitInt)) continue;
            ++rpn;
            pListIterator.remove();
        }
        return rpn;
    }

    public int keepTopNPeaksInRegions(int n, double regionMass) throws InterruptedException {
        int rpn = 0;
        HashMap<Double, Integer> mz2region = new HashMap<Double, Integer>();
        HashMap<Integer, Integer> regionP = new HashMap<Integer, Integer>();
        for (JPeak jPeak : this.getPeaks()) {
            int rg = (int)Math.floor(1.0 * jPeak.getMz() / regionMass) - 1;
            if (rg < 0) {
                System.out.println("Preprocessing.JSpectrum.java line253: rg is smaller than 0!");
                continue;
            }
            mz2region.put(jPeak.getMz(), rg);
            regionP.put(rg, 0);
        }
        this.sortPeaksByIntensity();
        Collections.reverse(this.getPeaks());
        Iterator<JPeak> pListIterator = this.getPeaks().iterator();
        ArrayList<JPeak> jPeaksToRemove = new ArrayList<JPeak>();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            double ionMz = jPeak.getMz();
            if (!mz2region.containsKey(ionMz)) {
                pListIterator.remove();
                ++rpn;
                continue;
            }
            int rg = (Integer)mz2region.get(ionMz);
            Integer value = (Integer)regionP.get(rg) + 1;
            regionP.put(rg, value);
            if ((Integer)regionP.get(rg) <= n) continue;
            jPeaksToRemove.add(jPeak);
            ++rpn;
        }
        this.getPeaks().removeAll(jPeaksToRemove);
        return rpn;
    }

    public void restoreReporterPeaks() {
        if (!this.reporterPeaks.isEmpty()) {
            this.getPeaks().addAll(this.reporterPeaks);
            this.sortPeaksByMZ();
        }
    }

    public void detectReporterPeaks(List<Double> reporters, double ms2tol) {
        JPeak jPeak;
        double mz;
        double maxReporterMz = (Double)reporters.stream().max(Double::compareTo).get();
        this.sortPeaksByMZ();
        Iterator<JPeak> iterator = this.getPeaks().iterator();
        block0: while (iterator.hasNext() && !((mz = (jPeak = iterator.next()).getMz()) > maxReporterMz + ms2tol)) {
            for (Double mass : reporters) {
                if (!(Config.delta(mass, mz) <= ms2tol)) continue;
                this.reporterPeaks.add(jPeak);
                continue block0;
            }
        }
    }

    public StringBuilder toMgf() {
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN IONS\n");
        sb.append("TITLE=" + this.getSpectrumTitle() + "\n");
        sb.append("PEPMASS=" + this.getParentMassToCharge() + " " + this.getIntensity() + "\n");
        sb.append("CHARGE=" + this.getCharge() + "+\n");
        if (this.getRt() > 0.0) {
            sb.append("RTINSECONDS=" + this.getRt() + "\n");
        }
        for (JPeak jPeak : this.getPeaks()) {
            sb.append(jPeak.getMz() + " " + jPeak.getIntensity() + "\n");
        }
        sb.append("END IONS\n");
        return sb;
    }

    public void module1(String method, Boolean removeRep, Boolean labelFilter, Boolean byFreeWinLow, Boolean byFreeWinHigh) {
        try {
            IsobaricTag isobaricTag = IsobaricTag.valueOf(method.toUpperCase());
            if (labelFilter.booleanValue()) {
                this.doFilterLabelAssociatedIons(isobaricTag.reporterIons, isobaricTag.tagMass, removeRep);
            }
            if (byFreeWinLow.booleanValue() || byFreeWinHigh.booleanValue()) {
                this.doFilterBYfreeWins(byFreeWinLow, byFreeWinHigh, isobaricTag.tagMass);
            }
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Please check out the proper setting for labeling method.");
        }
    }

    private void doFilterBYfreeWins(Boolean low, Boolean high, Double isobaric_tag) {
        double h = ElementaryIon.proton.getTheoreticMass();
        double gly = 57.021464;
        double arg = 156.101111;
        double lys = 128.094963;
        double h2o = h * 2.0 + 15.99491463;
        double min_b = isobaric_tag + gly + h;
        double max_b = this.getParentMass() - arg - h2o;
        double min_y = arg + h2o + h;
        double max_y = this.getParentMass() - gly - isobaric_tag - h2o;
        double lowWin = Math.min(min_b, min_y);
        double highWin = Math.max(max_b, max_y);
        ArrayList<JPeak> uninformative = new ArrayList<JPeak>();
        for (JPeak jPeak : this.getPeaks()) {
            double mz = jPeak.getMz();
            if (low.booleanValue() && mz < lowWin - Config.ms2tol) {
                uninformative.add(jPeak);
            }
            if (!high.booleanValue() || !(mz > highWin + Config.ms2tol)) continue;
            uninformative.add(jPeak);
        }
        this.getPeaks().removeAll(uninformative);
    }

    private void doFilterLabelAssociatedIonsBak(ArrayList<Double> reporters, double isobaric_tag, Boolean removeReporters) {
        ArrayList<JPeak> uninformative = new ArrayList<JPeak>();
        double h = ElementaryIon.proton.getTheoreticMass();
        double labelH = isobaric_tag + h;
        double labelH2 = isobaric_tag + h * 2.0;
        double o = 15.994915;
        double c = 12.0;
        double precusorMinuslabel = this.getParentMass() - isobaric_tag;
        block0: for (JPeak jPeak : this.getPeaks()) {
            double mz = jPeak.getMz();
            if (Config.delta(labelH, mz) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            if (Config.delta(labelH2, mz) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            if (Config.delta(precusorMinuslabel, mz) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            for (Double mass : reporters) {
                if (removeReporters.booleanValue() && Config.delta(mass, mz) <= Config.ms2tol) {
                    uninformative.add(jPeak);
                    continue block0;
                }
                double repCOH = mass + c + o + h;
                double precusorMinusRepCOH = this.getParentMass() - repCOH;
                if (Config.delta(repCOH, mz) <= Config.ms2tol) {
                    uninformative.add(jPeak);
                    continue block0;
                }
                if (!(Config.delta(precusorMinusRepCOH, mz) <= Config.ms2tol)) continue;
                uninformative.add(jPeak);
                continue block0;
            }
        }
        this.getPeaks().removeAll(uninformative);
    }

    private void doFilterLabelAssociatedIons(List<Double> reporters, double isobaric_tag, Boolean removeReporters) {
        ArrayList<JPeak> uninformative = new ArrayList<JPeak>();
        double h = 1.007825035;
        double labelH = isobaric_tag + h;
        double labelH2 = isobaric_tag + h * 2.0;
        double o = 15.994915;
        double c = 12.0;
        double precusorMinuslabel = this.getParentMass() - isobaric_tag;
        double preMZ = this.getParentMassToCharge();
        block0: for (JPeak jPeak : this.getPeaks()) {
            double mz = jPeak.getMz();
            if (mz <= preMZ + 0.5 && mz >= preMZ - 0.5) {
                uninformative.add(jPeak);
                continue;
            }
            if (Config.delta(mz, labelH) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            if (Config.delta(mz, labelH2) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            if (Config.delta(mz, precusorMinuslabel) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            for (Double mass : reporters) {
                if (Config.delta(mass, mz) <= Config.ms2tol) {
                    uninformative.add(jPeak);
                    continue block0;
                }
                double repCOH = mass + c + o + h;
                double precusorMinusRepCOH = this.getParentMass() - repCOH;
                if (Config.delta(repCOH, mz) <= Config.ms2tol) {
                    uninformative.add(jPeak);
                    continue block0;
                }
                if (!(Config.delta(precusorMinusRepCOH, mz) <= Config.ms2tol)) continue;
                uninformative.add(jPeak);
                continue block0;
            }
        }
        this.getPeaks().removeAll(uninformative);
    }

    private void doFilterLabelAssociatedIonsOriginal(ArrayList<Double> reporters, double isobaric_tag, Boolean reporter) {
        ArrayList<JPeak> uninformative = new ArrayList<JPeak>();
        double h = 1.007825035;
        double labelH = isobaric_tag + h;
        double labelH2 = isobaric_tag + h * 2.0;
        double o = 15.994915;
        double c = 12.0;
        double precusorMinuslabel = this.getParentMass() - isobaric_tag;
        ArrayList<Double> precEnvelope = this.predictPrecEnvelope();
        block0: for (JPeak jPeak : this.getPeaks()) {
            double mz = jPeak.getMz();
            if (Config.delta(labelH, mz) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            if (Config.delta(labelH2, mz) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            if (Config.delta(precusorMinuslabel, mz) <= Config.ms2tol) {
                uninformative.add(jPeak);
                continue;
            }
            for (Double mass : reporters) {
                if (reporter.booleanValue() && Config.delta(mass, mz) <= Config.ms2tol) {
                    uninformative.add(jPeak);
                    break;
                }
                double repCOH = mass + c + o + h;
                double precusorMinusRepCOH = this.getParentMass() - repCOH;
                if (Config.delta(repCOH, mz) <= Config.ms2tol) {
                    uninformative.add(jPeak);
                    break;
                }
                if (!(Config.delta(precusorMinusRepCOH, mz) <= Config.ms2tol)) continue;
                uninformative.add(jPeak);
                break;
            }
            for (Double precEnv : precEnvelope) {
                if (!(Config.deltaPPM(precEnv, mz) <= 20.0)) continue;
                uninformative.add(jPeak);
                continue block0;
            }
        }
        this.getPeaks().removeAll(uninformative);
    }

    public ArrayList<Double> predictPrecEnvelope() {
        ArrayList<Double> precEnv = new ArrayList<Double>();
        double neutron = 1.0033548;
        double preMZ = this.getParentMassToCharge();
        precEnv.add(preMZ);
        double preMZiso1 = preMZ + neutron / (double)this.getCharge();
        precEnv.add(preMZiso1);
        double preMZiso2 = preMZ + neutron / (double)this.getCharge() * 2.0;
        precEnv.add(preMZiso2);
        return precEnv;
    }

    public void module2(Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean filter) {
        if (isoReduction.booleanValue()) {
            this.doBackwardSearch();
            this.doIsotopicPeakReductionChargeDeconvolution(chargeDeconv);
            if (ionsMerge.booleanValue()) {
                this.doIonMerge();
            }
            this.doFilterIonsLargerThanPrecursor(filter);
        } else {
            this.fragmentChargePredictionWithoutDeisotoping();
            this.doIsotopicPeakReductionChargeDeconvolution(chargeDeconv);
            if (ionsMerge.booleanValue()) {
                this.doIonMerge();
            }
            this.doFilterIonsLargerThanPrecursor(filter);
        }
    }

    private void doFindEnvelopCluster() {
        this.doForwardSearch();
        this.doBackwardSearch();
    }

    private void doForwardSearch() {
        this.initializeFragmentCharge();
        int maxcharge = this.getCharge();
        double neutron = 1.0033548;
        this.sortPeaksByMZ();
        block0: for (int i = 0; i < this.getPeaks().size(); ++i) {
            JPeak jPeak1 = this.getPeaks().get(i);
            for (int j = i + 1; j < this.getPeaks().size(); ++j) {
                JPeak jPeak2 = this.getPeaks().get(j);
                for (int charge = maxcharge; charge > 0; --charge) {
                    if (!(Math.abs(jPeak2.getMz() - jPeak1.getMz() - neutron / (double)charge) < 0.02) || !(jPeak1.getIntensity() > jPeak2.getIntensity() / 2.0)) continue;
                    jPeak2.setIntensity(0.0);
                    jPeak1.setCharge(charge);
                    jPeak2.setCharge(charge);
                }
                if (jPeak2.getMz() - jPeak1.getMz() > 2.0) continue block0;
            }
        }
    }

    private void doBackwardSearch() {
        this.initializeFragmentCharge();
        int maxcharge = this.getCharge();
        double neutron = 1.0033548;
        this.sortPeaksByMZ();
        Collections.reverse(this.getPeaks());
        block0: for (int i = 0; i < this.getPeaks().size(); ++i) {
            JPeak jPeak1 = this.getPeaks().get(i);
            for (int j = i + 1; j < this.getPeaks().size(); ++j) {
                JPeak jPeak2 = this.getPeaks().get(j);
                for (int charge = maxcharge; charge > 0; --charge) {
                    if (!(Math.abs(jPeak1.getMz() - jPeak2.getMz() - neutron / (double)charge) < 0.02) || !(jPeak2.getIntensity() > jPeak1.getIntensity() / 2.0)) continue;
                    jPeak1.setIntensity(0.0);
                    jPeak1.setCharge(charge);
                    jPeak2.setCharge(charge);
                }
                if (jPeak1.getMz() - jPeak2.getMz() > 2.0) continue block0;
            }
        }
    }

    private void fragmentChargePredictionWithoutDeisotoping() {
        this.initializeFragmentCharge();
        int maxcharge = this.getCharge();
        double neutron = 1.0033548;
        this.sortPeaksByMZ();
        Collections.reverse(this.getPeaks());
        block0: for (int i = 0; i < this.getPeaks().size(); ++i) {
            JPeak jPeak1 = this.getPeaks().get(i);
            for (int j = i + 1; j < this.getPeaks().size(); ++j) {
                JPeak jPeak2 = this.getPeaks().get(j);
                for (int charge = maxcharge; charge > 0; --charge) {
                    if (!(Math.abs(jPeak1.getMz() - jPeak2.getMz() - neutron / (double)charge) < Config.ms2tol) || !(jPeak2.getIntensity() > jPeak1.getIntensity() / 2.0)) continue;
                    jPeak1.setCharge(charge);
                    jPeak2.setCharge(charge);
                }
                if (jPeak1.getMz() - jPeak2.getMz() > 2.0) continue block0;
            }
        }
        for (JPeak jPeak : this.getPeaks()) {
            if (jPeak.getCharge() != 0) continue;
            jPeak.setCharge(1);
        }
    }

    private void initializeFragmentCharge() {
        for (JPeak jPeak : this.getPeaks()) {
            jPeak.setCharge(0);
        }
    }

    private void doIsotopicPeakReductionChargeDeconvolution(Boolean chargeDeconv) {
        ArrayList<JPeak> filter = new ArrayList<JPeak>();
        for (JPeak jPeak : this.getPeaks()) {
            if (jPeak.getIntensity() > 0.0) {
                if (!chargeDeconv.booleanValue()) continue;
                if (jPeak.getCharge() > 1) {
                    double mass = jPeak.getMz() * (double)jPeak.getCharge() - (double)(jPeak.getCharge() - 1) * ElementaryIon.proton.getTheoreticMass();
                    jPeak.setMz(mass);
                    jPeak.setCharge(1);
                    continue;
                }
                if (jPeak.getCharge() != 0) continue;
                jPeak.setCharge(1);
                continue;
            }
            filter.add(jPeak);
        }
        this.getPeaks().removeAll(filter);
        this.sortPeaksByMZ();
    }

    private void doIonMerge() {
        ArrayList<JPeak> jPeaks = new ArrayList<JPeak>();
        double previousMZ = this.getPeaks().get(0).getMz();
        double previousIntensity = this.getPeaks().get(0).getIntensity();
        for (int i = 0; i < this.getPeaks().size(); ++i) {
            double mz = this.getPeaks().get(i).getMz();
            double intensity = this.getPeaks().get(i).getIntensity();
            if (Math.abs(previousMZ - mz) <= 0.05) {
                double mzMerge = (mz + previousMZ) / 2.0;
                double intensityMerge = (intensity + previousIntensity) / 2.0;
                previousMZ = mzMerge;
                previousIntensity = intensityMerge;
                continue;
            }
            JPeak jPeak = new JPeak(previousMZ, previousIntensity);
            jPeaks.add(jPeak);
            previousMZ = mz;
            previousIntensity = intensity;
            if (i != this.getPeaks().size() - 1) continue;
            JPeak jPeakLastOne = new JPeak(previousMZ, previousIntensity);
            jPeaks.add(jPeakLastOne);
        }
        this.setPeaks(jPeaks);
    }

    private void doFilterIonsLargerThanPrecursor(Boolean filter) {
        ArrayList<JPeak> filer = new ArrayList<JPeak>();
        for (JPeak jPeak : this.getPeaks()) {
            if (!(jPeak.getMz() > this.getParentMass())) continue;
            filer.add(jPeak);
        }
        this.getPeaks().removeAll(filer);
    }

    public double getTotalIonCurrent() {
        return this.totalIonCurrent;
    }

    public static enum IsobaricTag {
        ITRAQ4PLEX(144.102063, Arrays.asList(114.110679, 115.107714, 116.111069, 117.114424)),
        ITRAQ8PLEX(304.20536, Arrays.asList(113.107324, 114.110679, 115.107714, 116.111069, 117.114424, 118.111459, 119.114814, 121.121523)),
        TMT6PLEX(229.162932, Arrays.asList(126.1277261, 127.1310809, 128.1344357, 129.1377905, 130.1411453, 131.1381802)),
        TMT10PLEX(229.162932, Arrays.asList(126.1277261, 127.124761, 127.1310809, 128.1281158, 128.1344357, 129.1314706, 129.1377905, 130.1348254, 130.1411453, 131.1381802)),
        TMT11PLEX(229.162932, Arrays.asList(126.1277261, 127.124761, 127.1310809, 128.1281158, 128.1344357, 129.1314706, 129.1377905, 130.1348254, 130.1411453, 131.1381802, 131.144999)),
        TMT16PLEX(304.2071, Arrays.asList(126.127726, 127.124761, 127.131081, 128.128116, 128.134436, 129.131471, 129.13779, 130.134825, 130.141145, 131.13818, 131.1445, 132.141535, 132.147855, 133.14489, 133.15121, 134.148245)),
        TMT18PLEX(304.2071, Arrays.asList(126.127726, 127.124761, 127.131081, 128.128116, 128.134436, 129.131471, 129.13779, 130.134825, 130.141145, 131.13818, 131.1445, 132.141535, 132.147855, 133.14489, 133.15121, 134.148245, 134.154565, 135.1516));

        public final List<Double> reporterIons;
        public final double tagMass;

        private IsobaricTag(double mass, List<Double> reporters) {
            this.reporterIons = reporters;
            this.tagMass = mass;
        }
    }
}

