/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class CollectionUtils {
    public static <T> Stream<List<T>> createSlidingWindow(List<T> list, int size) {
        return IntStream.range(0, list.size()).mapToObj(i -> list.subList(Math.min(list.size(), size * i), Math.min(list.size(), size + size * i))).filter(l -> !l.isEmpty());
    }

    public static <T> Stream<List<T>> createOverlapSlidingWindow(List<T> list, int size) {
        if (size > list.size()) {
            return Stream.empty();
        }
        return IntStream.range(0, list.size() - size + 1).mapToObj(start -> list.subList(start, start + size));
    }
}

