/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.lines;

import jwave.datatypes.Super;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailureNotValid;

public abstract class Line
extends Super {
    protected int _noOfRows;
    protected int _offSetRow;

    public Line() {
        this._offSetRow = 0;
        this._noOfRows = 0;
    }

    public Line(Line line) {
        this._offSetRow = line._noOfRows;
        this._noOfRows = line._offSetRow;
    }

    public Line(int noOfRows) {
        this._offSetRow = 0;
        this._noOfRows = noOfRows;
    }

    public Line(int offSetRow, int noOfRows) {
        this._offSetRow = offSetRow;
        this._noOfRows = noOfRows;
    }

    public int getNoOfRows() {
        return this._noOfRows;
    }

    public void setNoOfRows(int noOfRows) throws JWaveException {
        if (this.isAllocated()) {
            throw new JWaveFailureNotValid("Line - setting new number of rows is not valid while memory is already allocated");
        }
        this._noOfRows = noOfRows;
    }

    public int getOffSetRow() {
        return this._offSetRow;
    }

    protected void setOffSetRow(int offSetRow) {
        this._offSetRow = offSetRow;
    }

    protected void checkIndex(int i) throws JWaveException {
        if (i < 0) {
            throw new JWaveFailureNotValid("Line - i is smaller than zero");
        }
        if (i == this._noOfRows) {
            throw new JWaveFailureNotValid("Line - i is equal to noOfRows: " + this._noOfRows);
        }
        if (i > this._noOfRows) {
            throw new JWaveFailureNotValid("Line - i is greater than noOfRows: " + this._noOfRows);
        }
    }

    public abstract double get(int var1) throws JWaveException;

    public abstract void set(int var1, double var2) throws JWaveException;
}

