/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.daubechies;

import jwave.transforms.wavelets.Wavelet;

public class Daubechies2
extends Wavelet {
    public Daubechies2() {
        this._name = "Daubechies 2";
        this._transformWavelength = 2;
        this._motherWavelength = 4;
        double sqrt3 = Math.sqrt(3.0);
        this._scalingDeCom = new double[this._motherWavelength];
        this._scalingDeCom[0] = (1.0 + sqrt3) / 4.0;
        this._scalingDeCom[1] = (3.0 + sqrt3) / 4.0;
        this._scalingDeCom[2] = (3.0 - sqrt3) / 4.0;
        this._scalingDeCom[3] = (1.0 - sqrt3) / 4.0;
        double sqrt02 = Math.sqrt(2.0);
        int i = 0;
        while (i < this._motherWavelength) {
            int n = i++;
            this._scalingDeCom[n] = this._scalingDeCom[n] / sqrt02;
        }
        this._buildOrthonormalSpace();
    }
}

