/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import com.compomics.software.autoupdater.CompareVersionNumbers;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.autoupdater.MetaDataXMLParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

public class WebDAO {
    private static final Locale LOCALE = new Locale("en");

    public static String getLatestVersionNumberFromRemoteRepo(URL remoteVersionXMLFileLocation) throws XMLStreamException, IOException {
        BufferedReader remoteVersionsReader = new BufferedReader(new InputStreamReader(remoteVersionXMLFileLocation.openStream()));
        XMLInputFactory xmlParseFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlReader = xmlParseFactory.createXMLEventReader(remoteVersionsReader);
        MetaDataXMLParser xmlParser = new MetaDataXMLParser(xmlReader);
        xmlReader.close();
        return xmlParser.getHighestVersionNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getUrlOfZippedVersion(URL repoURL, String suffix, boolean returnAlternateArchives) throws MalformedURLException, IOException {
        BufferedReader reader = null;
        suffix = suffix.trim();
        String toReturn = null;
        String alternativeReturn = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(repoURL.openStream()));
            while ((line = reader.readLine()) != null) {
                if (line.toLowerCase(LOCALE).contains("href=") && line.toLowerCase(LOCALE).contains(suffix)) {
                    toReturn = line.substring(line.indexOf("href=\"") + 6, line.indexOf(suffix, line.indexOf("href=\"")) + suffix.length());
                    break;
                }
                if (!returnAlternateArchives || !line.toLowerCase(LOCALE).contains(".zip") && !line.toLowerCase(LOCALE).contains(".tar.gz") && !line.toLowerCase(LOCALE).contains(".bz")) continue;
                alternativeReturn = line.substring(line.indexOf("href=\"") + 6, line.indexOf(line.indexOf(">"), line.indexOf("href=\"") + 6));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (returnAlternateArchives && toReturn == null) {
            toReturn = alternativeReturn;
        }
        if (toReturn == null) {
            return null;
        }
        return new URL(repoURL.toExternalForm() + "/" + toReturn);
    }

    public static boolean newVersionReleased(MavenJarFile jarFile, URL jarRepository) throws IOException, XMLStreamException {
        String currentVersionNumber = jarFile.getVersionNumber();
        if (currentVersionNumber.contains("b") || currentVersionNumber.contains("beta")) {
            return false;
        }
        boolean newVersion = false;
        String versionRepoURLString = jarRepository.toExternalForm() + jarFile.getGroupId().replaceAll("\\.", "/") + "/" + jarFile.getArtifactId() + "/maven-metadata.xml";
        String latestRemoteRelease = WebDAO.getLatestVersionNumberFromRemoteRepo(new URL(versionRepoURLString));
        if (latestRemoteRelease != null && new CompareVersionNumbers().compare(currentVersionNumber, latestRemoteRelease) == 1) {
            newVersion = true;
        }
        return newVersion;
    }
}

