/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.Atom;
import java.io.Serializable;

public class AtomImpl
implements Serializable {
    static final long serialVersionUID = 3269643086590455656L;
    private Atom atom;
    private String atomSymbol;
    private Integer isotope;

    public AtomImpl(String atomSymbol, Integer isotope) {
        this.atomSymbol = atomSymbol;
        this.isotope = isotope;
    }

    public AtomImpl(Atom atom, Integer isotope) {
        this.atomSymbol = atom.getLetter();
        this.isotope = isotope;
    }

    public Double getMass() {
        if (this.atomSymbol == null) {
            this.atomSymbol = this.atom.getLetter();
        }
        Atom atom = Atom.getAtom(this.atomSymbol);
        return atom.getIsotopeMass(this.isotope);
    }

    public Integer getIsotopeNumber(Integer roundedMass) {
        if (this.atomSymbol == null) {
            this.atomSymbol = this.atom.getLetter();
        }
        Atom atom = Atom.getAtom(this.atomSymbol);
        for (Integer isotopeNumber : atom.getImplementedIsotopes()) {
            Double isotopeMass = atom.getIsotopeMass(isotopeNumber);
            Integer isotopeRoundedMass = (int)Math.round(isotopeMass);
            if (!roundedMass.equals(isotopeRoundedMass)) continue;
            return isotopeNumber;
        }
        return null;
    }

    public String toString() {
        if (this.atomSymbol == null) {
            this.atomSymbol = this.atom.getLetter();
        }
        Atom atom = Atom.getAtom(this.atomSymbol);
        if (this.isotope == 0) {
            return atom.getLetter();
        }
        if (this.getMass() == null) {
            throw new UnsupportedOperationException("Isotope " + this.isotope + " not implemented for atom " + atom + ".");
        }
        return Math.round(this.getMass()) + atom.getLetter();
    }

    public boolean isSameAs(AtomImpl anotherAtom) {
        return this.toString().equals(anotherAtom.toString());
    }

    public String getAtomSymbol() {
        if (this.atomSymbol == null) {
            this.atomSymbol = this.atom.getLetter();
        }
        return this.atomSymbol;
    }

    public void setAtomSymbol(String atomSymbol) {
        this.atomSymbol = atomSymbol;
    }

    public Integer getIsotope() {
        return this.isotope;
    }

    public void setIsotope(Integer isotope) {
        this.isotope = isotope;
    }
}

