/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.Util;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.IdentificationDB;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.PsmIterator;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public abstract class Identification
extends ExperimentObject {
    static final long serialVersionUID = -2551700699384242554L;
    protected HashSet<String> proteinIdentification = new HashSet();
    protected HashSet<String> peptideIdentification = new HashSet();
    protected HashMap<String, HashSet<String>> spectrumIdentificationMap = new HashMap();
    protected HashMap<String, HashSet<String>> proteinMap = new HashMap();
    protected int methodUsed;
    protected String dbDirectory;
    private IdentificationDB identificationDB;
    protected String reference;
    private ArrayList<String> orderedSpectrumFileNames;

    public ArrayList<String> getOrderedSpectrumFileNames() {
        if (this.orderedSpectrumFileNames == null) {
            this.orderedSpectrumFileNames = this.getSpectrumFiles();
            Collections.sort(this.orderedSpectrumFileNames);
        }
        return this.orderedSpectrumFileNames;
    }

    public void setOrderedListOfSpectrumFileNames(ArrayList<String> orderedSpectrumFileNames) throws IllegalArgumentException {
        if (this.orderedSpectrumFileNames.size() != orderedSpectrumFileNames.size()) {
            throw new IllegalArgumentException("The length of the ordered file names as to be the same as the number of spectrum files. " + orderedSpectrumFileNames.size() + "!=" + this.orderedSpectrumFileNames.size());
        }
        this.orderedSpectrumFileNames = orderedSpectrumFileNames;
    }

    public ArrayList<String> getSpectrumFiles() {
        return new ArrayList<String>(this.spectrumIdentificationMap.keySet());
    }

    public int getSpectrumIdentificationSize() {
        int result = 0;
        for (String spectrumFile : this.spectrumIdentificationMap.keySet()) {
            result += this.spectrumIdentificationMap.get(spectrumFile).size();
        }
        return result;
    }

    public void loadAssumptions(String fileName, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadAssumptions(fileName, waitingHandler, displayProgress);
    }

    public void loadAssumptions(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadAssumptions(spectrumKeys, waitingHandler, displayProgress);
    }

    public void loadRawAssumptions(String fileName, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadRawAssumptions(fileName, waitingHandler, displayProgress);
    }

    public void loadSpectrumMatches(String fileName, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatches(fileName, waitingHandler, displayProgress);
    }

    public void loadSpectrumMatches(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatches(spectrumKeys, waitingHandler, displayProgress);
    }

    public void loadSpectrumMatchParameters(String fileName, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatchParameters(fileName, urParameter, waitingHandler, displayProgress);
    }

    public void loadSpectrumMatchParameters(ArrayList<String> spectrumKeys, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatchParameters(spectrumKeys, urParameter, waitingHandler, displayProgress);
    }

    public void loadPeptideMatches(ArrayList<String> peptideKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatches(peptideKeys, waitingHandler, displayProgress);
    }

    public void loadPeptideMatches(WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatches(waitingHandler, displayProgress);
    }

    public void loadPeptideMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatchParameters(urParameter, waitingHandler, displayProgress);
    }

    public void loadPeptideMatchParameters(ArrayList<String> peptideKeys, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatchParameters(peptideKeys, urParameter, waitingHandler, displayProgress);
    }

    public void loadProteinMatches(WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatches(waitingHandler, displayProgress);
    }

    public void loadProteinMatches(ArrayList<String> proteinKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatches(proteinKeys, waitingHandler, displayProgress);
    }

    public void loadProteinMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatchParameters(urParameter, waitingHandler, displayProgress);
    }

    public void loadProteinMatchParameters(ArrayList<String> proteinKeys, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatchParameters(proteinKeys, urParameter, waitingHandler, displayProgress);
    }

    public UrParameter getSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getSpectrumMatchParameter(key, urParameter, true);
    }

    public UrParameter getSpectrumMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getSpectrumMatchParameter(key, urParameter, useDB);
    }

    public void addSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        this.identificationDB.addSpectrumMatchParameter(key, urParameter);
    }

    public UrParameter getPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getPeptideMatchParameter(key, urParameter, true);
    }

    public UrParameter getPeptideMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getPeptideMatchParameter(key, urParameter, useDB);
    }

    public void addPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        this.identificationDB.addPeptideMatchParameter(key, urParameter);
    }

    public UrParameter getProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getProteinMatchParameter(key, urParameter, true);
    }

    public UrParameter getProteinMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getProteinMatchParameter(key, urParameter, useDB);
    }

    public void addProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        this.identificationDB.addProteinMatchParameter(key, urParameter);
    }

    public void updateSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updateSpectrumParameter(key, urParameter);
    }

    public void updatePeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updatePeptideParameter(key, urParameter);
    }

    public void updateProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updateProteinParameter(key, urParameter);
    }

    public void updateAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptions) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updateAssumptions(spectrumKey, assumptions);
    }

    public void updateRawAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptions) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updateRawAssumptions(spectrumKey, assumptions);
    }

    public void updateSpectrumMatch(SpectrumMatch spectrumMatch) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updateSpectrumMatch(spectrumMatch);
    }

    public void updatePeptideMatch(PeptideMatch peptideMatch) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updatePeptideMatch(peptideMatch);
    }

    public void updatePeptideMatch(String oldKey, String newKey, PeptideMatch peptideMatch) throws SQLException, IOException, InterruptedException, ClassNotFoundException {
        for (String paramterTable : this.identificationDB.getPeptideParametersTables()) {
            UrParameter parameter = (UrParameter)this.identificationDB.getObject(paramterTable, oldKey, true);
            if (parameter == null) continue;
            this.addPeptideMatchParameter(newKey, parameter);
        }
        this.removePeptideMatch(oldKey);
        peptideMatch.setKey(newKey);
        this.peptideIdentification.remove(oldKey);
        this.peptideIdentification.add(newKey);
        this.identificationDB.addPeptideMatch(peptideMatch);
        for (String accession : peptideMatch.getTheoreticPeptide().getParentProteinsNoRemapping()) {
            HashSet<String> proteinGroups = this.proteinMap.get(accession);
            if (proteinGroups == null) continue;
            for (String proteinKey : proteinGroups) {
                ProteinMatch proteinMatch = this.getProteinMatch(proteinKey);
                ArrayList<String> oldPeptideMatches = proteinMatch.getPeptideMatchesKeys();
                ArrayList<String> newPeptideMatches = new ArrayList<String>(oldPeptideMatches.size());
                boolean found = false;
                for (String peptideMatchKey : oldPeptideMatches) {
                    if (peptideMatchKey.equals(oldKey)) {
                        found = true;
                        continue;
                    }
                    newPeptideMatches.add(peptideMatchKey);
                }
                if (found) {
                    newPeptideMatches.add(newKey);
                    proteinMatch.setPeptideKeys(newPeptideMatches);
                }
                this.updateProteinMatch(proteinMatch);
            }
        }
    }

    public void updateProteinMatch(ProteinMatch proteinMatch) throws SQLException, IOException, InterruptedException {
        this.identificationDB.updateProteinMatch(proteinMatch);
    }

    public String getDatabaseDirectory() {
        return this.dbDirectory;
    }

    public void removeAssumptions(String matchKey) throws SQLException, IOException, InterruptedException {
        this.identificationDB.removeAssumptions(matchKey);
    }

    public void removeRawAssumptions(String matchKey) throws SQLException, IOException, InterruptedException {
        this.identificationDB.removeRawAssumptions(matchKey);
    }

    public void removeSpectrumMatch(String matchKey) throws SQLException, IOException, InterruptedException {
        String fileName = Spectrum.getSpectrumFile(matchKey);
        HashSet<String> spectrumKeys = this.spectrumIdentificationMap.get(fileName);
        if (spectrumKeys != null) {
            spectrumKeys.remove(matchKey);
        }
        this.identificationDB.removeSpectrumMatch(matchKey);
    }

    public void removePeptideMatch(String matchKey) throws SQLException, IOException, InterruptedException {
        this.peptideIdentification.remove(matchKey);
        this.identificationDB.removePeptideMatch(matchKey);
    }

    public void removeProteinMatch(String matchKey) throws SQLException, IOException, InterruptedException {
        if (this.proteinIdentification.contains(matchKey)) {
            for (String protein : ProteinMatch.getAccessions(matchKey)) {
                HashSet<String> proteinKeys = this.proteinMap.get(protein);
                if (proteinKeys == null) continue;
                proteinKeys.remove(matchKey);
                if (!proteinKeys.isEmpty()) continue;
                this.proteinMap.remove(protein);
            }
        }
        this.proteinIdentification.remove(matchKey);
        this.identificationDB.removeProteinMatch(matchKey);
    }

    public boolean matchExists(String matchKey) {
        String fileName;
        HashSet<String> spectrumKeys;
        if (matchKey == null || matchKey.length() == 0) {
            return false;
        }
        if (matchKey.lastIndexOf("_cus_") != -1 && (spectrumKeys = this.spectrumIdentificationMap.get(fileName = Spectrum.getSpectrumFile(matchKey))) != null && spectrumKeys.contains(matchKey)) {
            return true;
        }
        return this.proteinIdentification.contains(matchKey) || this.peptideIdentification.contains(matchKey);
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getAssumptions(String spectrumKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getAssumptions(spectrumKey, useDB);
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getAssumptions(String spectrumKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getAssumptions(spectrumKey, true);
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getRawAssumptions(String spectrumKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getRawAssumptions(spectrumKey, useDB);
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getRawAssumptions(String spectrumKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getRawAssumptions(spectrumKey, true);
    }

    public SpectrumMatch getSpectrumMatch(String spectrumKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getSpectrumMatch(spectrumKey, true);
    }

    public SpectrumMatch getSpectrumMatch(String spectrumKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getSpectrumMatch(spectrumKey, useDB);
    }

    public PeptideMatch getPeptideMatch(String peptideKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getPeptideMatch(peptideKey, true);
    }

    public PeptideMatch getPeptideMatch(String peptideKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getPeptideMatch(peptideKey, useDB);
    }

    public ProteinMatch getProteinMatch(String proteinKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getProteinMatch(proteinKey, true);
    }

    public ProteinMatch getProteinMatch(String proteinKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.identificationDB.getProteinMatch(proteinKey, useDB);
    }

    public boolean proteinDetailsInCache(String proteinKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        SpectrumMatch spectrumMatch;
        PeptideMatch peptideMatch;
        ProteinMatch proteinMatch = this.getProteinMatch(proteinKey, false);
        return proteinMatch != null && (peptideMatch = this.getPeptideMatch(proteinMatch.getPeptideMatchesKeys().get(0), false)) != null && (spectrumMatch = this.getSpectrumMatch(peptideMatch.getSpectrumMatchesKeys().get(0), false)) != null;
    }

    public boolean peptideDetailsInCache(String peptideKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        SpectrumMatch spectrumMatch;
        PeptideMatch peptideMatch = this.getPeptideMatch(peptideKey, false);
        return peptideMatch != null && (spectrumMatch = this.getSpectrumMatch(peptideMatch.getSpectrumMatchesKeys().get(0), false)) != null;
    }

    public HashSet<String> getProteinIdentification() {
        return this.proteinIdentification;
    }

    public HashSet<String> getPeptideIdentification() {
        return this.peptideIdentification;
    }

    public HashSet<String> getSpectrumIdentification(String spectrumFile) {
        return this.spectrumIdentificationMap.get(spectrumFile);
    }

    public HashMap<String, HashSet<String>> getSpectrumIdentificationMap() {
        return this.spectrumIdentificationMap;
    }

    public void addAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> newAssumptions, boolean overwriteExisting, boolean newSpectrum) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> currentAssumptions = null;
        if (!newSpectrum && !overwriteExisting) {
            currentAssumptions = this.getAssumptions(spectrumKey, true);
        }
        if (currentAssumptions == null) {
            this.identificationDB.addAssumptions(spectrumKey, newAssumptions);
        } else {
            for (Integer advocateId : newAssumptions.keySet()) {
                HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> newAdvocateMap = newAssumptions.get(advocateId);
                HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> currentAdvocateMap = currentAssumptions.get(advocateId);
                if (newAdvocateMap == null) continue;
                if (currentAdvocateMap == null) {
                    currentAdvocateMap = new HashMap(newAdvocateMap.size());
                    currentAssumptions.put(advocateId, currentAdvocateMap);
                }
                for (double score : newAdvocateMap.keySet()) {
                    ArrayList<SpectrumIdentificationAssumption> newAssumptionList = newAdvocateMap.get(score);
                    ArrayList<SpectrumIdentificationAssumption> currentAssumptionList = currentAdvocateMap.get(score);
                    if (currentAssumptionList == null) {
                        currentAssumptionList = new ArrayList<SpectrumIdentificationAssumption>(newAssumptionList);
                        currentAdvocateMap.put(score, currentAssumptionList);
                        continue;
                    }
                    currentAssumptionList.addAll(newAssumptionList);
                }
            }
            this.updateAssumptions(spectrumKey, currentAssumptions);
        }
    }

    public synchronized void addAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> newAssumptions, boolean newSpectrum) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        this.addAssumptions(spectrumKey, newAssumptions, false, newSpectrum);
    }

    public void addRawAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> newAssumptions) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> currentAssumptions = this.getRawAssumptions(spectrumKey, true);
        if (currentAssumptions == null) {
            this.identificationDB.addRawAssumptions(spectrumKey, newAssumptions);
        } else {
            for (Integer advocateId : newAssumptions.keySet()) {
                HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> newAdvocateMap = newAssumptions.get(advocateId);
                HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> currentAdvocateMap = currentAssumptions.get(advocateId);
                if (newAdvocateMap == null) continue;
                if (currentAdvocateMap == null) {
                    currentAssumptions.put(advocateId, newAdvocateMap);
                    continue;
                }
                for (double score : newAdvocateMap.keySet()) {
                    ArrayList<SpectrumIdentificationAssumption> newAssumptionList = newAdvocateMap.get(score);
                    ArrayList<SpectrumIdentificationAssumption> currentAssumptionList = currentAdvocateMap.get(score);
                    if (currentAssumptionList == null) {
                        currentAdvocateMap.put(score, newAssumptionList);
                        continue;
                    }
                    currentAssumptionList.addAll(newAssumptionList);
                }
            }
            this.updateRawAssumptions(spectrumKey, currentAssumptions);
        }
    }

    public void addSpectrumMatch(SpectrumMatch newMatch) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        String spectrumKey = newMatch.getKey();
        String spectrumFile = Spectrum.getSpectrumFile(spectrumKey);
        HashSet<String> spectrumKeys = this.spectrumIdentificationMap.get(spectrumFile);
        if (spectrumKeys == null) {
            spectrumKeys = this.getSpectrumKeysSynchronized(spectrumFile);
        }
        boolean newSpectrum = !spectrumKeys.contains(spectrumKey);
        HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptions = newMatch.getAssumptionsMap();
        if (assumptions != null) {
            this.addAssumptions(spectrumKey, assumptions, newSpectrum);
            newMatch.removeAssumptions();
        }
        if (newSpectrum) {
            this.addKeyToSetSynchronized(spectrumKeys, spectrumKey);
            this.identificationDB.addSpectrumMatch(newMatch);
        }
    }

    public synchronized void addKeyToSetSynchronized(HashSet<String> spectrumKeys, String spectrumKey) {
        spectrumKeys.add(spectrumKey);
    }

    private synchronized HashSet<String> getSpectrumKeysSynchronized(String spectrumFile) {
        HashSet<String> spectrumKeys = this.spectrumIdentificationMap.get(spectrumFile);
        if (spectrumKeys == null) {
            spectrumKeys = new HashSet(1000);
            this.spectrumIdentificationMap.put(spectrumFile, spectrumKeys);
        }
        return spectrumKeys;
    }

    public void buildPeptidesAndProteins(WaitingHandler waitingHandler, SequenceMatchingPreferences sequenceMatchingPreferences) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(this.getSpectrumIdentificationSize());
            waitingHandler.setSecondaryProgressCounter(0);
        }
        for (String spectrumFile : this.spectrumIdentificationMap.keySet()) {
            for (String spectrumMatchKey : this.spectrumIdentificationMap.get(spectrumFile)) {
                this.buildPeptidesAndProteins(spectrumMatchKey, sequenceMatchingPreferences);
                if (waitingHandler == null) continue;
                waitingHandler.increaseSecondaryProgressCounter();
                if (!waitingHandler.isRunCanceled()) continue;
                return;
            }
        }
    }

    public void buildPeptidesAndProteins(String spectrumMatchKey, SequenceMatchingPreferences sequenceMatchingPreferences) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        SpectrumMatch spectrumMatch = this.getSpectrumMatch(spectrumMatchKey);
        if (spectrumMatch == null) {
            throw new IllegalArgumentException("Spectrum match " + spectrumMatchKey + " not found.");
        }
        if (spectrumMatch.getBestPeptideAssumption() != null) {
            PeptideMatch peptideMatch;
            String peptideKey;
            Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
            if (peptide.getParentProteinsNoRemapping() == null) {
                peptide.getParentProteins(sequenceMatchingPreferences);
            }
            if (this.peptideIdentification.contains(peptideKey = peptide.getMatchingKey(sequenceMatchingPreferences))) {
                peptideMatch = this.getPeptideMatch(peptideKey);
                if (peptideMatch == null) {
                    throw new IllegalArgumentException("Peptide match " + peptideKey + " not found.");
                }
                peptideMatch.addSpectrumMatchKey(spectrumMatchKey);
                this.identificationDB.updatePeptideMatch(peptideMatch);
            } else {
                peptideMatch = new PeptideMatch(peptide, peptideKey);
                peptideMatch.addSpectrumMatchKey(spectrumMatchKey);
                this.peptideIdentification.add(peptideKey);
                try {
                    this.identificationDB.addPeptideMatch(peptideMatch);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IOException("Error while writing peptide match " + peptideKey + " in the database.");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException("Error while writing peptide match " + peptideKey + " in the database.");
                }
            }
            String proteinKey = ProteinMatch.getProteinMatchKey(peptide);
            if (this.proteinIdentification.contains(proteinKey)) {
                ProteinMatch proteinMatch = this.getProteinMatch(proteinKey);
                if (proteinMatch == null) {
                    throw new IllegalArgumentException("Protein match " + proteinKey + " not found.");
                }
                if (!proteinMatch.getPeptideMatchesKeys().contains(peptideKey)) {
                    proteinMatch.addPeptideMatchKey(peptideKey);
                    this.identificationDB.updateProteinMatch(proteinMatch);
                }
            } else {
                ProteinMatch proteinMatch = new ProteinMatch(peptideMatch.getTheoreticPeptide(), peptideKey);
                if (!proteinMatch.getKey().equals(proteinKey)) {
                    throw new IllegalArgumentException("Protein inference issue: the protein key " + proteinKey + " does not match the peptide proteins " + proteinMatch.getKey() + ". Peptide: " + peptideKey + " found in spectrum " + spectrumMatchKey + ".");
                }
                this.proteinIdentification.add(proteinKey);
                for (String protein : peptide.getParentProteinsNoRemapping()) {
                    if (!this.proteinMap.containsKey(protein)) {
                        this.proteinMap.put(protein, new HashSet());
                    }
                    if (this.proteinMap.get(protein).contains(proteinKey)) continue;
                    this.proteinMap.get(protein).add(proteinKey);
                }
                try {
                    this.identificationDB.addProteinMatch(proteinMatch);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IOException("Error while writing protein match " + proteinKey + " in the database.");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException("Error while writing protein match " + proteinKey + " in the database.");
                }
            }
        }
    }

    public void addSpectrumMatches(Iterable<SpectrumMatch> spectrumMatches) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        for (SpectrumMatch spectrumMatch : spectrumMatches) {
            this.addSpectrumMatch(spectrumMatch);
        }
    }

    public int getMethodUsed() {
        return this.methodUsed;
    }

    public HashMap<String, HashSet<String>> getProteinMap() {
        return this.proteinMap;
    }

    public void close() throws SQLException, InterruptedException {
        if (this.identificationDB != null) {
            this.identificationDB.close();
        }
    }

    public IdentificationMatch.MatchType getMatchType(String matchKey) {
        if (this.proteinIdentification.contains(matchKey)) {
            return IdentificationMatch.MatchType.Protein;
        }
        if (this.peptideIdentification.contains(matchKey)) {
            return IdentificationMatch.MatchType.Peptide;
        }
        String fileName = Spectrum.getSpectrumFile(matchKey);
        HashSet<String> spectrumKeys = this.spectrumIdentificationMap.get(fileName);
        if (spectrumKeys != null && spectrumKeys.contains(matchKey)) {
            return IdentificationMatch.MatchType.Spectrum;
        }
        return null;
    }

    public void establishConnection(String dbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB = new IdentificationDB(dbFolder, this.reference, deleteOldDatabase, objectsCache);
    }

    public void restoreConnection(String dbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.restoreConnection(dbFolder, deleteOldDatabase, objectsCache);
    }

    public boolean isConnectionActive() {
        return this.identificationDB.isConnectionActive();
    }

    public static String getDefaultReference(String experimentReference, String sampleReference, int replicateNumber) {
        return Util.removeForbiddenCharacters(experimentReference + "_" + sampleReference + "_" + replicateNumber + "_id");
    }

    public HashSet<String> getProteinMatches(Peptide peptide) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        HashSet<String> proteinMatches = new HashSet<String>();
        if (peptide.getParentProteinsNoRemapping() == null) {
            throw new IllegalArgumentException("Proteins are not mapped for peptide " + peptide.getKey() + ".");
        }
        for (String accession : peptide.getParentProteinsNoRemapping()) {
            HashSet<String> keys = this.proteinMap.get(accession);
            if (keys == null) continue;
            for (String key : keys) {
                proteinMatches.add(key);
            }
        }
        return proteinMatches;
    }

    public boolean isUniqueInDatabase(Peptide peptide) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        return this.getProteinMatches(peptide).size() == 1;
    }

    public PsmIterator getPsmIterator(String spectrumFile, ArrayList<String> spectrumKeys, ArrayList<UrParameter> psmParameters, boolean loadAssumptions, WaitingHandler waitingHandler) {
        return new PsmIterator(spectrumFile, spectrumKeys, this, psmParameters, loadAssumptions, waitingHandler);
    }

    public PsmIterator getPsmIterator(String spectrumFile, ArrayList<UrParameter> psmParameters, boolean loadAssumptions, WaitingHandler waitingHandler) {
        return new PsmIterator(spectrumFile, this, psmParameters, loadAssumptions, waitingHandler);
    }

    public PsmIterator getPsmIterator(String spectrumFile, boolean loadAssumptions, WaitingHandler waitingHandler) {
        return new PsmIterator(spectrumFile, this, loadAssumptions, waitingHandler);
    }

    public PsmIterator getPsmIterator(ArrayList<String> spectrumKeys, ArrayList<UrParameter> psmParameters, boolean loadAssumptions, WaitingHandler waitingHandler) {
        return new PsmIterator(spectrumKeys, this, psmParameters, loadAssumptions, waitingHandler);
    }

    public PsmIterator getPsmIterator(ArrayList<String> spectrumKeys, boolean loadAssumptions, WaitingHandler waitingHandler) {
        return new PsmIterator(spectrumKeys, this, loadAssumptions, waitingHandler);
    }

    public PsmIterator getPsmIterator(boolean loadAssumptions, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        return new PsmIterator(this, psmParameters, loadAssumptions, waitingHandler);
    }

    public PeptideMatchesIterator getPeptideMatchesIterator(ArrayList<String> peptideKeys, ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        return new PeptideMatchesIterator(peptideKeys, this, peptideParameters, loadPsms, psmParameters, waitingHandler);
    }

    public PeptideMatchesIterator getPeptideMatchesIterator(ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        return new PeptideMatchesIterator(this, peptideParameters, loadPsms, psmParameters, waitingHandler);
    }

    public ProteinMatchesIterator getProteinMatchesIterator(ArrayList<String> proteinKeys, ArrayList<UrParameter> proteinParameters, boolean loadPeptides, ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        return new ProteinMatchesIterator(proteinKeys, this, proteinParameters, loadPeptides, peptideParameters, loadPsms, psmParameters, waitingHandler);
    }

    public ProteinMatchesIterator getProteinMatchesIterator(ArrayList<UrParameter> proteinParameters, boolean loadPeptides, ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        return new ProteinMatchesIterator(this, proteinParameters, loadPeptides, peptideParameters, loadPsms, psmParameters, waitingHandler);
    }

    public IdentificationDB getIdentificationDB() {
        return this.identificationDB;
    }
}

