/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapper;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;

public class PeptideAssumptionFilter
implements Serializable {
    static final long serialVersionUID = 8416219001106063781L;
    private int minPepLength;
    private int maxPepLength;
    private double maxMassDeviation;
    private boolean isPpm;
    private boolean unknownPtm;
    private Integer minMissedCleavages;
    private Integer maxMissedCleavages;
    private Integer minIsotopes;
    private Integer maxIsotopes;

    public PeptideAssumptionFilter() {
        this.minPepLength = 8;
        this.maxPepLength = 30;
        this.maxMassDeviation = -1.0;
        this.isPpm = true;
        this.unknownPtm = true;
        this.minMissedCleavages = null;
        this.maxMissedCleavages = null;
        this.minIsotopes = null;
        this.maxIsotopes = null;
    }

    public PeptideAssumptionFilter(int minPepLength, int maxPepLength, double maxMzDeviation, boolean isPpm, boolean unknownPTM, Integer minMissedCleavages, Integer maxMissedCleavages, Integer minIsotopes, Integer maxIsotopes) {
        this.minPepLength = minPepLength;
        this.maxPepLength = maxPepLength;
        this.maxMassDeviation = maxMzDeviation;
        this.isPpm = isPpm;
        this.unknownPtm = unknownPTM;
        this.minMissedCleavages = minMissedCleavages;
        this.maxMissedCleavages = maxMissedCleavages;
        this.minIsotopes = minIsotopes;
        this.maxIsotopes = maxIsotopes;
    }

    public void setFilterFromSearchParameters(SearchParameters searchParameters) {
        this.isPpm = searchParameters.isPrecursorAccuracyTypePpm();
        this.maxMassDeviation = searchParameters.getPrecursorAccuracy();
        this.minIsotopes = searchParameters.getMinIsotopicCorrection();
        this.maxIsotopes = searchParameters.getMaxIsotopicCorrection();
        this.unknownPtm = true;
    }

    public boolean validatePeptide(Peptide peptide, SequenceMatchingPreferences sequenceMatchingPreferences, DigestionPreferences digestionPreferences) {
        String peptideSequence = peptide.getSequence();
        int sequenceLength = peptideSequence.length();
        if (this.maxPepLength > 0 && sequenceLength > this.maxPepLength || this.minPepLength > 0 && sequenceLength < this.minPepLength) {
            return false;
        }
        double xShare = (double)Util.getOccurrence(peptideSequence, 'X') / (double)sequenceLength;
        if (sequenceMatchingPreferences.hasLimitX() && xShare > sequenceMatchingPreferences.getLimitX()) {
            return false;
        }
        if (this.minMissedCleavages != null || this.maxMissedCleavages != null) {
            Integer peptideMinMissedCleavages = peptide.getNMissedCleavages(digestionPreferences);
            if (this.minMissedCleavages != null && peptideMinMissedCleavages != null && peptideMinMissedCleavages < this.minMissedCleavages) {
                return false;
            }
            if (this.maxMissedCleavages != null && peptideMinMissedCleavages != null && peptideMinMissedCleavages > this.maxMissedCleavages) {
                return false;
            }
        }
        return true;
    }

    public boolean validateProteins(Peptide peptide, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        return this.validateProteins(peptide, sequenceMatchingPreferences, SequenceFactory.getInstance().getDefaultPeptideMapper());
    }

    public boolean validateProteins(Peptide peptide, SequenceMatchingPreferences sequenceMatchingPreferences, PeptideMapper peptideMapper) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        ArrayList<String> accessions = peptide.getParentProteins(sequenceMatchingPreferences, peptideMapper);
        if (accessions != null && accessions.size() > 1) {
            boolean target = false;
            boolean decoy = false;
            for (String accession : accessions) {
                if (SequenceFactory.getInstance().isDecoyAccession(accession)) {
                    decoy = true;
                    continue;
                }
                target = true;
            }
            if (target && decoy) {
                return false;
            }
        }
        return true;
    }

    public boolean validateModifications(Peptide peptide, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences, PtmSettings modificationProfile) {
        ArrayList<ModificationMatch> modificationMatches;
        if (this.unknownPtm && (modificationMatches = peptide.getModificationMatches()) != null) {
            for (ModificationMatch modMatch : modificationMatches) {
                String ptmName = modMatch.getTheoreticPtm();
                if (!ptmName.equals(PTMFactory.unknownPTM.getName())) continue;
                return false;
            }
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        HashMap<Double, Integer> modMatches = new HashMap<Double, Integer>(peptide.getNModifications());
        if (peptide.isModified()) {
            for (ModificationMatch modMatch : peptide.getModificationMatches()) {
                if (!modMatch.isVariable()) continue;
                String modName = modMatch.getTheoreticPtm();
                PTM ptm = ptmFactory.getPTM(modName);
                double mass = ptm.getMass();
                if (!modMatches.containsKey(mass)) {
                    modMatches.put(mass, 1);
                    continue;
                }
                modMatches.put(mass, (Integer)modMatches.get(mass) + 1);
            }
        }
        Iterator<ModificationMatch> iterator = modMatches.keySet().iterator();
        while (iterator.hasNext()) {
            double mass = (Double)((Object)iterator.next());
            try {
                ArrayList<Integer> possiblePositions = peptide.getPotentialModificationSites(mass, sequenceMatchingPreferences, ptmSequenceMatchingPreferences, modificationProfile);
                if (possiblePositions.size() >= (Integer)modMatches.get(mass)) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean validatePrecursor(PeptideAssumption assumption, String spectrumKey, SpectrumFactory spectrumFactory, SearchParameters searchParameters) throws IOException, MzMLUnmarshallerException, InterruptedException {
        double precursorMz = spectrumFactory.getPrecursorMz(spectrumKey);
        int isotopeNumber = assumption.getIsotopeNumber(precursorMz, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
        if (this.minIsotopes != null && isotopeNumber < this.minIsotopes) {
            return false;
        }
        if (this.maxIsotopes != null && isotopeNumber > this.maxIsotopes) {
            return false;
        }
        Double mzDeviation = assumption.getDeltaMass(precursorMz, this.isPpm, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
        return this.maxMassDeviation <= 0.0 || Math.abs(mzDeviation) <= this.maxMassDeviation;
    }

    public boolean removeUnknownPTMs() {
        return this.unknownPtm;
    }

    public void setRemoveUnknownPTMs(boolean unknownPtm) {
        this.unknownPtm = unknownPtm;
    }

    public boolean isIsPpm() {
        return this.isPpm;
    }

    public void setIsPpm(boolean isPpm) {
        this.isPpm = isPpm;
    }

    public double getMaxMzDeviation() {
        return this.maxMassDeviation;
    }

    public void setMaxMzDeviation(double maxMzDeviation) {
        this.maxMassDeviation = maxMzDeviation;
    }

    public int getMaxPepLength() {
        return this.maxPepLength;
    }

    public void setMaxPepLength(int maxPepLength) {
        this.maxPepLength = maxPepLength;
    }

    public int getMinPepLength() {
        return this.minPepLength;
    }

    public void setMinPepLength(int minPepLength) {
        this.minPepLength = minPepLength;
    }

    public Integer getMinIsotopes() {
        return this.minIsotopes;
    }

    public void setMinIsotopes(Integer minIsotopes) {
        this.minIsotopes = minIsotopes;
    }

    public Integer getMaxIsotopes() {
        return this.maxIsotopes;
    }

    public void setMaxIsotopes(Integer maxIsotopes) {
        this.maxIsotopes = maxIsotopes;
    }

    public boolean isSameAs(PeptideAssumptionFilter anotherFilter) {
        if (this.minMissedCleavages != null && anotherFilter.getMinMissedCleavages() != null && !this.minMissedCleavages.equals(anotherFilter.getMinMissedCleavages())) {
            return false;
        }
        if (this.minMissedCleavages != null && anotherFilter.getMinMissedCleavages() == null) {
            return false;
        }
        if (this.minMissedCleavages == null && anotherFilter.getMinMissedCleavages() != null) {
            return false;
        }
        if (this.maxMissedCleavages != null && anotherFilter.getMaxMissedCleavages() != null && this.maxMissedCleavages.equals(anotherFilter.getMaxMissedCleavages())) {
            return false;
        }
        if (this.maxMissedCleavages != null && anotherFilter.getMaxMissedCleavages() == null) {
            return false;
        }
        if (this.maxMissedCleavages == null && anotherFilter.getMaxMissedCleavages() != null) {
            return false;
        }
        if (this.minIsotopes != null && anotherFilter.getMinIsotopes() != null && !this.minIsotopes.equals(anotherFilter.getMinIsotopes())) {
            return false;
        }
        if (this.minIsotopes != null && anotherFilter.getMinIsotopes() == null) {
            return false;
        }
        if (this.minIsotopes == null && anotherFilter.getMinIsotopes() != null) {
            return false;
        }
        if (this.maxIsotopes != null && anotherFilter.getMaxIsotopes() != null && !this.maxIsotopes.equals(anotherFilter.getMaxIsotopes())) {
            return false;
        }
        if (this.maxIsotopes != null && anotherFilter.getMaxIsotopes() == null) {
            return false;
        }
        if (this.maxIsotopes == null && anotherFilter.getMaxIsotopes() != null) {
            return false;
        }
        return this.isPpm == anotherFilter.isPpm && this.unknownPtm == anotherFilter.removeUnknownPTMs() && this.minPepLength == anotherFilter.getMinPepLength() && this.maxPepLength == anotherFilter.getMaxPepLength() && this.maxMassDeviation == anotherFilter.getMaxMzDeviation();
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Peptide Length: ").append(this.minPepLength).append("-").append(this.maxPepLength).append(".").append(newLine);
        if (this.maxMassDeviation >= 0.0) {
            output.append("Precursor m/z Deviation: ").append(this.maxMassDeviation);
            if (this.isPpm) {
                output.append(" ppm.").append(newLine);
            } else {
                output.append(" Da.").append(newLine);
            }
        }
        output.append("Ignore Unknown PTMs: ").append(this.unknownPtm).append(".").append(newLine);
        if (this.minMissedCleavages != null || this.maxMissedCleavages != null) {
            output.append("Missed Cleavages: ");
            if (this.minMissedCleavages != null) {
                output.append(this.minMissedCleavages);
            } else {
                output.append("0");
            }
            output.append("-");
            if (this.maxMissedCleavages != null) {
                output.append(this.maxMissedCleavages);
            } else {
                output.append("n");
            }
            output.append(".").append(newLine);
        }
        if (this.minIsotopes != null || this.maxIsotopes != null) {
            output.append("Isotopes: ");
            if (this.minIsotopes != null) {
                output.append(this.minIsotopes);
            } else {
                output.append("n");
            }
            output.append("-");
            if (this.maxIsotopes != null) {
                output.append(this.maxIsotopes);
            } else {
                output.append("n");
            }
            output.append(".").append(newLine);
        }
        return output.toString();
    }

    public Integer getMinMissedCleavages() {
        return this.minMissedCleavages;
    }

    public void setMinMissedCleavages(Integer minMissedCleavages) {
        this.minMissedCleavages = minMissedCleavages;
    }

    public Integer getMaxMissedCleavages() {
        return this.maxMissedCleavages;
    }

    public void setMaxMissedCleavages(Integer maxMissedCleavages) {
        this.maxMissedCleavages = maxMissedCleavages;
    }
}

