/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.io.json.marshallers.IdentificationParametersMarshaller;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.MarshallableParameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class IdentificationParametersFactory {
    private static IdentificationParametersFactory instance = null;
    private static String PARENT_FOLDER = System.getProperty("user.home") + "/.compomics";
    public static final String PARAMETERS_FOLDER = "identification_parameters";
    public static final String PARAMETERS_EXTENSION = ".par";
    private HashMap<String, IdentificationParameters> identificationParametersMap = new HashMap();

    private IdentificationParametersFactory() {
        File parametersFolder = IdentificationParametersFactory.getParametersFolder();
        if (!parametersFolder.exists()) {
            parametersFolder.mkdirs();
        }
        this.parseFolder();
    }

    public static IdentificationParametersFactory getInstance() {
        if (instance == null) {
            instance = new IdentificationParametersFactory();
        }
        return instance;
    }

    public ArrayList<String> getParametersList() {
        ArrayList<String> names = new ArrayList<String>(this.identificationParametersMap.keySet());
        Collections.sort(names);
        return names;
    }

    public IdentificationParameters getIdentificationParameters(String name) {
        return this.identificationParametersMap.get(name);
    }

    public static File getIdentificationParametersFile(String name) {
        return new File(IdentificationParametersFactory.getParametersFolder(), name + PARAMETERS_EXTENSION);
    }

    public void removeIdentificationParameters(String name) {
        this.identificationParametersMap.remove(name);
        File parametersFile = IdentificationParametersFactory.getIdentificationParametersFile(name);
        parametersFile.delete();
    }

    public void addIdentificationParameters(IdentificationParameters identificationParameters) throws IOException, FileNotFoundException, ClassNotFoundException {
        String parametersName = identificationParameters.getName();
        if (parametersName == null || parametersName.length() == 0) {
            throw new IllegalArgumentException("Parameters name not set or empty.");
        }
        File parametersFile = IdentificationParametersFactory.getIdentificationParametersFile(parametersName);
        IdentificationParameters.saveIdentificationParameters(identificationParameters, parametersFile);
        this.identificationParametersMap.put(identificationParameters.getName(), identificationParameters);
    }

    public void updateIdentificationParameters(IdentificationParameters oldParameters, IdentificationParameters newParameters) throws IOException, FileNotFoundException, ClassNotFoundException {
        this.removeIdentificationParameters(oldParameters.getName());
        this.addIdentificationParameters(newParameters);
    }

    private static File getParametersFolder() {
        return new File(PARENT_FOLDER, PARAMETERS_FOLDER);
    }

    public static String getParentFolder() {
        return PARENT_FOLDER;
    }

    public static void setParentFolder(String PARENT_FOLDER) {
        IdentificationParametersFactory.PARENT_FOLDER = PARENT_FOLDER;
    }

    private void parseFolder() {
        for (File parameterFile : IdentificationParametersFactory.getParametersFolder().listFiles()) {
            if (!parameterFile.getName().endsWith(PARAMETERS_EXTENSION)) continue;
            try {
                IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
                Class<IdentificationParameters> expectedObjectType = IdentificationParameters.class;
                Object object = jsonMarshaller.fromJson(expectedObjectType, parameterFile);
                IdentificationParameters identificationParameters = (IdentificationParameters)object;
                if (identificationParameters.getType() != MarshallableParameter.Type.identification_parameters) continue;
                this.identificationParametersMap.put(identificationParameters.getName(), identificationParameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

