/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_fragmentation;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.identification.peptide_fragmentation.PeptideFragmentationModel;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.SequestFragmentationModel;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.UniformFragmentation;

public class FragmentItensityPredictor {
    private PeptideFragmentationModel peptideFragmentationModel;

    public FragmentItensityPredictor(PeptideFragmentationModel peptideFragmentationModel) {
        this.peptideFragmentationModel = peptideFragmentationModel;
    }

    public Double getIntentisy(Ion ion) {
        switch (this.peptideFragmentationModel) {
            case uniform: {
                return UniformFragmentation.getIntensity();
            }
            case sequest: {
                return SequestFragmentationModel.getIntensity(ion);
            }
        }
        throw new UnsupportedOperationException("Fragmentation model " + (Object)((Object)this.peptideFragmentationModel) + " not supported.");
    }
}

