/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.gui.parameters.IdentificationParametersEditionDialog;
import com.compomics.util.gui.parameters.identification_parameters.IdentificationParametersNameDialog;
import com.compomics.util.gui.parameters.identification_parameters.SearchSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.ValidationQCPreferencesDialogParent;
import com.compomics.util.io.ConfigurationFile;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.io.json.marshallers.IdentificationParametersMarshaller;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.LastSelectedFolder;
import com.compomics.util.preferences.MarshallableParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class IdentificationParametersSelectionDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private Image normalIcon;
    private Image waitingIcon;
    private LastSelectedFolder lastSelectedFolder;
    private boolean editable;
    private ConfigurationFile configurationFile;
    private ValidationQCPreferencesDialogParent validationQCPreferencesDialogParent;
    private IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();
    private JMenuItem addDetailsMenuItem;
    private JMenuItem addFile;
    private JMenu addMenu;
    private JMenuItem addProtocolMenuItem;
    private JMenuItem addSearchSettingsMenuItem;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JMenuItem editDetailsMenuItem;
    private JMenu editMenu;
    private JMenuItem editProtocolMenuItem;
    private JMenuItem editSearchSettingsMenuItem;
    private JLabel helpLbl;
    private JButton okButton;
    private JPopupMenu parametersPopupMenu;
    private JMenuItem removeMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem saveAsMenuItem;
    private JTable settingsTable;
    private JScrollPane settingsTableScrollPane;
    private JPanel tablePanel;

    public IdentificationParametersSelectionDialog(Frame parentFrame, Dialog owner, IdentificationParameters identificationParameters, StartupMode startupMode, ConfigurationFile configurationFile, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, ValidationQCPreferencesDialogParent validationQCPreferencesDialogParent, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.configurationFile = configurationFile;
        this.lastSelectedFolder = lastSelectedFolder;
        this.validationQCPreferencesDialogParent = validationQCPreferencesDialogParent;
        this.initComponents();
        this.setUpGui();
        this.populateGUI();
        if (identificationParameters != null) {
            if (startupMode == StartupMode.searchParameters) {
                this.editSearchSettings(identificationParameters);
            } else if (startupMode == StartupMode.advanced) {
                this.editAdvanced(identificationParameters);
            } else if (startupMode == StartupMode.none) {
                this.setLocationRelativeTo(owner);
                this.setVisible(true);
            } else {
                throw new UnsupportedOperationException("Start-up mode " + (Object)((Object)startupMode) + " not implemented.");
            }
            String identificationParametersName = identificationParameters.getName();
            if (identificationParametersName == null || identificationParametersName.length() == 0) {
                this.canceled = true;
            } else {
                int row = this.getRow(identificationParametersName);
                if (row == -1) {
                    this.canceled = true;
                } else {
                    this.settingsTable.setRowSelectionInterval(row, row);
                }
            }
        } else if (this.identificationParametersFactory.getParametersList().isEmpty()) {
            this.addFromSearchSettings();
            if (this.settingsTable.getRowCount() > 0) {
                this.settingsTable.setRowSelectionInterval(0, 0);
            } else {
                this.canceled = true;
            }
        } else {
            this.setLocationRelativeTo(owner);
            this.setVisible(true);
        }
    }

    public IdentificationParametersSelectionDialog(Frame parentFrame, IdentificationParameters identificationParameters, StartupMode startupMode, ConfigurationFile configurationFile, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, ValidationQCPreferencesDialogParent validationQCPreferencesDialogParent, boolean editable) {
        super(parentFrame, true);
        this.editable = editable;
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.configurationFile = configurationFile;
        this.lastSelectedFolder = lastSelectedFolder;
        this.validationQCPreferencesDialogParent = validationQCPreferencesDialogParent;
        this.initComponents();
        this.setUpGui();
        this.populateGUI();
        if (identificationParameters != null) {
            if (startupMode == StartupMode.searchParameters) {
                this.editSearchSettings(identificationParameters);
            } else if (startupMode == StartupMode.advanced) {
                this.editAdvanced(identificationParameters);
            } else if (startupMode == StartupMode.none) {
                this.setLocationRelativeTo(parentFrame);
                this.setVisible(true);
            } else {
                throw new UnsupportedOperationException("Start-up mode " + (Object)((Object)startupMode) + " not implemented.");
            }
            String identificationParametersName = identificationParameters.getName();
            if (identificationParametersName == null || identificationParametersName.length() == 0) {
                this.canceled = true;
            } else {
                int row = this.getRow(identificationParametersName);
                if (row == -1) {
                    this.canceled = true;
                } else {
                    this.settingsTable.setRowSelectionInterval(row, row);
                }
            }
        } else if (this.identificationParametersFactory.getParametersList().isEmpty()) {
            this.addFromSearchSettings();
            if (this.settingsTable.getRowCount() > 0) {
                this.settingsTable.setRowSelectionInterval(0, 0);
            } else {
                this.canceled = true;
            }
        } else {
            this.setLocationRelativeTo(parentFrame);
            this.setVisible(true);
        }
    }

    public IdentificationParametersSelectionDialog(Frame parentFrame, ConfigurationFile configurationFile, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, ValidationQCPreferencesDialogParent validationQCPreferencesDialogParent, SearchSettingsDialog searchSettingsDialog) {
        super(parentFrame, true);
        SearchParameters searchParameters;
        IdentificationParameters identificationParameters;
        IdentificationParametersNameDialog identificationParametersNameDialog;
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.configurationFile = configurationFile;
        this.lastSelectedFolder = lastSelectedFolder;
        this.validationQCPreferencesDialogParent = validationQCPreferencesDialogParent;
        this.initComponents();
        this.setUpGui();
        this.populateGUI();
        searchSettingsDialog.setVisible(true);
        if (!searchSettingsDialog.isCanceled() && !(identificationParametersNameDialog = new IdentificationParametersNameDialog(parentFrame, identificationParameters = new IdentificationParameters(searchParameters = searchSettingsDialog.getSearchParameters()), true)).isCanceled()) {
            identificationParametersNameDialog.updateParameters(identificationParameters);
            try {
                this.identificationParametersFactory.addIdentificationParameters(identificationParameters);
                this.updateTable();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "An error occurred while saving the parameters. Please make sure that the tool can write in the user folder or change the Resource Settings.", "Save Error", 0);
            }
        }
    }

    private void setUpGui() {
        this.settingsTable.getColumn(" ").setMinWidth(30);
        this.settingsTable.getColumn(" ").setMaxWidth(30);
        this.settingsTable.getTableHeader().setReorderingAllowed(false);
        this.settingsTableScrollPane.getViewport().setOpaque(false);
    }

    public void populateGUI() {
        this.settingsTable.setModel(new SettingsTableModel());
        this.settingsTable.getColumn(" ").setMinWidth(30);
        this.settingsTable.getColumn(" ").setMaxWidth(30);
    }

    public void updateTable() {
        ((DefaultTableModel)this.settingsTable.getModel()).fireTableDataChanged();
        this.settingsTable.getColumn(" ").setMinWidth(50);
        this.settingsTable.getColumn(" ").setMaxWidth(50);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public IdentificationParameters getIdentificationParameters() {
        String identificationParametersName = this.getSelectedParametersName();
        return this.identificationParametersFactory.getIdentificationParameters(identificationParametersName);
    }

    private void initComponents() {
        this.parametersPopupMenu = new JPopupMenu();
        this.addMenu = new JMenu();
        this.addProtocolMenuItem = new JMenuItem();
        this.addSearchSettingsMenuItem = new JMenuItem();
        this.addFile = new JMenuItem();
        this.addDetailsMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.editProtocolMenuItem = new JMenuItem();
        this.editSearchSettingsMenuItem = new JMenuItem();
        this.editDetailsMenuItem = new JMenuItem();
        this.renameMenuItem = new JMenuItem();
        this.removeMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.tablePanel = new JPanel();
        this.settingsTableScrollPane = new JScrollPane();
        this.settingsTable = new JTable();
        this.helpLbl = new JLabel();
        this.addMenu.setText("Add");
        this.addProtocolMenuItem.setText("From Protocol (Beta)");
        this.addProtocolMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.addProtocolMenuItemActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addProtocolMenuItem);
        this.addSearchSettingsMenuItem.setText("New Search Settings");
        this.addSearchSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.addSearchSettingsMenuItemActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addSearchSettingsMenuItem);
        this.addFile.setText("Import from File");
        this.addFile.setToolTipText("");
        this.addFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.addFileActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addFile);
        this.addDetailsMenuItem.setText("Advanced");
        this.addDetailsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.addDetailsMenuItemActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addDetailsMenuItem);
        this.parametersPopupMenu.add(this.addMenu);
        this.editMenu.setText("Edit");
        this.editProtocolMenuItem.setText("Protocol (Beta)");
        this.editProtocolMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.editProtocolMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editProtocolMenuItem);
        this.editSearchSettingsMenuItem.setText("Search Settings");
        this.editSearchSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.editSearchSettingsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editSearchSettingsMenuItem);
        this.editDetailsMenuItem.setText("Advanced");
        this.editDetailsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.editDetailsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editDetailsMenuItem);
        this.parametersPopupMenu.add(this.editMenu);
        this.renameMenuItem.setText("Properties");
        this.renameMenuItem.setToolTipText("");
        this.renameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.renameMenuItemActionPerformed(evt);
            }
        });
        this.parametersPopupMenu.add(this.renameMenuItem);
        this.removeMenuItem.setText("Delete");
        this.removeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.removeMenuItemActionPerformed(evt);
            }
        });
        this.parametersPopupMenu.add(this.removeMenuItem);
        this.saveAsMenuItem.setText("Save as File");
        this.saveAsMenuItem.setToolTipText("");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.parametersPopupMenu.add(this.saveAsMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Identification Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IdentificationParametersSelectionDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.tablePanel.setBorder(BorderFactory.createTitledBorder("Identification Settings List"));
        this.tablePanel.setOpaque(false);
        this.settingsTableScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                IdentificationParametersSelectionDialog.this.settingsTableScrollPaneMouseReleased(evt);
            }
        });
        this.settingsTable.setModel(new SettingsTableModel());
        this.settingsTable.setSelectionMode(0);
        this.settingsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                IdentificationParametersSelectionDialog.this.settingsTableMouseReleased(evt);
            }
        });
        this.settingsTableScrollPane.setViewportView(this.settingsTable);
        this.helpLbl.setFont(new Font("Tahoma", 2, 11));
        this.helpLbl.setText("Right-click to edit the table.");
        GroupLayout tablePanelLayout = new GroupLayout(this.tablePanel);
        this.tablePanel.setLayout(tablePanelLayout);
        tablePanelLayout.setHorizontalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsTableScrollPane, -1, 602, Short.MAX_VALUE).addGroup(tablePanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpLbl).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        tablePanelLayout.setVerticalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsTableScrollPane, -1, 320, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.helpLbl).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void settingsTableMouseReleased(MouseEvent evt) {
        this.parametersTableClicked(evt, this.settingsTable);
    }

    private void settingsTableScrollPaneMouseReleased(MouseEvent evt) {
        this.parametersTableClicked(evt, this.settingsTableScrollPane);
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveAs(this.getSelectedParametersName());
    }

    private void removeMenuItemActionPerformed(ActionEvent evt) {
        this.remove(this.getSelectedParametersName());
    }

    private void addProtocolMenuItemActionPerformed(ActionEvent evt) {
        this.addFromProtocol();
    }

    private void addSearchSettingsMenuItemActionPerformed(ActionEvent evt) {
        this.addFromSearchSettings();
    }

    private void addDetailsMenuItemActionPerformed(ActionEvent evt) {
        this.addAdvanced();
    }

    private void editProtocolMenuItemActionPerformed(ActionEvent evt) {
        this.editProtocol(this.getSelectedParametersName());
    }

    private void editSearchSettingsMenuItemActionPerformed(ActionEvent evt) {
        this.editSearchSettings(this.getSelectedParametersName());
    }

    private void editDetailsMenuItemActionPerformed(ActionEvent evt) {
        this.editAdvanced(this.getSelectedParametersName());
    }

    private void renameMenuItemActionPerformed(ActionEvent evt) {
        this.rename(this.getSelectedParametersName());
    }

    private void addFileActionPerformed(ActionEvent evt) {
        this.addFromFile();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedParametersName() == null) {
            this.canceled = true;
        }
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void parametersTableClicked(MouseEvent evt, Component invoker) {
        int selectedRow = -1;
        if (evt != null && this.settingsTable.rowAtPoint(evt.getPoint()) != -1) {
            selectedRow = this.settingsTable.rowAtPoint(evt.getPoint());
        }
        if (selectedRow != -1) {
            this.settingsTable.setRowSelectionInterval(selectedRow, selectedRow);
        } else {
            this.settingsTable.removeRowSelectionInterval(0, this.settingsTable.getRowCount() - 1);
        }
        if (evt != null && evt.getButton() == 3) {
            this.editMenu.setVisible(selectedRow != -1);
            this.renameMenuItem.setVisible(selectedRow != -1);
            this.removeMenuItem.setVisible(selectedRow != -1);
            this.saveAsMenuItem.setVisible(selectedRow != -1);
            this.addProtocolMenuItem.setVisible(false);
            this.editProtocolMenuItem.setVisible(false);
            this.parametersPopupMenu.show(invoker, evt.getX(), evt.getY());
        }
        if (selectedRow != -1 && evt.getButton() == 1 && evt.getClickCount() == 2) {
            int selectedColumn = this.settingsTable.columnAtPoint(evt.getPoint());
            if (selectedColumn == 2) {
                this.rename(this.getSelectedParametersName());
            } else {
                this.editAdvanced(this.getSelectedParametersName());
            }
        }
    }

    private int getRow(String parameterName) {
        for (int row = 0; row < this.settingsTable.getRowCount(); ++row) {
            String name = this.settingsTable.getValueAt(row, 1).toString();
            if (!name.equals(parameterName)) continue;
            return row;
        }
        return -1;
    }

    private String getSelectedParametersName() {
        int row = this.settingsTable.getSelectedRow();
        if (row < 0 || row >= this.settingsTable.getRowCount()) {
            return null;
        }
        return this.settingsTable.getValueAt(row, 1).toString();
    }

    private void addFromProtocol() {
    }

    private void addFromSearchSettings() {
        SearchParameters defaultParameters = new SearchParameters();
        SearchSettingsDialog searchSettingsDialog = new SearchSettingsDialog(this, this.parentFrame, defaultParameters, this.normalIcon, this.waitingIcon, true, true, this.configurationFile, this.lastSelectedFolder, null, this.editable);
        if (!searchSettingsDialog.isCanceled()) {
            SearchParameters searchParameters = searchSettingsDialog.getSearchParameters();
            IdentificationParameters identificationParameters = new IdentificationParameters(searchParameters);
            this.checkNameAndUpdate(identificationParameters);
        }
    }

    private void checkNameAndUpdate(IdentificationParameters identificationParameters) {
        String oldName = identificationParameters.getName();
        IdentificationParametersNameDialog identificationParametersNameDialog = new IdentificationParametersNameDialog(this.parentFrame, identificationParameters, this.editable);
        if (!identificationParametersNameDialog.isCanceled()) {
            identificationParametersNameDialog.updateParameters(identificationParameters);
            this.updateParametersInFactory(identificationParameters, oldName);
        }
    }

    private void updateParametersInFactory(IdentificationParameters identificationParameters) {
        this.updateParametersInFactory(identificationParameters, null);
    }

    private void updateParametersInFactory(IdentificationParameters identificationParameters, String oldName) {
        try {
            if (oldName != null && oldName.length() > 0 && !oldName.equals(identificationParameters.getName())) {
                this.identificationParametersFactory.removeIdentificationParameters(oldName);
            }
            this.identificationParametersFactory.addIdentificationParameters(identificationParameters);
            this.updateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the parameters. Please make sure that the tool can write in the user folder or change the Resource Settings.", "Save Error", 0);
        }
    }

    private void addFromFile() {
        File startLocation = new File(this.lastSelectedFolder.getLastSelectedFolder());
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(".par") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Identification Settings File (.par)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            String fileName = file.getName();
            this.lastSelectedFolder.setLastSelectedFolder(file.getAbsolutePath());
            if (fileName.endsWith(".par")) {
                Object savedObject;
                block15: {
                    try {
                        IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
                        Class<MarshallableParameter> expectedObjectType = MarshallableParameter.class;
                        Object object = jsonMarshaller.fromJson(expectedObjectType, file);
                        MarshallableParameter marshallableParameter = (MarshallableParameter)object;
                        if (marshallableParameter.getType() == MarshallableParameter.Type.search_parameters) {
                            expectedObjectType = SearchParameters.class;
                            savedObject = jsonMarshaller.fromJson(expectedObjectType, file);
                            break block15;
                        }
                        if (marshallableParameter.getType() == MarshallableParameter.Type.identification_parameters) {
                            expectedObjectType = IdentificationParameters.class;
                            savedObject = jsonMarshaller.fromJson(expectedObjectType, file);
                            break block15;
                        }
                        JOptionPane.showMessageDialog(null, "Parameters file " + file + " not recognized. Please verify the search paramters file.", "File Error", 0);
                        return;
                    }
                    catch (Exception e1) {
                        try {
                            savedObject = SerializationUtils.readObject(file);
                        }
                        catch (Exception e2) {
                            e1.printStackTrace();
                            e2.printStackTrace();
                            JOptionPane.showMessageDialog(null, "Parameters file " + file + " not recognized. Please verify the search paramters file.", "File Error", 0);
                            return;
                        }
                    }
                }
                IdentificationParameters identificationParameters = null;
                if (savedObject instanceof SearchParameters) {
                    SearchParameters searchParameters = (SearchParameters)savedObject;
                    SearchSettingsDialog settingsDialog = new SearchSettingsDialog(this, this.parentFrame, searchParameters, this.normalIcon, this.waitingIcon, false, true, this.configurationFile, this.lastSelectedFolder, fileName, true);
                    boolean valid = settingsDialog.validateParametersInput(false);
                    if (!valid) {
                        settingsDialog.validateParametersInput(true);
                        settingsDialog.setVisible(true);
                    }
                    if (!settingsDialog.isCanceled()) {
                        identificationParameters = new IdentificationParameters(searchParameters);
                        identificationParameters.setName(Util.removeExtension(fileName));
                    }
                } else if (savedObject instanceof IdentificationParameters) {
                    identificationParameters = (IdentificationParameters)savedObject;
                } else {
                    throw new UnsupportedOperationException("Parameters of type " + savedObject.getClass() + " not supported.");
                }
                this.checkNameAndUpdate(identificationParameters);
            } else {
                JOptionPane.showMessageDialog(this, "Please select a valid search settings file (.par).", "File Error", 1);
            }
        }
    }

    private void addAdvanced() {
        SearchParameters searchParameters = new SearchParameters();
        IdentificationParameters identificationParameters = new IdentificationParameters(searchParameters);
        IdentificationParametersEditionDialog identificationParametersEditionDialog = new IdentificationParametersEditionDialog(this, this.parentFrame, identificationParameters, this.configurationFile, this.normalIcon, this.waitingIcon, this.lastSelectedFolder, this.validationQCPreferencesDialogParent, this.editable);
        if (!identificationParametersEditionDialog.isCanceled()) {
            identificationParameters = identificationParametersEditionDialog.getIdentificationParameters();
            this.updateParametersInFactory(identificationParameters);
        }
    }

    private void editProtocol(String parametersName) {
    }

    private void editSearchSettings(String parametersName) {
        IdentificationParameters identificationParameters = this.identificationParametersFactory.getIdentificationParameters(parametersName);
        this.editSearchSettings(identificationParameters);
    }

    private void editSearchSettings(IdentificationParameters identificationParameters) {
        SearchParameters newSearchParameters;
        String parametersName = identificationParameters.getName();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        SearchSettingsDialog searchSettingsDialog = new SearchSettingsDialog(this, this.parentFrame, searchParameters, this.normalIcon, this.waitingIcon, true, true, this.configurationFile, this.lastSelectedFolder, parametersName, this.editable);
        if (!searchSettingsDialog.isCanceled() && !searchParameters.equals(newSearchParameters = searchSettingsDialog.getSearchParameters())) {
            identificationParameters.setSearchParameters(newSearchParameters);
            this.checkNameAndUpdate(identificationParameters);
        }
    }

    private void editAdvanced(String parametersName) {
        IdentificationParameters identificationParameters = this.identificationParametersFactory.getIdentificationParameters(parametersName);
        this.editAdvanced(identificationParameters);
    }

    private void editAdvanced(IdentificationParameters identificationParameters) {
        if (identificationParameters == null) {
            JOptionPane.showMessageDialog(this, "An error occurred while reading the parameters.", "Error", 0);
        } else {
            String oldName = identificationParameters.getName();
            IdentificationParametersEditionDialog identificationParametersEditionDialog = new IdentificationParametersEditionDialog(this, this.parentFrame, identificationParameters, this.configurationFile, this.normalIcon, this.waitingIcon, this.lastSelectedFolder, this.validationQCPreferencesDialogParent, this.editable);
            if (!identificationParametersEditionDialog.isCanceled()) {
                identificationParameters = identificationParametersEditionDialog.getIdentificationParameters();
                this.updateParametersInFactory(identificationParameters, oldName);
            }
        }
    }

    private void rename(String parametersName) {
        IdentificationParameters identificationParameters = this.identificationParametersFactory.getIdentificationParameters(parametersName);
        if (identificationParameters == null) {
            JOptionPane.showMessageDialog(this, "An error occurred while reading the parameters.", "Error", 0);
        } else {
            this.checkNameAndUpdate(identificationParameters);
        }
    }

    private void remove(String parametersName) {
        this.identificationParametersFactory.removeIdentificationParameters(parametersName);
        this.updateTable();
    }

    private void saveAs(String parametersName) {
        File startLocation = new File(this.lastSelectedFolder.getLastSelectedFolder());
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(".par") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Identification Settings File (.par)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            String fileName = file.getName();
            if (!fileName.endsWith(".par")) {
                file = new File(file.getParent(), fileName + ".par");
            }
            this.lastSelectedFolder.setLastSelectedFolder(file.getAbsolutePath());
            IdentificationParameters identificationParameters = this.identificationParametersFactory.getIdentificationParameters(parametersName);
            try {
                SearchParameters.saveIdentificationParameters(identificationParameters.getSearchParameters(), file);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "An error occurred while saving the parameters. Please make sure that the file is not opened by another application.", "Save Error", 0);
            }
        }
    }

    private class SettingsTableModel
    extends DefaultTableModel {
        private ArrayList<String> parametersNames;

        @Override
        public int getRowCount() {
            if (IdentificationParametersSelectionDialog.this.identificationParametersFactory == null) {
                return 0;
            }
            this.parametersNames = IdentificationParametersSelectionDialog.this.identificationParametersFactory.getParametersList();
            return this.parametersNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    String parameterName = this.parametersNames.get(row);
                    IdentificationParameters identificationParameters = IdentificationParametersSelectionDialog.this.identificationParametersFactory.getIdentificationParameters(parameterName);
                    return identificationParameters.getName();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    public static enum StartupMode {
        searchParameters,
        advanced,
        none;

    }
}

