/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.compression;

import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER = 2048;

    public static void zip(File originFile, File destinationFile) throws IOException {
        ZipUtils.zip(originFile, destinationFile, null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File originFile, File destinationFile, WaitingHandler waitingHandler, long totalUncompressedFileSize) throws IOException {
        FileOutputStream fos = new FileOutputStream(destinationFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                ZipOutputStream out = new ZipOutputStream(bos);
                try {
                    ZipUtils.addToZip(originFile, out, waitingHandler, totalUncompressedFileSize);
                }
                finally {
                    out.close();
                }
            }
            finally {
                bos.close();
            }
        }
        finally {
            fos.close();
        }
    }

    public static void addToZip(File file, ZipOutputStream out) throws IOException {
        ZipUtils.addToZip(file, out, null, 0L);
    }

    public static void addToZip(File file, ZipOutputStream out, WaitingHandler waitingHandler, long totalUncompressedFileSize) throws IOException {
        ZipUtils.addToZip(file, "", out, waitingHandler, totalUncompressedFileSize);
    }

    public static void addToZip(File file, String subDirectory, ZipOutputStream out) throws IOException {
        ZipUtils.addToZip(file, subDirectory, out, null, 0L);
    }

    public static void addToZip(File file, String subDirectory, ZipOutputStream out, WaitingHandler waitingHandler, long totalUncompressedFileSize) throws IOException {
        if (file.isDirectory()) {
            String directory = subDirectory;
            if (!subDirectory.equals("")) {
                directory = directory + "/";
            }
            directory = directory + file.getName();
            ZipUtils.addFolderToZip(directory, out);
            for (File subFile : file.listFiles()) {
                ZipUtils.addToZip(subFile, subDirectory, out, waitingHandler, totalUncompressedFileSize);
            }
        } else {
            ZipUtils.addFileToZip(subDirectory, file, out, waitingHandler, totalUncompressedFileSize);
        }
    }

    public static void addFileToZip(File file, ZipOutputStream out, WaitingHandler waitingHandler, long totalUncompressedFileSize) throws IOException {
        ZipUtils.addFileToZip("", file, out, waitingHandler, totalUncompressedFileSize);
    }

    public static void addFileToZip(File file, ZipOutputStream out) throws IOException {
        ZipUtils.addFileToZip("", file, out, null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileToZip(String subDirectory, File file, ZipOutputStream out, WaitingHandler waitingHandler, long totalUncompressedFileSize) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Attempting to add a folder as a file. Use addToZip instead.");
        }
        FileInputStream fi = new FileInputStream(file);
        try {
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            try {
                int count;
                String entryName = subDirectory;
                if (!subDirectory.equals("")) {
                    entryName = entryName + "/";
                }
                entryName = entryName + file.getName();
                ZipEntry entry = new ZipEntry(entryName);
                out.putNextEntry(entry);
                byte[] data = new byte[2048];
                long write = 0L;
                int previousProgress = 0;
                if (waitingHandler != null) {
                    previousProgress = waitingHandler.getSecondaryProgressCounter();
                }
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    if (waitingHandler != null) {
                        if (waitingHandler.isRunCanceled()) {
                            return;
                        }
                        if (totalUncompressedFileSize > 0L) {
                            int progress = (int)(100.0 * (double)(write += (long)count) / (double)totalUncompressedFileSize) + previousProgress;
                            if (progress > 100) {
                                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                            } else {
                                waitingHandler.setSecondaryProgressCounter(progress);
                            }
                        } else {
                            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                        }
                    }
                    out.write(data, 0, count);
                }
            }
            finally {
                origin.close();
            }
        }
        finally {
            fi.close();
        }
    }

    public static void addFolderToZip(String folderPath, ZipOutputStream out) throws IOException {
        out.putNextEntry(new ZipEntry(folderPath + "/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destinationFolder, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        FileInputStream fi = new FileInputStream(zipFile);
        boolean isWindowsPlatform = System.getProperty("os.name").lastIndexOf("Windows") == -1;
        try {
            BufferedInputStream bis = new BufferedInputStream(fi, 2048);
            try {
                ZipInputStream zis = new ZipInputStream(bis);
                try {
                    ZipEntry entry;
                    long fileLength = 0L;
                    ZipFile tempZipFile = new ZipFile(zipFile);
                    Enumeration<? extends ZipEntry> e = tempZipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = e.nextElement();
                        fileLength += ze.getSize();
                    }
                    byte[] data = new byte[2048];
                    long read = 0L;
                    while ((entry = zis.getNextEntry()) != null) {
                        block29: {
                            String entryName = entry.getName();
                            entryName = isWindowsPlatform ? entryName.replaceAll("\\\\", "/") : entryName.replaceAll("/", "\\\\");
                            File destinationFile = new File(destinationFolder, entryName);
                            File entryFolder = destinationFile.getParentFile();
                            if (entry.isDirectory()) {
                                destinationFile.mkdirs();
                            } else {
                                if (entryFolder.exists() || entryFolder.mkdirs()) {
                                    FileOutputStream fos = new FileOutputStream(destinationFile);
                                    try {
                                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                                        try {
                                            int count;
                                            while ((count = zis.read(data, 0, 2048)) != -1) {
                                                bos.write(data, 0, count);
                                                if (waitingHandler == null) continue;
                                                if (waitingHandler.isRunCanceled()) {
                                                    return;
                                                }
                                                if (fileLength <= 0L) continue;
                                                int progress = (int)(100.0 * (double)(read += (long)count) / (double)fileLength);
                                                if (progress > 100) {
                                                    waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                                                    continue;
                                                }
                                                waitingHandler.setSecondaryProgressCounter(progress);
                                            }
                                            break block29;
                                        }
                                        finally {
                                            bos.close();
                                        }
                                    }
                                    finally {
                                        fos.close();
                                    }
                                }
                                throw new IOException("Folder " + destinationFolder.getAbsolutePath() + " does not exist and could not be created. Verify that you have the right to write in this directory.");
                            }
                        }
                        if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                        break;
                    }
                }
                finally {
                    zis.close();
                }
            }
            finally {
                bis.close();
            }
        }
        finally {
            fi.close();
        }
    }
}

