/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein_sequences_manager.gui;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.protein_sequences_manager.ProteinSequencesManager;
import com.compomics.util.protein_sequences_manager.enums.SequenceInputType;
import com.compomics.util.protein_sequences_manager.gui.preferences.ProteinSequencesPreferencesDialog;
import com.compomics.util.protein_sequences_manager.gui.sequences_import.ImportSequencesFromDnaDialog;
import com.compomics.util.protein_sequences_manager.gui.sequences_import.ImportSequencesFromFilesDialog;
import com.compomics.util.protein_sequences_manager.gui.sequences_import.ImportSequencesFromUniprotDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class ProteinSequencesManagerGUI
extends JDialog {
    private static ProgressDialogX progressDialog;
    private Frame parentFrame;
    private UtilitiesUserPreferences utilitiesUserPreferences = null;
    private ProteinSequencesManager proteinSequencesManager;
    private final String[] yesNo = new String[]{"Yes", "No"};
    private final String notAvailable = "Not Available";
    private Image waitingImage;
    private Image normalImange;
    private HashMap<String, String> selectedVersion;
    private HashMap<String, String> reviewedSelection;
    private HashMap<String, String> isoformsSelection;
    private HashMap<String, String> contaminantsSelection;
    private HashMap<String, String> decoySelection;
    private JMenuItem aboutMenuItem;
    private JMenuItem andromedaExportMenu;
    private JPanel backgroundPanel;
    private JMenuItem bugReportMenuItem;
    private JButton cancelButton;
    private JMenuItem configMenuItem;
    private JPanel dbPanel;
    private JTable dbTable;
    private JScrollPane dbTableScrollPane;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu exportMenu;
    private JMenu fileMenu;
    private JMenuBar fileMenuBar;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JMenuItem importFromDNAMenuItem;
    private JMenuItem importFromFileMenuItem;
    private JMenuItem importFromUnitprot;
    private JMenu importMenu;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JButton okButton;

    public static void main(String[] args) {
        ProteinSequencesManagerGUI m = new ProteinSequencesManagerGUI(null, null, null);
    }

    public ProteinSequencesManagerGUI(Frame parent, Image normalImange, Image waitingImage) {
        super(parent, true);
        this.initComponents();
        this.parentFrame = parent;
        this.setTitle("Protein Sequences Manager");
        this.setUpGui();
        this.setVisible(true);
    }

    public void setUpGui() {
        this.checkSetup();
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Importing Databases. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("importThread"){

            @Override
            public void run() {
                progressDialog.setTitle("Importing Databases. Please Wait...");
                ProteinSequencesManagerGUI.this.importFromFileMenuItem.setEnabled(true);
                ProteinSequencesManagerGUI.this.importFromUnitprot.setEnabled(true);
                ProteinSequencesManagerGUI.this.importFromDNAMenuItem.setEnabled(true);
                ProteinSequencesManagerGUI.this.proteinSequencesManager = new ProteinSequencesManager();
                if (!progressDialog.isRunCanceled()) {
                    ProteinSequencesManagerGUI.this.setUpTable();
                    ArrayList<String> databaseNames = ProteinSequencesManagerGUI.this.proteinSequencesManager.getDatabaseNames();
                    ProteinSequencesManagerGUI.this.selectedVersion = new HashMap(databaseNames.size());
                    ProteinSequencesManagerGUI.this.reviewedSelection = new HashMap(databaseNames.size());
                    ProteinSequencesManagerGUI.this.isoformsSelection = new HashMap(databaseNames.size());
                    ProteinSequencesManagerGUI.this.contaminantsSelection = new HashMap(databaseNames.size());
                    ProteinSequencesManagerGUI.this.decoySelection = new HashMap(databaseNames.size());
                    ProteinSequencesManagerGUI.this.updateGUI();
                } else {
                    ProteinSequencesManagerGUI.this.close();
                }
                progressDialog.setRunFinished();
            }
        }.start();
    }

    public void checkSetup() {
        boolean error = false;
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (this.utilitiesUserPreferences.getProteinSequencesManagerFolder() == null || !this.utilitiesUserPreferences.getProteinSequencesManagerFolder().exists()) {
            error = true;
            JOptionPane.showMessageDialog(this, new String[]{"Please select a folder to store the databases."}, "Configuration", 1);
        }
        if (error) {
            new ProteinSequencesPreferencesDialog(this.parentFrame);
            this.checkSetup();
        }
    }

    public void updateGUI() {
        ArrayList<String> databaseNames = this.proteinSequencesManager.getDatabaseNames();
        this.exportMenu.setEnabled(!databaseNames.isEmpty());
        for (String databaseName : databaseNames) {
            SequenceInputType sequenceInputType = this.proteinSequencesManager.getInputType(databaseName);
            ArrayList<String> versionNames = this.proteinSequencesManager.getVersionsForDb(databaseName);
            if (this.selectedVersion.containsKey(databaseName)) continue;
            this.selectedVersion.put(databaseName, versionNames.get(versionNames.size() - 1));
            if (sequenceInputType == SequenceInputType.uniprot) {
                this.reviewedSelection.put(databaseName, this.yesNo[0]);
                this.isoformsSelection.put(databaseName, this.yesNo[1]);
            } else {
                this.reviewedSelection.put(databaseName, "Not Available");
                this.isoformsSelection.put(databaseName, "Not Available");
            }
            this.contaminantsSelection.put(databaseName, this.yesNo[0]);
            this.decoySelection.put(databaseName, this.yesNo[0]);
        }
        this.updateTable();
    }

    public void setUpTable() {
        DatabasesTableModel tableModel = new DatabasesTableModel();
        this.dbTable.setModel(tableModel);
        TableColumnModel tableColumnModel = this.dbTable.getColumnModel();
        this.dbTable.getTableHeader().setReorderingAllowed(false);
        this.dbTableScrollPane.getViewport().setOpaque(false);
        tableColumnModel.getColumn(0).setMaxWidth(50);
        tableColumnModel.getColumn(10).setMaxWidth(50);
    }

    public void updateTable() {
        ((DefaultTableModel)this.dbTable.getModel()).fireTableDataChanged();
        this.dbTable.setCellEditor(new DatabasesTableCellEditor());
    }

    public void close() {
        Util.deleteDir(this.proteinSequencesManager.getTempFolder());
        this.dispose();
    }

    private void initComponents() {
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.dbPanel = new JPanel();
        this.dbTableScrollPane = new JScrollPane();
        this.dbTable = new JTable();
        this.fileMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.importMenu = new JMenu();
        this.importFromUnitprot = new JMenuItem();
        this.importFromFileMenuItem = new JMenuItem();
        this.importFromDNAMenuItem = new JMenuItem();
        this.exportMenu = new JMenu();
        this.andromedaExportMenu = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.configMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.bugReportMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.aboutMenuItem = new JMenuItem();
        this.jMenu1.setText("jMenu1");
        this.jMenuItem1.setText("jMenuItem1");
        this.jMenuItem2.setText("jMenuItem2");
        this.setDefaultCloseOperation(2);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinSequencesManagerGUI.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinSequencesManagerGUI.this.okButtonActionPerformed(evt);
            }
        });
        this.dbPanel.setBorder(BorderFactory.createTitledBorder("Sequence Databases"));
        this.dbPanel.setOpaque(false);
        this.dbTable.setModel(new DatabasesTableModel());
        this.dbTableScrollPane.setViewportView(this.dbTable);
        GroupLayout dbPanelLayout = new GroupLayout(this.dbPanel);
        this.dbPanel.setLayout(dbPanelLayout);
        dbPanelLayout.setHorizontalGroup(dbPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dbPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dbTableScrollPane, -1, 1149, Short.MAX_VALUE).addContainerGap()));
        dbPanelLayout.setVerticalGroup(dbPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dbPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dbTableScrollPane).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dbPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dbPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.fileMenu.setText("File");
        this.importMenu.setText("Import From...");
        this.importFromUnitprot.setText("UniProtKB");
        this.importFromUnitprot.setEnabled(false);
        this.importFromUnitprot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinSequencesManagerGUI.this.importFromUnitprotActionPerformed(evt);
            }
        });
        this.importMenu.add(this.importFromUnitprot);
        this.importFromFileMenuItem.setText("Fasta File(s)");
        this.importFromFileMenuItem.setEnabled(false);
        this.importFromFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinSequencesManagerGUI.this.importFromFileMenuItemActionPerformed(evt);
            }
        });
        this.importMenu.add(this.importFromFileMenuItem);
        this.importFromDNAMenuItem.setText("DNA Sequences");
        this.importFromDNAMenuItem.setEnabled(false);
        this.importFromDNAMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinSequencesManagerGUI.this.importFromDNAMenuItemActionPerformed(evt);
            }
        });
        this.importMenu.add(this.importFromDNAMenuItem);
        this.fileMenu.add(this.importMenu);
        this.exportMenu.setText("Export...");
        this.andromedaExportMenu.setText("Andromeda Config. File");
        this.exportMenu.add(this.andromedaExportMenu);
        this.fileMenu.add(this.exportMenu);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.fileMenu.add(this.exitMenuItem);
        this.fileMenuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.configMenuItem.setText("Configuration");
        this.configMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinSequencesManagerGUI.this.configMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.configMenuItem);
        this.fileMenuBar.add(this.editMenu);
        this.helpMenu.setText("Help");
        this.helpMenuItem.setText("Help");
        this.helpMenu.add(this.helpMenuItem);
        this.bugReportMenuItem.setText("Bug Report");
        this.helpMenu.add(this.bugReportMenuItem);
        this.helpMenu.add(this.jSeparator2);
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.fileMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.fileMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void importFromFileMenuItemActionPerformed(ActionEvent evt) {
        File selectedFile;
        ImportSequencesFromFilesDialog importSequencesFromFilesDialog = new ImportSequencesFromFilesDialog(this.parentFrame, this.normalImange, this.waitingImage);
        if (!importSequencesFromFilesDialog.isCanceled() && (selectedFile = importSequencesFromFilesDialog.getSelectedFile()) != null) {
            this.importNewFile(selectedFile, SequenceInputType.user);
        }
    }

    private void configMenuItemActionPerformed(ActionEvent evt) {
        new ProteinSequencesPreferencesDialog(this.parentFrame);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        UtilitiesUserPreferences.saveUserPreferences(this.utilitiesUserPreferences);
        this.close();
    }

    private void importFromUnitprotActionPerformed(ActionEvent evt) {
        File selectedFile;
        ImportSequencesFromUniprotDialog importSequencesFromUniprotDialog = new ImportSequencesFromUniprotDialog(this.parentFrame);
        if (!importSequencesFromUniprotDialog.isCanceled() && (selectedFile = importSequencesFromUniprotDialog.getSelectedFile()) != null) {
            this.importNewFile(selectedFile, SequenceInputType.user);
        }
    }

    private void importFromDNAMenuItemActionPerformed(ActionEvent evt) {
        File selectedFile;
        ImportSequencesFromDnaDialog importSequencesFromDnaDialog = new ImportSequencesFromDnaDialog(this.parentFrame);
        if (!importSequencesFromDnaDialog.isCanceled() && (selectedFile = importSequencesFromDnaDialog.getSelectedFile()) != null) {
            this.importNewFile(selectedFile, SequenceInputType.user);
        }
    }

    public void importNewFile(final File selectedFile, SequenceInputType sequenceInputType) {
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Importing Database. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("importThread"){

            @Override
            public void run() {
                progressDialog.setTitle("Importing Database. Please Wait...");
                try {
                    ProteinSequencesManagerGUI.this.proteinSequencesManager.addFastaFile(selectedFile, SequenceInputType.user, progressDialog);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "An error occurred while importing " + selectedFile.getName() + ", please make sure that the tool can write in the working folder.", "Error", 0);
                    ProteinSequencesManagerGUI.this.checkSetup();
                    return;
                }
                catch (StringIndexOutOfBoundsException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(ProteinSequencesManagerGUI.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (IllegalArgumentException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(ProteinSequencesManagerGUI.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                if (!progressDialog.isRunCanceled()) {
                    ProteinSequencesManagerGUI.this.updateGUI();
                }
                progressDialog.setRunFinished();
            }
        }.start();
    }

    private class DatabasesTableCellEditor
    implements TableCellEditor {
        private HashMap<Integer, HashMap<Integer, DefaultCellEditor>> cellEditorsMap;
        private DefaultCellEditor lastAccessedEditor = null;

        public DatabasesTableCellEditor() {
            JComboBox<Object> comboBox = new JComboBox<String>(ProteinSequencesManagerGUI.this.yesNo);
            DefaultCellEditor yesNo = new DefaultCellEditor(comboBox);
            ArrayList<String> databaseNames = ProteinSequencesManagerGUI.this.proteinSequencesManager.getDatabaseNames();
            this.cellEditorsMap = new HashMap(databaseNames.size());
            for (int row = 0; row < databaseNames.size(); ++row) {
                String databaseName = databaseNames.get(row);
                SequenceInputType sequenceInputType = ProteinSequencesManagerGUI.this.proteinSequencesManager.getInputType(databaseName);
                HashMap<Integer, DefaultCellEditor> rowCellEditors = new HashMap<Integer, DefaultCellEditor>(5);
                comboBox = new JComboBox<Object>(ProteinSequencesManagerGUI.this.proteinSequencesManager.getVersionsForDb(databaseName).toArray());
                DefaultCellEditor version = new DefaultCellEditor(comboBox);
                rowCellEditors.put(3, version);
                if (sequenceInputType == SequenceInputType.uniprot) {
                    rowCellEditors.put(6, yesNo);
                    rowCellEditors.put(7, yesNo);
                }
                rowCellEditors.put(8, yesNo);
                rowCellEditors.put(9, yesNo);
                this.cellEditorsMap.put(row, rowCellEditors);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DefaultCellEditor defaultCellEditor;
            HashMap<Integer, DefaultCellEditor> rowMap = this.cellEditorsMap.get(row);
            if (rowMap != null && (defaultCellEditor = rowMap.get(column)) != null) {
                this.lastAccessedEditor = defaultCellEditor;
                return defaultCellEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.lastAccessedEditor != null) {
                return this.lastAccessedEditor.getCellEditorValue();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.lastAccessedEditor != null;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.lastAccessedEditor == null) {
                return true;
            }
            return this.lastAccessedEditor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this.lastAccessedEditor != null) {
                this.lastAccessedEditor.cancelCellEditing();
            }
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            if (this.lastAccessedEditor != null) {
                this.lastAccessedEditor.addCellEditorListener(l);
            }
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            if (this.lastAccessedEditor != null) {
                this.lastAccessedEditor.removeCellEditorListener(l);
            }
        }
    }

    private class DatabasesTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (ProteinSequencesManagerGUI.this.proteinSequencesManager == null) {
                return 0;
            }
            return ProteinSequencesManagerGUI.this.proteinSequencesManager.getDatabaseNames().size();
        }

        @Override
        public int getColumnCount() {
            return 11;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Version";
                }
                case 4: {
                    return "#Sequences";
                }
                case 5: {
                    return "Description";
                }
                case 6: {
                    return "Reviewed";
                }
                case 7: {
                    return "Isoforms";
                }
                case 8: {
                    return "Contaminants";
                }
                case 9: {
                    return "Decoy";
                }
                case 10: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String databaseName = ProteinSequencesManagerGUI.this.proteinSequencesManager.getDatabaseNames().get(row);
            String version = (String)ProteinSequencesManagerGUI.this.selectedVersion.get(databaseName);
            FastaIndex fastaIndex = ProteinSequencesManagerGUI.this.proteinSequencesManager.getFastaIndex(databaseName, version);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return fastaIndex.getMainDatabaseType().getFullName();
                }
                case 2: {
                    return databaseName;
                }
                case 3: {
                    return version;
                }
                case 4: {
                    return fastaIndex.getNTarget();
                }
                case 5: {
                    return fastaIndex.getDescription();
                }
                case 6: {
                    return ProteinSequencesManagerGUI.this.reviewedSelection.get(databaseName);
                }
                case 7: {
                    return ProteinSequencesManagerGUI.this.isoformsSelection.get(databaseName);
                }
                case 8: {
                    return ProteinSequencesManagerGUI.this.contaminantsSelection.get(databaseName);
                }
                case 9: {
                    return ProteinSequencesManagerGUI.this.decoySelection.get(databaseName);
                }
                case 10: {
                    return "+";
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
        }

        public Class getColumnClass(int column) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, column) == null) continue;
                return this.getValueAt(i, column).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            String databaseName = ProteinSequencesManagerGUI.this.proteinSequencesManager.getDatabaseNames().get(row);
            SequenceInputType sequenceInputType = ProteinSequencesManagerGUI.this.proteinSequencesManager.getInputType(databaseName);
            return column == 3 || column == 6 && sequenceInputType == SequenceInputType.uniprot || column == 7 && sequenceInputType == SequenceInputType.uniprot || column == 8 || column == 9;
        }
    }
}

