/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzidentml.example;

import com.google.common.base.Stopwatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzidentml.MzIdentMLParser;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.AbstractParamType;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.MzIdentMLType;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.PeptideEvidenceType;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.UserParamType;

public class MzIdentMlReadWriteExample {
    public static void main(String[] args) throws FileParsingException, XMLStreamException, JAXBException, IOException {
        if (args.length < 1) {
            throw new IllegalArgumentException("You must specify the filepath using command line arguments");
        }
        Path pathIn = Paths.get(args[0], new String[0]).toAbsolutePath();
        if (!Files.exists(pathIn, new LinkOption[0])) {
            throw new FileNotFoundException("Input file does not exist: " + pathIn.toString());
        }
        System.out.println("Will inject values into: " + pathIn.toString());
        Path file = pathIn.getFileName();
        Path dir = pathIn.getParent();
        Stopwatch timer = Stopwatch.createUnstarted();
        double sizeInMb = (double)pathIn.toFile().length() / 1048576.0;
        System.out.printf("Parsing file (%.2fMB)\n", sizeInMb);
        timer.reset().start();
        MzIdentMLType mzid = MzIdentMLParser.parse(pathIn);
        timer.stop();
        double elapsedSec = (double)timer.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.printf("Done reading in (%.2fs, %.2fMB/s).\n", elapsedSec, sizeInMb / elapsedSec);
        timer.reset().start();
        List<PeptideEvidenceType> pepEvidence = mzid.getSequenceCollection().getPeptideEvidence();
        for (PeptideEvidenceType psm : pepEvidence) {
            List<AbstractParamType> paramGroup = psm.getParamGroup();
            UserParamType u = new UserParamType();
            u.setName("myName");
            u.setType("myType");
            u.setUnitAccession("myUnitAccession");
            u.setUnitName("myUnitName");
            u.setValue("myValue");
            paramGroup.add(u);
        }
        timer.stop();
        System.out.printf("Done modifying (%.2f).\n", (double)timer.elapsed(TimeUnit.MILLISECONDS) / 1000.0);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MzIdentMLType.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        String fileOut = file + ".out.ignore";
        Path pathOut = dir.resolve(fileOut);
        Files.createDirectories(pathOut.getParent(), new FileAttribute[0]);
        timer.reset().start();
        marshaller.marshal((Object)mzid, pathOut.toFile());
        timer.stop();
        System.out.printf("Done writing output (%.2fs).\n", (double)timer.elapsed(TimeUnit.MILLISECONDS) / 1000.0);
    }
}

