/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.bruker.timstof.model;

import fr.profi.bruker.timstof.model.Spectrum;
import fr.profi.bruker.timstof.model.SpectrumGeneratingMethod;
import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import it.unimi.dsi.fastutil.doubles.Double2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimsFrame
implements Comparable<AbstractTimsFrame> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTimsFrame.class);
    protected int m_id;
    protected int m_nbrScans;
    protected int m_nbrPeaks;
    protected ScanMode m_scanMode;
    private MsMsType m_msmsType;
    protected double m_time;
    protected int m_maxIntensity;
    protected int m_summedIntensity;
    protected boolean m_spectrumDataSet = false;
    protected Spectrum m_singleSpectrum = null;
    static Int2ObjectMap<MsMsType> msmsTypeByCode = new Int2ObjectOpenHashMap();
    static Int2ObjectMap<ScanMode> scanModesByCode = new Int2ObjectOpenHashMap();

    @Override
    public int compareTo(AbstractTimsFrame o) {
        if (o == null) {
            return 1;
        }
        return (int)(this.getTime() - o.getTime());
    }

    public AbstractTimsFrame(int id, int nbrScans, int nbrPeaks, int scanMode, MsMsType msmsType, int maxIntensity, int summedIntensity, double time) {
        this.m_id = id;
        this.m_nbrScans = nbrScans;
        this.m_nbrPeaks = nbrPeaks;
        this.m_scanMode = ScanMode.findByCode(scanMode);
        this.m_msmsType = msmsType;
        this.m_maxIntensity = maxIntensity;
        this.m_summedIntensity = summedIntensity;
        this.m_time = time;
    }

    public int getId() {
        return this.m_id;
    }

    public int getNbrScans() {
        return this.m_nbrScans;
    }

    public int getNbrPeaks() {
        return this.m_nbrPeaks;
    }

    public ScanMode getScanMode() {
        return this.m_scanMode;
    }

    public MsMsType getMsmsType() {
        return this.m_msmsType;
    }

    public double getTime() {
        return this.m_time;
    }

    public int getMaxIntensity() {
        return this.m_maxIntensity;
    }

    public int getSummedIntensity() {
        return this.m_summedIntensity;
    }

    public void clearSpectraData() {
        if (this.m_singleSpectrum != null) {
            this.m_singleSpectrum = null;
        }
        this.m_spectrumDataSet = false;
    }

    public abstract ObjectList<Spectrum> getAllSpectra();

    protected abstract void createSingleSpectrum(SpectrumGeneratingMethod var1);

    public abstract void setMassIntensityByScan(Int2ObjectMap<Double2FloatMap> var1);

    public boolean spectrumRead() {
        return this.m_spectrumDataSet;
    }

    public int getSpectrumCount() {
        return -1;
    }

    protected void createSingleSpFromAllSpectra() {
        Double2FloatOpenHashMap retainedMasses2Intensity = new Double2FloatOpenHashMap();
        ObjectList<Spectrum> allSp = this.getAllSpectra();
        for (Spectrum sp : allSp) {
            double[] spMasses = sp.getMasses();
            float[] spIntensities = sp.getIntensities();
            for (int i = 0; i < spMasses.length; ++i) {
                float newIntensity;
                double nextMass = spMasses[i];
                float currentIntensity = retainedMasses2Intensity.getOrDefault(nextMass, 0.0f);
                if (!(currentIntensity < (newIntensity = spIntensities[i]))) continue;
                retainedMasses2Intensity.put(nextMass, newIntensity);
            }
        }
        int msLevel = this.m_msmsType.equals((Object)MsMsType.MS) ? 1 : 2;
        this.m_singleSpectrum = new Spectrum("Frame_" + this.m_id, msLevel, (float)this.m_time, (Double2FloatMap)retainedMasses2Intensity);
    }

    public Spectrum getSingleSpectrum(SpectrumGeneratingMethod msCreateMethod) {
        if (!this.m_spectrumDataSet) {
            return null;
        }
        if (this.m_singleSpectrum == null) {
            this.createSingleSpectrum(msCreateMethod);
        }
        return this.m_singleSpectrum;
    }

    public static enum ScanMode {
        MS(0),
        AutoMSMS(1),
        MRM(2),
        IN_SOURCE_CID(3),
        BROADBAND_CID(4),
        PASEF(8),
        DIA(9);

        int m_modeCode;

        private ScanMode(int modeCode) {
            this.m_modeCode = modeCode;
            scanModesByCode.put(modeCode, (Object)this);
        }

        public Integer getScanModeCode() {
            return this.m_modeCode;
        }

        public static ScanMode findByCode(int code) {
            return (ScanMode)((Object)scanModesByCode.get(code));
        }
    }

    public static enum MsMsType {
        MS(0),
        MSMS(2),
        PASEF(8),
        DIA(9);

        int m_msmsTypeCode;

        private MsMsType(int msmsTypeCode) {
            this.m_msmsTypeCode = msmsTypeCode;
            msmsTypeByCode.put(msmsTypeCode, (Object)this);
        }

        public Integer getMsMsTypeCode() {
            return this.m_msmsTypeCode;
        }

        public static MsMsType findByCode(int code) {
            return (MsMsType)((Object)msmsTypeByCode.get(code));
        }
    }
}

